//clear all; clc; close all;

//include model equations
@#include "model.mod"

options_.noprint=1;
options_.nodisplay=1; 

//calculate steady state and do some checks  
//resid; 
steady; 
//check; 

//prepare options for det. simul 
options_.slowc=1; 
options_.simul.maxit=10;
warning off;  
 
options_.solve_tolf: 1.0000e-7;
options_.solve_tolx: 3.6669e-9;
options_.dynatol.f=1e-7;

//shock sizes
techshock=0.074;
moposhock=0.04;
markupshock=-0.115;
consdemshock=-0.11;
discountfactorshock=0.0042;
govconsshock=-.412;

/////////////////////////////
//Technology shock
////////////////////////////
shocks;   
var zV_eps;  %technology
periods 1:1; 
values(techshock);

var RV_eps;  %monetary policy
periods 1:1; 
values(0); 

var mcV_eps;  %markup
periods 1:1; 
values(0); 

var nuV_eps;  %cons. demand   
periods 1:1; 
values(0); 

var deltaV_eps;  %discount factor shock
periods 1:1; 
values(0); 

var gV_eps;  %gov. cons
periods 1:1; 
values(0); 
 
end;
simul(periods=300,stack_solve_algo=0); 

oo_endo_simul_base=oo_.endo_simul; 
oo_steady_state_base=oo_.steady_state;
figtitle=['Impulse Responses to Technology Shock']; 
legstring=[{'Nonlinear Model'},{'Linearized Model'}]; 
skip_ini_period=0;
plot_results; 

xV_nonlin_tech=oo_endo_simul_base_nonlin(1,1:show_horz)*100;
piV_nonlin_tech=(oo_endo_simul_base_nonlin(2,1:show_horz)-1)*400;
RV_nonlin_tech=(oo_endo_simul_base_nonlin(3,1:show_horz)-1)*400;
RpotV_nonlin_tech=(oo_endo_simul_base_nonlin(5,1:show_horz)-1)*400;
xV_lin_tech=oo_endo_simul_base_lin(1,1:show_horz)*100;
piV_lin_tech=(oo_endo_simul_base_lin(2,1:show_horz)-1)*400;
RV_lin_tech=(oo_endo_simul_base_lin(3,1:show_horz)-1)*400;
RpotV_lin_tech=(oo_endo_simul_base_lin(5,1:show_horz)-1)*400;


/////////////////////////////
//Monetary Policy Shock
////////////////////////////
shocks;   
var zV_eps;  %technology
periods 1:1; 
values(0); 

var RV_eps;  %monetary policy
periods 1:1; 
values(moposhock);

var mcV_eps;  %markup
periods 1:1; 
values(0); 

var nuV_eps;  %cons. demand   
periods 1:1; 
values(0); 

var deltaV_eps;  %discount factor shock
periods 1:1; 
values(0); 

var gV_eps;  %gov. cons
periods 1:1; 
values(0); 
 
end;
simul(periods=300,stack_solve_algo=0); 

oo_endo_simul_base=oo_.endo_simul; 
oo_steady_state_base=oo_.steady_state;
figtitle=['Impulse Responses to Monetary Policy Shock']; 
legstring=[{'Nonlinear Model'},{'Linearized Model'}]; 
skip_ini_period=0;
plot_results; 

xV_nonlin_mopo=oo_endo_simul_base_nonlin(1,1:show_horz)*100;
piV_nonlin_mopo=(oo_endo_simul_base_nonlin(2,1:show_horz)-1)*400;
RV_nonlin_mopo=(oo_endo_simul_base_nonlin(3,1:show_horz)-1)*400;
RpotV_nonlin_mopo=(oo_endo_simul_base_nonlin(5,1:show_horz)-1)*400;
xV_lin_mopo=oo_endo_simul_base_lin(1,1:show_horz)*100;
piV_lin_mopo=(oo_endo_simul_base_lin(2,1:show_horz)-1)*400;
RV_lin_mopo=(oo_endo_simul_base_lin(3,1:show_horz)-1)*400;
RpotV_lin_mopo=(oo_endo_simul_base_lin(5,1:show_horz)-1)*400;


/////////////////////////////
//Markup Shock
////////////////////////////
shocks;
var zV_eps;  %technology
periods 1:1; 
values(0); 

var RV_eps;  %monetary policy
periods 1:1; 
values(0); 

var mcV_eps;  %markup
periods 1:1; 
values(markupshock); 

var nuV_eps;  %cons. demand   
periods 1:1; 
values(0); 

var deltaV_eps;  %discount factor shock
periods 1:1; 
values(0); 

var gV_eps;  %gov. cons
periods 1:1; 
values(0); 

end;
simul(periods=300,stack_solve_algo=0); 

oo_endo_simul_base=oo_.endo_simul; 
oo_steady_state_base=oo_.steady_state;
figtitle=['Impulse Responses to Markup Shock']; 
legstring=[{'Nonlinear Model'},{'Linearized Model'}]; 
skip_ini_period=0;
plot_results; 

xV_nonlin_mkp=oo_endo_simul_base_nonlin(1,1:show_horz)*100;
piV_nonlin_mkp=(oo_endo_simul_base_nonlin(2,1:show_horz)-1)*400;
RV_nonlin_mkp=(oo_endo_simul_base_nonlin(3,1:show_horz)-1)*400;
RpotV_nonlin_mkp=(oo_endo_simul_base_nonlin(5,1:show_horz)-1)*400;
xV_lin_mkp=oo_endo_simul_base_lin(1,1:show_horz)*100;
piV_lin_mkp=(oo_endo_simul_base_lin(2,1:show_horz)-1)*400;
RV_lin_mkp=(oo_endo_simul_base_lin(3,1:show_horz)-1)*400;
RpotV_lin_mkp=(oo_endo_simul_base_lin(5,1:show_horz)-1)*400;

/////////////////////////////
//Consumption Demand Shock
////////////////////////////
shocks;   
var zV_eps;  %technology
periods 1:1; 
values(0); 

var RV_eps;  %monetary policy
periods 1:1; 
values(0);

var mcV_eps;  %markup
periods 1:1; 
values(0); 

var nuV_eps;  %cons. demand   
periods 1:1; 
values(consdemshock); 

var deltaV_eps;  %discount factor shock
periods 1:1; 
values(0); 

var gV_eps;  %gov. cons
periods 1:1; 
values(0); 
end;
simul(periods=300,stack_solve_algo=0); 

oo_endo_simul_base=oo_.endo_simul; 
oo_steady_state_base=oo_.steady_state;
figtitle=['Impulse Responses to Consumption Demand Shock']; 
legstring=[{'Nonlinear Model'},{'Linearized Model'}]; 
skip_ini_period=0;
plot_results; 

xV_nonlin_consdem=oo_endo_simul_base_nonlin(1,1:show_horz)*100;
piV_nonlin_consdem=(oo_endo_simul_base_nonlin(2,1:show_horz)-1)*400;
RV_nonlin_consdem=(oo_endo_simul_base_nonlin(3,1:show_horz)-1)*400;
RpotV_nonlin_consdem=(oo_endo_simul_base_nonlin(5,1:show_horz)-1)*400;
xV_lin_consdem=oo_endo_simul_base_lin(1,1:show_horz)*100;
piV_lin_consdem=(oo_endo_simul_base_lin(2,1:show_horz)-1)*400;
RV_lin_consdem=(oo_endo_simul_base_lin(3,1:show_horz)-1)*400;
RpotV_lin_consdem=(oo_endo_simul_base_lin(5,1:show_horz)-1)*400;




/////////////////////////////
//Discount Factor Shock
////////////////////////////
shocks;   
var zV_eps;  %technology
periods 1:1; 
values(0); 

var RV_eps;  %monetary policy
periods 1:1; 
values(0);

var mcV_eps;  %markup
periods 1:1; 
values(0); 

var nuV_eps;  %cons. demand   
periods 1:1; 
values(0); 

var deltaV_eps;  %discount factor shock
periods 1:1; 
values(discountfactorshock); 

var gV_eps;  %gov. cons
periods 1:1; 
values(0); 
end;
simul(periods=300,stack_solve_algo=0); 

oo_endo_simul_base=oo_.endo_simul; 
oo_steady_state_base=oo_.steady_state;
figtitle=['Impulse Responses to Discount Factor Shock']; 
legstring=[{'Nonlinear Model'},{'Linearized Model'}]; 
skip_ini_period=0;
plot_results; 

xV_nonlin_disc=oo_endo_simul_base_nonlin(1,1:show_horz)*100;
piV_nonlin_disc=(oo_endo_simul_base_nonlin(2,1:show_horz)-1)*400;
RV_nonlin_disc=(oo_endo_simul_base_nonlin(3,1:show_horz)-1)*400;
RpotV_nonlin_disc=(oo_endo_simul_base_nonlin(5,1:show_horz)-1)*400;
xV_lin_disc=oo_endo_simul_base_lin(1,1:show_horz)*100;
piV_lin_disc=(oo_endo_simul_base_lin(2,1:show_horz)-1)*400;
RV_lin_disc=(oo_endo_simul_base_lin(3,1:show_horz)-1)*400;
RpotV_lin_disc=(oo_endo_simul_base_lin(5,1:show_horz)-1)*400;




//////////////////////////////
//Gov. Cons. Shock
/////////////////////////////
shocks;   
var zV_eps;  %technology
periods 1:1; 
values(0); 

var RV_eps;  %monetary policy
periods 1:1; 
values(0);

var mcV_eps;  %markup
periods 1:1; 
values(0); 

var nuV_eps;  %cons. demand   
periods 1:1; 
values(0); 

var deltaV_eps;  %discount factor shock
periods 1:1; 
values(0); 

var gV_eps;  %gov. cons
periods 1:1; 
values(govconsshock); 
end;
simul(periods=300,stack_solve_algo=0); 

oo_endo_simul_base=oo_.endo_simul; 
oo_steady_state_base=oo_.steady_state;
figtitle=['Impulse Responses to Government Consumption Shock']; 
legstring=[{'Nonlinear Model'},{'Linearized Model'}]; 
skip_ini_period=0;
plot_results; 

xV_nonlin_g=oo_endo_simul_base_nonlin(1,1:show_horz)*100;
piV_nonlin_g=(oo_endo_simul_base_nonlin(2,1:show_horz)-1)*400;
RV_nonlin_g=(oo_endo_simul_base_nonlin(3,1:show_horz)-1)*400;
RpotV_nonlin_g=(oo_endo_simul_base_nonlin(5,1:show_horz)-1)*400;
xV_lin_g=oo_endo_simul_base_lin(1,1:show_horz)*100;
piV_lin_g=(oo_endo_simul_base_lin(2,1:show_horz)-1)*400;
RV_lin_g=(oo_endo_simul_base_lin(3,1:show_horz)-1)*400;
RpotV_lin_g=(oo_endo_simul_base_lin(5,1:show_horz)-1)*400;





%%%%%%
%%Figure 1
%%%%
%Plot all in one figure
figure;

%cons. demand
subplot(3,4,1)
plot(time,xV_lin_consdem,'k-',time,xV_nonlin_consdem,'r--');
title('Output Gap (%)');
ylabel('Cons. Demand Shock');
axis([0 19 -1.1 0]);
subplot(3,4,2)
plot(time,piV_lin_consdem,'k-',time,piV_nonlin_consdem,'r--');
title('Inflation (APR)');
axis([0 19 -0.5 2]);
subplot(3,4,3)
plot(time,RV_lin_consdem,'k-',time,RV_nonlin_consdem,'r--');
title('Nom. Interest Rate (APR)');
axis([0 19 -0.1 4]);
subplot(3,4,4)
plot(time,RpotV_lin_consdem,'k-',time,RpotV_nonlin_consdem,'r--');
title('Pot. Real Int. Rate (APR)');
axis([0 19 -0.1 2.1]);

%discount factor
subplot(3,4,5)
plot(time,xV_lin_disc,'k-',time,xV_nonlin_disc,'r--');
title('Output Gap (%)');
axis([0 19 -1.1 0]);
ylabel('Discount Factor Shock');
subplot(3,4,6)
plot(time,piV_lin_disc,'k-',time,piV_nonlin_disc,'r--');
title('Inflation Rate (APR)');
axis([0 19 -0.5 2]);
subplot(3,4,7)
plot(time,RV_lin_disc,'k-',time,RV_nonlin_disc,'r--');
title('Nom. Interest Rate (APR)');
axis([0 19 -0.1 4]);
subplot(3,4,8)
plot(time,RpotV_lin_disc,'k-',time,RpotV_nonlin_disc,'r--');
title('Pot. Real Int. (APR)');
axis([0 19 -0.1 2.1]);

%gov. cons
subplot(3,4,9)
plot(time,xV_lin_g,'k-',time,xV_nonlin_g,'r--');
title('Output Gap (%)');
axis([0 19 -1.1 0]);
ylabel('Gov. Cons. Shock');
xlabel('Quarters');
subplot(3,4,10)
plot(time,piV_lin_g,'k-',time,piV_nonlin_g,'r--');
title('Inflation Rate (APR)');
axis([0 19 -0.5 2]);
xlabel('Quarters');
subplot(3,4,11)
plot(time,RV_lin_g,'k-',time,RV_nonlin_g,'r--');
title('Nom. Interest Rate (APR)');
axis([0 19 -0.1 4]);
xlabel('Quarters');
subplot(3,4,12)
plot(time,RpotV_lin_g,'k-',time,RpotV_nonlin_g,'r--');
title('Pot. Real Int. Rate (APR)');
axis([0 19 -0.1 2.1]);
xlabel('Quarters');
leg=legend('Linearized Model','Nonlinear Model');


suptitle('Impulse Responses to Shocks I: Linearized vs. Nonlinear Model'); 

set(leg,...
    'Position',[0.383333333333333 0.891139232659642 0.247126436781609 0.019620253164557],...
    'Orientation','horizontal');


text(-65,-1,['      Notes: Shocks are sized so that inflation falls on impact from 2% to 0% in the nonlinear model. All shocks have AR(1)=0.95.'],'Interpreter','Tex','FontSize',9); 

orient landscape
set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperUnits', 'inches');
set(gcf, 'PaperPosition', [-1 .2 13 8.2]);
print('-dpdf',['shocks1']);




%%%%%%
%%Figure 2
%%%%
%Plot all in one figure
figure;

%technology
subplot(3,4,1)
plot(time,xV_lin_tech,'k-',time,xV_nonlin_tech,'r--');
title('Output Gap (%)');
ylabel('Technology Shock');
axis([0 19 -1.1 0]);
subplot(3,4,2)
plot(time,piV_lin_tech,'k-',time,piV_nonlin_tech,'r--');
title('Inflation Rate (APR)');
axis([0 19 -0.5 2]);
subplot(3,4,3)
plot(time,RV_lin_tech,'k-',time,RV_nonlin_tech,'r--');
title('Nom. Interest Rate (APR)');
axis([0 19 -0.1 4]);
subplot(3,4,4)
plot(time,RpotV_lin_tech,'k-',time,RpotV_nonlin_tech,'r--');
title('Pot. Real Int. Rate (APR)');
axis([0 19 -0.1 2.1]);

%markup
subplot(3,4,5)
plot(time,xV_lin_mkp,'k-',time,xV_nonlin_mkp,'r--');
title('Output Gap (%)');
axis tight;
ylabel('Markup Shock');
subplot(3,4,6)
plot(time,piV_lin_mkp,'k-',time,piV_nonlin_mkp,'r--');
title('Inflation Rate (APR)');
axis([0 19 -0.5 2]);
subplot(3,4,7)
plot(time,RV_lin_mkp,'k-',time,RV_nonlin_mkp,'r--');
title('Nom. Interest Rate (APR)');
axis([0 19 -0.1 4]);
subplot(3,4,8)
plot(time,RpotV_lin_mkp,'k-',time,RpotV_nonlin_mkp,'r--');
title('Pot. Real Int. Rate (APR)');
axis([0 19 -0.1 2.1]);

%monetary policy
subplot(3,4,9)
plot(time,xV_lin_mopo,'k-',time,xV_nonlin_mopo,'r--');
title('Output Gap (%)');
axis tight;
ylabel('Policy Shock');
xlabel('Quarters');
subplot(3,4,10)
plot(time,piV_lin_mopo,'k-',time,piV_nonlin_mopo,'r--');
title('Inflation Rate (APR)');
xlabel('Quarters');
axis tight
subplot(3,4,11)
plot(time,RV_lin_mopo,'k-',time,RV_nonlin_mopo,'r--');
title('Nom. Interest Rate (APR)');
axis tight
xlabel('Quarters');
subplot(3,4,12)
plot(time,RpotV_lin_mopo,'k-',time,RpotV_nonlin_mopo,'r--');
title('Pot. Real Int. Rate (APR)');
axis([0 19 -0.1 2.1]);
xlabel('Quarters');
leg=legend('Linearized Model','Nonlinear Model');


suptitle('Impulse Responses to Shocks II: Linearized vs. Nonlinear Model'); 

set(leg,...
    'Position',[0.383333333333333 0.891139232659642 0.247126436781609 0.019620253164557],...
    'Orientation','horizontal');


text(-75,-1,['      Notes: Shocks are sized so that inflation falls on impact from 2% to 0% in the nonlinear model. All shocks have AR(1)=0.95 except the policy shock which has AR(1)=0.7.'],'Interpreter','Tex','FontSize',9); 

orient landscape
set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperUnits', 'inches');
set(gcf, 'PaperPosition', [-1 .2 13 8.2]);
print('-dpdf',['shocks2']);


 

