% Calculate government debt multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear
    load('linear_vars667_ar1');
    load('nonlinear_vars667_ar1');

    %/// DEBT MULTIPLIER
        
    gov_mult_lin = zeros(length(var_values_lin),1);
    gov_mult_nonlin = zeros(length(var_values_nonlin),1);

    for i = 1:length(var_values_lin)

        temp1 = var_values_lin{i,1};
        temp2 = var_values_linG{i,1};
        
        temp3 = var_values_nonlin{i,1};
        temp4 = var_values_nonlinG{i,1};
        
        
        % LINEAR: (yG-ybase)/(gG-gbase) * 1/.2, gbase is 0
        gov_mult_lin(i) = ((temp2(6,2)-temp1(6,2))/(temp2(11,2)-temp1(11,2)))*1/gy;
        % NONLINEAR: (yG-ybase)/(gG-gbase)
        gov_mult_nonlin(i) = (temp4(6,2)-temp3(6,2))/(temp4(11,2)-temp3(11,2));
    end;

    save('gov_mult667_ar1.mat', 'gov_mult_lin', 'gov_mult_nonlin');