clear

load('gov_mult667_ar1');
gov_mult_lin_122_ar1 = gov_mult_lin;
gov_mult_nonlin_122_ar1 = gov_mult_nonlin;
clear gov_mult_lin gov_mult_nonlin;

load('debt_mult_ar1.mat');
debt_mult_lin_122_ar1 = debt_mult_lin;
debt_mult_nonlin_122_ar1 = debt_mult_nonlin;
clear debt_mult_lin debt_mult_nonlin;

load('linear_vars667_ar1');
load('nonlinear_vars667_ar1');
model = 5;
var_values_nonlin_122_ar1 = var_values_nonlin;
var_values_nonlinG_122_ar1 = var_values_nonlinG;
[var_values_lin_levels_122_ar1, var_values_linG_levels_122_ar1] = make_levels_from_lin(var_values_lin, var_values_linG, var_values_nonlin, model);
clear var_values_nonlin var_values_nonlinG var_values_lin var_values_linG;

[exp_inf_lin_122_ar1] = get_exp_inf(var_values_lin_levels_122_ar1, var_values_linG_levels_122_ar1);
[exp_inf_nonlin_122_ar1] = get_exp_inf(var_values_nonlin_122_ar1, var_values_nonlinG_122_ar1);

%%%%%%%%%

load('gov_mult667_ma');
gov_mult_lin_122_ma = gov_mult_lin;
gov_mult_nonlin_122_ma = gov_mult_nonlin;
clear gov_mult_lin gov_mult_nonlin;

load('debt_mult_ma');
debt_mult_lin_122_ma = debt_mult_lin;
debt_mult_nonlin_122_ma = debt_mult_nonlin;
clear debt_mult_lin debt_mult_nonlin;

load('linear_vars667_ma');
load('nonlinear_vars667_ma');
model = 5;
var_values_nonlin_122_ma = var_values_nonlin;
var_values_nonlinG_122_ma = var_values_nonlinG;
[var_values_lin_levels_122_ma, var_values_linG_levels_122_ma] = make_levels_from_lin(var_values_lin, var_values_linG, var_values_nonlin, model);
clear var_values_nonlin var_values_nonlinG var_values_lin var_values_linG;

[exp_inf_lin_122_ma] = get_exp_inf(var_values_lin_levels_122_ma, var_values_linG_levels_122_ma);
[exp_inf_nonlin_122_ma] = get_exp_inf(var_values_nonlin_122_ma, var_values_nonlinG_122_ma);

ZLBquarters = [0 1 2 3 4 5 6 7 8 9 10 11 12];

figure1 = figure;

[xb, yb] = stairs(ZLBquarters, gov_mult_lin_122_ar1(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, gov_mult_lin_122_ma(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h1=subplot(2,3,1);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
axis([-.5 12 .2 5.2]);
set(gca,'XTick',(0:2:12));
 temp1=title('Impact Spending Multiplier');
 xlabel('ZLB duration, quarters');
 ylabel('Multiplier');
hold off;

[xb, yb] = stairs(ZLBquarters, exp_inf_lin_122_ar1(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, exp_inf_lin_122_ma(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h2=subplot(2,3,2);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
axis([-.5 12 0 4.8]);
set(gca,'XTick',(0:2:12));
title('Expected inflation (4\cdotE_t\pi_t_+_1)');
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

[xb, yb] = stairs(ZLBquarters, debt_mult_lin_122_ar1(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, debt_mult_lin_122_ma(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h3=subplot(2,3,3);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
line ([-.5 12],[0 0],'Color',[.8 .8 .8],'LineWidth',1.1);
axis([-.5 12 -23.5 3.5]);
set(gca,'XTick',(0:2:12));
title('Govt Debt to GDP (After 1 Year)');
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

[xb, yb] = stairs(ZLBquarters, gov_mult_nonlin_122_ar1(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, gov_mult_nonlin_122_ma(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h4=subplot(2,3,4);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
axis([-.5 12 .2 2.2]);
set(gca,'XTick',(0:2:12));
temp2=title('Impact Spending Multiplier');
xlabel('ZLB duration, quarters');
ylabel('Multiplier');
hold off;

[xb, yb] = stairs(ZLBquarters, exp_inf_nonlin_122_ar1(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, exp_inf_nonlin_122_ma(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h5=subplot(2,3,5);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
axis([-.5 12 0 1.8]);
set(gca,'XTick',(0:2:12));
title('Expected Inflation (4\cdotE_t\pi_t_+_1)');
ylabel('Percentage Points');
xlabel('ZLB duration, quarters');
hold off;

[xb, yb] = stairs(ZLBquarters, debt_mult_nonlin_122_ar1(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, debt_mult_nonlin_122_ma(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h6=subplot(2,3,6);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
line ([-.5 12],[0 0],'Color',[.8 .8 .8],'LineWidth',1.1);
axis([-.5 12 -7.5 3.5]);
set(gca,'XTick',(0:2:12));
title('Govt Debt to GDP (After 1 Year)');
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

set(h1,'Position',[0.13 0.525 0.213405797101449 0.311059569461639]);
set(h2,'Position',[0.410797101449275 0.525 0.213405797101449 0.311059569461639]);
set(h3,'Position',[0.691594202898551 0.525 0.213405797101449 0.311059569461639]);
set(h4,'Position',[0.13 0.09 0.213405797101449 0.311059569461639]);
set(h5,'Position',[0.410797101449275 0.09 0.213405797101449 0.311059569461639]);
set(h6,'Position',[0.691594202898551 0.09 0.213405797101449 0.311059569461639]);

annotation(figure1,'textbox',[0.464375 0.88707468879668 0.8 0.0311203319502075],'String',{'Linearized Model'},'FontSize',10, 'LineStyle','none','FontWeight','demi');
annotation(figure1,'textbox',[0.463645833333333 0.44707468879668 0.8 0.033195020746888],'String',{'Nonlinear Model'},'FontSize',10,'LineStyle','none','FontWeight','demi');

suptitle('       Figure A.5: Sensitivity of Marginal Multipliers With Respect to Specification of Spending Process');
leg1 = legend('AR(1) Process for Spending (Benchmark)', 'MA Process for Spending');
set(leg1, 'Orientation', 'Horizontal','Position',[0.210474537037036 0.915552806848749 0.600520833333333 0.024896265560166],'FontSize',8);

orient(figure(1),'landscape');
set(figure(1), 'PaperUnits', 'inches', 'PaperPosition', [.25 .25 10.5 8]);

print -depsc2 '-r1200' 'FigureA5.eps';
fixPSlinestyle('FigureA5.eps');