//CGG New Keynesian model with fully non-linear vs. linear equilibrium equations
//Consumption demand or discount factor shocks take economy to ZLB; Fiscal multiplier analysis
//Kimball (1995) aggregator to get slope of PC and micro-evidence of price stickiness jointly


//Dynare version: 4.3.3
//Mathias Trabandt, mathias.trabandt@gmail.com, November 2013  


//MT changes per March 2013:
//1. Taylor rule coefficients set to 1.5 and 0.125
//2. Make labor income taxes a true dynamic variable (in actual and pot econ.)
//3. Put in a new fiscal rule for labor income taxes (parameter phiN)
//4. Renamed equation numbering due to new variables
//5. Plot more variables (Debt, Lump-sum taxes, dist. labor tax)
//6. Deleted all code after figure 2 in mod file
//7. Changed ordering of variables in Dynare var statement!
//8. Made lots of changes to plot_results.m file (variable creation, plotting etc)
//9. Per new switch, allow government spending shock only when ZLB is binding (gAtZLBonly)
//10.Re-specified the Taylor rule in logs rather than in levels (to get rid of the SS expressions in the linear case)

//MT changes per April 2013:
//11.Kimball (1995) aggregator introduced
//12.Discount factor shock added
//13.More variables in var statement due to 11 and 12.
//14.Fixed error in steady state computations
//15.General (non-) indexation scheme available in non-linear model. Yet not available 
//in linearized model and steady state. I.e. stick to indexation for the time being! 

//MT changes per November 2013:
//16. Allow for general (non-) indexation scheme in linear and non-linear model. 
//Parameter iota is key here. If iota=1 - indexation. If iota=0 - no indexation.


 
// Endogenous variables 
var 
xV piV RV rrV rrVpot yV pstarV bGV tauV tauNV gV nuV                                              //these 12 variables are plotted
xVBREVE piVHAT RVHAT rrVHAT rrVpotHAT yVHAT pstarVHAT bGVBREVE tauVBREVE tauNVBREVE gVHAT nuVBREVE//these 12 variables are plotted
cV nV wV sV mcV fV varthetaV aV ptildeV delta2V delta1V delta3V deltaV
cVpot nVpot wVpot yVpot bGVpot tauVpot lamV tauNVpot gVpot 

nVHAT cVHAT wVHAT mcVHAT cVpotHAT wVpotHAT yVpotHAT bGVpotBREVE gVpotHAT
tauVpotBREVE nVpotHAT tauNVpotBREVE deltaVHAT delta1VHAT delta2VHAT 
delta3VHAT varthetaVHAT sVHAT fVHAT aVHAT ptildeVHAT lamVHAT 
;  
 
// Shocks 
varexo nuV_eps gV_eps deltaV_eps;  
 
// Parameters 
parameters betta tauC tauN sigma chi thetap k alfa xip kpot
imposeZLB gampi gamx phiT rhoG rhonu sigG signu pibar bGy 
gy tauy nu phiN gAtZLBonly psie pitilde rhodelta sigdelta; 
 

//initialize parameters and imposed steady states
pibar=1.005;  %steady state gross inflation rate
%pibar=1;
%thetap=.55;
thetap=0.1;   %net price markup in steady state
xip=0.667;     %Calvo sticky prices parameter
psie=-12.2;      %Kimball aggregator parameter 
%psie= -1.25;

%Dixit Stiglitz
%xip=0.9;     %Calvo sticky prices parameter
%psie=0.01;      %Kimball aggregator parameter 

%Parameter settings for model with indexation
%iota=1;       %degree of indexation to steady state inflation
%pibreve=1.005;    %alternative value prices are indexed to
%pitilde=(pibar^iota)*(pibreve^(1-iota)); %Indexation updater: if iota=0 and pibreve=1 -> no indexation at all 

%Parameter settings for model without indexation
iota=0;       %degree of indexation to steady state inflation
pibreve=1.00;    %alternative value prices are indexed to
pitilde=(pibar^iota)*(pibreve^(1-iota)); %Indexation updater: if iota=0 and pibreve=1 -> no indexation at all 

gampi=1.5;   %Taylor rule coef. on inflation
gamx=0.125;  %Taylor rule coef. on output gap

alfa=0.3;    %capital share in production
betta=0.995; %discount factor of households
sigma=1;     %inverse intertemporal elasticity of substitution
             %code needs fixing for sigma different from 1
chi=1/0.4;   %inverse Frisch elasticity of labor supply
nu=0.00;     %steady state of cons. demand shock

gy=0.2;      %gov. consumption to output ratio in steady state
tauC=0;      %steady state cons. tax
bGy=2.4;     %steady state debt to GDP ratio
tauy=0;      %steady state transfer to GDP ratio

phiT=1*(1/betta-1)*2; %fiscal rule for lump-sum taxes: coef. on debt
phiN=0*(1/betta-1)*2; %fiscal rule for labor taxes: coef. on debt

rhoG=0.95;    %AR(1) gov. consumption shock
rhonu=0.95;   %AR(1) cons. demand shock
rhodelta=0.95;%AR(1) discount factor shock

sigG=0.05;   %Std. gov. consumption shock  %rig such that d gy 1%
signu=0.01;  %Std. cons. demand shock
sigdelta=0.005;%Std. discount factor shock

imposeZLB=1; %impose ZLB in Taylor rule if =1; if =0 ZLB not imposed
gAtZLBonly=0;%if=0, gov. spending follows AR(1); if=1 gov. spending positive at ZLB only


//available figures
%fig1: Cons. demand shock; with and without ZLB
%fig2: Discount factor shock; with and without ZLB
%fig3: Cons. demand shock vs. cons. demand plus gov. cons. shock; with ZLB
%4 - find sigdeltas
%6 - repeated simulation of model with sigdelta shocks
%7 - find signus (SHER)
%8 - repeated simulation of model with signu shocks (SHER)

do_fig=8;
do_show_unconstained=0; %if =1, ZLB not imposed results are plotted
//endogenous steady states are calculated in _steadystate.m file  
model; 
///////////////////////////////////////////////////////
//non-linear economy                                 //
///////////////////////////////////////////////////////
//set some fiscal instruments to their steady states
#tauCV=tauC;
#tauCV_tp1=tauC;

//n1 marg. utility
lamV=(cV-STEADY_STATE(cV)*nuV)^(-1/sigma)/(1+tauCV);  
  
//n2 leisure-labor tradeoff 
nV^chi =(1-tauNV)*lamV*wV; 
 
//n3 euler equation
lamV=betta*deltaV*RV/piV(+1)*lamV(+1); 

//n4 resource constraint
cV+gV=yV;

//n5 production
yV=pstarV^(-1)*k^alfa*nV^(1-alfa); 
 
//n6 non-lin. pricing 1 
sV=(1+thetap)*(1+psie)/(1+psie+thetap*psie)*lamV*yV*mcV*varthetaV^((1+thetap)/thetap*(1+psie))+xip*betta*deltaV*(pitilde/piV(+1))^(-(1+thetap)/thetap*(1+psie))*sV(+1);  

//n7 non-lin. pricing 2 
fV=lamV*yV*varthetaV^((1+thetap)/thetap*(1+psie))+xip*betta*deltaV*(pitilde/piV(+1))^(-(1+psie+psie*thetap)/thetap)*fV(+1); 

//n8 non-lin. pricing 3
aV=psie*thetap/(1+psie+psie*thetap)*yV*lamV+xip*betta*deltaV*(pitilde/piV(+1))*aV(+1);

//n9 non-lin. pricing 4
sV=fV*ptildeV-aV*ptildeV^(1+(1+psie)*(1+thetap)/thetap);

//n10 zero profit condition
varthetaV=1+psie-psie*delta2V;

//n11 aggregate price index
varthetaV=delta3V;

//n12 overall price dispersion index 
pstarV=1/(1+psie)*(varthetaV/delta1V)^((1+thetap)*(1+psie)/thetap)+psie/(1+psie);

//n13 dispersion index 
delta1V^(-(1+thetap)*(1+psie)/thetap)=(1-xip)*ptildeV^(-(1+thetap)*(1+psie)/thetap)+xip*(pitilde/piV*delta1V(-1))^(-(1+thetap)*(1+psie)/thetap); 

//n14 dispersion index 
delta2V=(1-xip)*ptildeV+xip*pitilde/piV*delta2V(-1); 

//n15 dispersion index 
delta3V^(-(1+psie+psie*thetap)/thetap)=(1-xip)*ptildeV^(-(1+psie+psie*thetap)/thetap)+xip*(pitilde/piV*delta3V(-1))^(-(1+psie+psie*thetap)/thetap); 

//n16 marginal cost
mcV=wV/( (1-alfa)*k^alfa*nV^(-alfa) ); 

//n17 Taylor rule
#RVnot=STEADY_STATE(RV)*(piV/STEADY_STATE(piV))^gampi*((yV/STEADY_STATE(yV))/(yVpot/STEADY_STATE(yVpot)))^gamx;
RV=max(1-1e6*(1-imposeZLB),RVnot);

//n18 gov. budget
bGV=RV(-1)/piV*bGV(-1)+gV-tauCV*cV-tauNV*wV*nV-tauV;

//n19 fiscal rule for lump-sum taxes
tauV/STEADY_STATE(yV)=STEADY_STATE(tauV)/STEADY_STATE(yV)+phiT*(bGV(-1)/STEADY_STATE(yV)-STEADY_STATE(bGV)/STEADY_STATE(yV));

//n20 fiscal rule for distortionary labor income taxes
tauNV/STEADY_STATE(yV)=STEADY_STATE(tauNV)/STEADY_STATE(yV)+phiN*(bGV(-1)/STEADY_STATE(yV)-STEADY_STATE(bGV)/STEADY_STATE(yV));
 
//n21 flex-price: euler equation 
(cVpot-STEADY_STATE(cVpot)*nuV)^(-1/sigma)/(1+tauCV)=betta*deltaV*rrVpot*(cVpot(+1)-STEADY_STATE(cVpot)*nuV(+1))^(-1/sigma)/(1+tauCV_tp1); 

//n22 flex-price: leisure-labor tradeoff 
nVpot^chi/(cVpot-STEADY_STATE(cVpot)*nuV)^(-1/sigma) =(1-tauNVpot)/(1+tauCV)*wVpot; 

//n23 flex-price: wage
wVpot=(1-alfa)/(1+thetap)*kpot^alfa*nVpot^(-alfa);

//n24 flex-price: resource constraint
cVpot+gVpot=yVpot;

//n25 flex-price: production
yVpot=kpot^alfa*nVpot^(1-alfa); 

//n26 flex-price: gov. budget
bGVpot=rrVpot(-1)*bGVpot(-1)+gVpot-tauCV*cVpot-tauNVpot*wVpot*nVpot-tauVpot;

//n27 flex-price: fiscal rule for lump-sum taxes
tauVpot/STEADY_STATE(yVpot)=STEADY_STATE(tauVpot)/STEADY_STATE(yVpot)+phiT*(bGVpot(-1)/STEADY_STATE(yVpot)-STEADY_STATE(bGVpot)/STEADY_STATE(yVpot));

//n28 flex-price: fiscal rule for distortionary labor income taxes
tauNVpot/STEADY_STATE(yVpot)=STEADY_STATE(tauNVpot)/STEADY_STATE(yVpot)+phiN*(bGVpot(-1)/STEADY_STATE(yVpot)-STEADY_STATE(bGVpot)/STEADY_STATE(yVpot));

//n29 (extra equation, not listed in manuscript) output gap
xV=log((yV/STEADY_STATE(yV))/(yVpot/STEADY_STATE(yVpot)));

//n30 (extra equation, not listed in manuscript) real rate
rrV=RV/piV(+1);

//n31a (extra equation, not listed in manuscript) gov. consumption shock
//try adding shocks while at the ZLB instead of unit root....perhaps more stable numerically
(gV-STEADY_STATE(gV))/STEADY_STATE(gV)=(1-gAtZLBonly)*rhoG*(gV(-1)-STEADY_STATE(gV))/STEADY_STATE(gV)+gAtZLBonly*(gV(-1)-STEADY_STATE(gV))/STEADY_STATE(gV)*(RVnot<1.0001)+sigG*gV_eps;

//n31b (extra equation, not listed in manuscript) gov. consumption shock pot. econ
(gVpot-STEADY_STATE(gVpot))/STEADY_STATE(gVpot)=(1-gAtZLBonly)*rhoG*(gVpot(-1)-STEADY_STATE(gVpot))/STEADY_STATE(gVpot)+gAtZLBonly*(gVpot(-1)-STEADY_STATE(gVpot))/STEADY_STATE(gVpot)*(RVnot<1.0001)+sigG*gV_eps;

//n32 (extra equation, not listed in manuscript)  consumption demand shock
(nuV-STEADY_STATE(nuV))=rhonu*(nuV(-1)-STEADY_STATE(nuV))+signu*nuV_eps;

//n32 (extra equation, not listed in manuscript)  discount factor shock
(deltaV-STEADY_STATE(deltaV))/STEADY_STATE(deltaV)=rhodelta*(deltaV(-1)-STEADY_STATE(deltaV))/STEADY_STATE(deltaV)+sigdelta*deltaV_eps;


///////////////////////////////////////////////////////
///linear economy                                    //
///////////////////////////////////////////////////////
//set some fiscal shocks not needed to zero
#tauCVBREVE=0;
#tauCVBREVE_tp1=0;

//l1 labor-leisure tradeoff
chi*nVHAT+(cVHAT-nuVBREVE)/(sigma*(1-nu))=wVHAT-tauNVBREVE/(1-tauN)-tauCVBREVE/(1+tauC);

//l2 euler equation
0=deltaVHAT+RVHAT-piVHAT(+1)-(cVHAT(+1)-nuVBREVE(+1))/(sigma*(1-nu))+(cVHAT-nuVBREVE)/(sigma*(1-nu))-(tauCVBREVE_tp1-tauCVBREVE)/(1+tauC);

//l3 resource constraint
STEADY_STATE(cV)*cVHAT+STEADY_STATE(gV)*gVHAT=STEADY_STATE(yV)*yVHAT;

//l4 production
yVHAT=(1-alfa)*nVHAT-pstarVHAT;

//l5 Zero profit condition
STEADY_STATE(varthetaV)*varthetaVHAT=-psie*STEADY_STATE(delta2V)*delta2VHAT;

//l6 Aggregate price index
varthetaVHAT=delta3VHAT;

//l7 Overall price dispersion
pstarVHAT=(1+thetap)*(1+psie-psie/STEADY_STATE(pstarV))/thetap*(varthetaVHAT-delta1VHAT);

//l8 Price dispersion 1
delta1VHAT=(1-xip)*(STEADY_STATE(ptildeV)/STEADY_STATE(delta1V))^( -(1+thetap)*(1+psie)/thetap )*ptildeVHAT+xip*(pitilde/STEADY_STATE(piV))^(-(1+thetap)*(1+psie)/thetap)*(delta1VHAT(-1)-piVHAT);

//l9 Price dispersion 2
delta2VHAT=(1-xip)*(STEADY_STATE(ptildeV)/STEADY_STATE(delta2V))*ptildeVHAT+xip*(pitilde/STEADY_STATE(piV))*(delta2VHAT(-1)-piVHAT);

//l10 Price dispersion 3
delta3VHAT=(1-xip)*(STEADY_STATE(ptildeV)/STEADY_STATE(delta3V))^( -(1+psie+thetap*psie)/thetap )*ptildeVHAT+xip*(pitilde/STEADY_STATE(piV))^( -(1+psie+thetap*psie)/thetap )*(delta3VHAT(-1)-piVHAT);

//l11 Non-linear pricing 1
sVHAT=( 1-betta*xip*(pitilde/STEADY_STATE(piV))^(-(1+thetap)*(1+psie)/thetap) )*
(yVHAT+lamVHAT+mcVHAT+((1+thetap)*(1+psie)/thetap)*varthetaVHAT)
+betta*xip*(pitilde/STEADY_STATE(piV))^(-(1+thetap)*(1+psie)/thetap)*(deltaVHAT+(1+thetap)*(1+psie)/thetap*piVHAT(+1)+sVHAT(+1));

//l12 Non-linear pricing 2
fVHAT=( 1-betta*xip*(pitilde/STEADY_STATE(piV))^( -(1+psie+psie*thetap)/thetap ) )*
(yVHAT+lamVHAT+((1+thetap)*(1+psie)/thetap)*varthetaVHAT)
+betta*xip*(pitilde/STEADY_STATE(piV))^( -(1+psie+psie*thetap)/thetap )*(deltaVHAT+(1+psie+psie*thetap)/thetap*piVHAT(+1)+fVHAT(+1));

//l13 Non-linear pricing 3
aVHAT=( 1-betta*xip*(pitilde/STEADY_STATE(piV)) )*(yVHAT+lamVHAT)
+betta*xip*(pitilde/STEADY_STATE(piV))*(deltaVHAT-piVHAT(+1)+aVHAT(+1));

//l14 Non-linear pricing 4
sVHAT=STEADY_STATE(fV/sV*ptildeV)*fVHAT-STEADY_STATE(aV/sV*ptildeV^(1+(1+thetap)*(1+psie)/thetap))*aVHAT-
STEADY_STATE((1+(1+thetap)*(1+psie)/thetap)*aV/sV*ptildeV^(1+(1+thetap)*(1+psie)/thetap)-fV/sV*ptildeV)*ptildeVHAT;

//l15 marginal cost
mcVHAT=wVHAT+alfa*nVHAT;

//l16 Taylor rule
#RVHATnot=gampi*piVHAT+gamx*(yVHAT-yVpotHAT);
RVHAT=max( (1-STEADY_STATE(RV))/STEADY_STATE(RV)-1e6*(1-imposeZLB),RVHATnot);

//l17 gov. budget
bGVBREVE=STEADY_STATE(RV)/STEADY_STATE(piV)*STEADY_STATE(bGV)*(RVHAT(-1)-piVHAT)+STEADY_STATE(RV)/STEADY_STATE(piV)*bGVBREVE(-1)
        +STEADY_STATE(gV)*gVHAT-tauC*STEADY_STATE(cV)*cVHAT-STEADY_STATE(cV)*tauCVBREVE-STEADY_STATE(wV)*STEADY_STATE(nV)*tauNVBREVE
        -tauN*STEADY_STATE(wV)*STEADY_STATE(nV)*(wVHAT+nVHAT)-tauVBREVE;

//l18 fiscal rule for lump-sum taxes
tauVBREVE=phiT*bGVBREVE(-1);

//l19 fiscal rule for distortionary labor income taxes
tauNVBREVE=phiN*bGVBREVE(-1);

//l20 marginal utility of consumption
cVHAT=sigma*(1-nu)*(-lamVHAT-tauCVBREVE/(1+tauC))+nuVBREVE;

//l21 flex-price, euler equation
0=deltaVHAT+rrVpotHAT-(cVpotHAT(+1)-nuVBREVE(+1))/(sigma*(1-nu))+(cVpotHAT-nuVBREVE)/(sigma*(1-nu))-(tauCVBREVE_tp1-tauCVBREVE)/(1+tauC);

//l22 flex-price, labor/leisure tradeoff
chi*nVpotHAT+(cVpotHAT-nuVBREVE)/(sigma*(1-nu))=wVpotHAT-tauNVpotBREVE/(1-tauN)-tauCVBREVE/(1+tauC);

//l23 flex-price, real wage
wVpotHAT=-alfa*nVpotHAT;

//l24 flex-price, resource constraint
STEADY_STATE(cVpot)*cVpotHAT+STEADY_STATE(gVpot)*gVpotHAT=STEADY_STATE(yVpot)*yVpotHAT;

//l25 flex-price, production
yVpotHAT=(1-alfa)*nVpotHAT;

//l26 flex-price, gov. budget
bGVpotBREVE=STEADY_STATE(rrVpot)*STEADY_STATE(bGVpot)*rrVpotHAT(-1)+STEADY_STATE(rrVpot)*bGVpotBREVE(-1)
        +STEADY_STATE(gVpot)*gVpotHAT-tauC*STEADY_STATE(cVpot)*cVpotHAT-STEADY_STATE(cVpot)*tauCVBREVE
        -STEADY_STATE(wVpot)*STEADY_STATE(nVpot)*tauNVpotBREVE
        -tauN*STEADY_STATE(wVpot)*STEADY_STATE(nVpot)*(wVpotHAT+nVpotHAT)-tauVpotBREVE;

//l27 flex-price, fiscal rule for lump-sum taxes
tauVpotBREVE=phiT*bGVpotBREVE(-1);

//l28 flex-price, fiscal rule for distortionary labor income taxes
tauNVpotBREVE=phiN*bGVpotBREVE(-1);

//l29 (extra equation, not listed in manuscript)  output gap
xVBREVE=yVHAT-yVpotHAT;

//l30 (extra equation, not listed in manuscript) real rate
rrVHAT=RVHAT-piVHAT(+1);

//l31a (extra equation, not listed in manuscript) gov. consumption shock: actual econ
gVHAT=(1-gAtZLBonly)*rhoG*gVHAT(-1)+gAtZLBonly*gVHAT(-1)*(RVHATnot<-0.00993)+sigG*gV_eps;

//l31b (extra equation, not listed in manuscript) gov. consumption shock: pot. econ
gVpotHAT=(1-gAtZLBonly)*rhoG*gVpotHAT(-1)+gAtZLBonly*gVpotHAT(-1)*(RVHATnot<-0.00993)+sigG*gV_eps;

//l32 (extra equation, not listed in manuscript) consumption demand shock
nuVBREVE=rhonu*nuVBREVE(-1)+signu*nuV_eps;

//l33 (extra equation, not listed in manuscript)  discount factor shock
deltaVHAT=rhodelta*deltaVHAT(-1)+sigdelta*deltaV_eps;

end; 
 
//some checks  
resid; 
steady; 
check; 

//prepare options for det. simul 
options_.slowc=1; options_.maxit_=1000; warning off;  
 

//create results
if do_fig==1, //fig1: Cons. demand shock; with and without ZLB
    shocks;   
    var nuV_eps;  %cons. demand   
    periods 1:1; 
    values -1;  
    end;

    %baseline
    simul(periods=250,stack_solve_algo=0); 
    oo_endo_simul_base=oo_.endo_simul; 
    oo_steady_state_base=oo_.steady_state; 

    %perturbation
    imposeZLB_idx=loc(M_.param_names(:,:),'imposeZLB'); 
    M_.params(imposeZLB_idx)=0; 
    steady;resid;
    check; 
    modelindex_steadystate;    
    simul(periods=250,stack_solve_algo=0); 
    if do_show_unconstained==1,
        oo_endo_simul_perturb=oo_.endo_simul;
    else
        oo_endo_simul_perturb=NaN*oo_.endo_simul; 
    end
    oo_steady_state_perturb=oo_.steady_state; 
     
    %Plotting 
    figtitle=['Impulse Responses to a Consumption Demand Shock - With and Without ZLB']; 
    if do_show_unconstained==1,
        legstring=[{'Nonlinear Model: ZLB imposed'},{'Linear Model: ZLB imposed'},{'Nonlinear Model: ZLB not imposed'},{'Linear Model: ZLB not imposed'}]; 
    else
        legstring=[{'Nonlinear Model'},{'Linear Model'}]; 
    end
    skip_ini_period=0;
    plot_results; 
end


if do_fig==2, //fig2: Discount factor shock; with and without ZLB
    shocks;   
    var deltaV_eps;  %discount factor shock
    periods 1:1; 
    values 1;  
    end;

    %baseline
    simul(periods=250,stack_solve_algo=0); 
    oo_endo_simul_base=oo_.endo_simul; 
    oo_steady_state_base=oo_.steady_state; 

    %perturbation
    imposeZLB_idx=loc(M_.param_names(:,:),'imposeZLB'); 
    M_.params(imposeZLB_idx)=0; 
    steady;resid;
    check; 
    modelindex_steadystate;    
    simul(periods=250,stack_solve_algo=0); 
    if do_show_unconstained==1,
        oo_endo_simul_perturb=oo_.endo_simul;
    else
        oo_endo_simul_perturb=NaN*oo_.endo_simul; 
    end
    oo_steady_state_perturb=oo_.steady_state; 
     
    %Plotting 
    figtitle=['Impulse Responses to a Discount Factor Shock - With and Without ZLB']; 
    if do_show_unconstained==1,
        legstring=[{'Nonlinear Model: ZLB imposed'},{'Linear Model: ZLB imposed'},{'Nonlinear Model: ZLB not imposed'},{'Linear Model: ZLB not imposed'}]; 
    else
        legstring=[{'Nonlinear Model'},{'Linear Model'}]; 
    end
    skip_ini_period=0;
    plot_results; 
end




if do_fig==3, //fig2: Cons. demand shock vs. cons. demand plus gov. cons. shock; with ZLB
    shocks;   
    var nuV_eps;  %cons. demand   
    periods 1:1; 
    values -1;  
    end;

    %baseline
    simul(periods=250,stack_solve_algo=0); 
    oo_endo_simul_base=oo_.endo_simul; 
    oo_steady_state_base=oo_.steady_state; 


    %perturbation
    shocks;   
    var nuV_eps;  %cons. demand   
    periods 1:1; 
    values -1;  
    var gV_eps;  %gov. consumption  
    periods 1:1; 
    values 1; 
    end;
    
    steady;resid;
    check; 
    modelindex_steadystate;    
    simul(periods=250,stack_solve_algo=0); 
    oo_endo_simul_perturb=oo_.endo_simul; 
    oo_steady_state_perturb=oo_.steady_state; 
     
    %Plotting 
    figtitle=['Impulse Responses to a Consumption Demand Shock - With and Without Gov. Spending Stimulus']; 
    legstring=[{'Nonlin. Model: Cons.Dem.Shk'},{'Lin. Model: Cons.Dem.Shk'},{'Nonlin. Model: Cons.Dem. & Gov.Spend.Shk'},{'Lin. Model: Cons.Dem. & Gov.Shk'}]; 
    skip_ini_period=0;
    plot_results; 
end

if do_fig==7,

    %values of signu to loop through
    signus = 0.175:0.0005:0.27;
%%%%%%% D-S, .9/.01 %%%%%%%
    %signus = 0.001:0.001:0.12;
%%%%%%% Kimball %%%%%%%
    %signus= .1:.005:.7;
%%%%%%%%%% D-S, .667/-1.25 %%%%%%%%%
     % signus= .05:.001:.097
    %only relevant if you also want to include a government spending shock
    %this is how you change the size of said shock, or any other shock:
    sigG_idx=loc(M_.param_names(:,:),'sigG'); 
    M_.params(sigG_idx)=.0001;

    %Calvo sticky price parameter
    xip_idx=loc(M_.param_names(:,:),'xip'); 
    M_.params(xip_idx)=.667;
    %M_.params(xip_idx)=.9;

    %initialize vectors to count # of ZLB-constrained quarters for each signu
    ZLB_periods_nl = zeros(length(signus),1);
    ZLB_periods_lin = zeros(length(signus),1);

    %%%%%%
    %Taylor rule parameters
    gampi_idx=loc(M_.param_names(:,:),'gampi'); 
    M_.params(gampi_idx)=1.5;
    gamx_idx=loc(M_.param_names(:,:),'gamx'); 
    M_.params(gamx_idx)=.125;
    %%%%%%

    %FOR LOOP START
    for i=1:length(signus);

        %change value of signu for the simulation in this loop:
        signu_idx=loc(M_.param_names(:,:),'signu'); 
        M_.params(signu_idx)=signus(i);

        shocks;   
            var deltaV_eps;
            periods 1:1; 
            values 0;
            var nuV_eps;  %cons. demand   
            periods 1:1; 
            values -1;  
            var gV_eps;  %gov. consumption  
            periods 1:1; 
            values 0; 
        end;

        %make sure ZLB is imposed
        imposeZLB_idx=loc(M_.param_names(:,:),'imposeZLB');
        M_.params(imposeZLB_idx)=1;

        steady;resid;check; modelindex_steadystate;

        if i > 1,
            %start simulating next time from previous solution; this is here so the model converges quicker.
            oo_.endo_simul=oo_endo_simul_lastiter;
        end;

        %if signus(i) < .2,
        %    options_.slowc = 1;
        %elseif (signus(i) >= .2 && signus(i) < .3),
            options_.slowc = .2;
        %else,
        %    options_.slowc = .1; options_.maxit_=10000;
        %end;

        simul(periods=250,stack_solve_algo=0);

        %save values at last simulation to use as starting point for next iteration
        oo_endo_simul_lastiter=oo_.endo_simul;

        %save values of RV (non-linear nom. int. rate)
        oo_endo_simul_nlIR=oo_.endo_simul(3,1:end);

        %save values of RVHAT (linear nom. int. rate)
        oo_endo_simul_linIR=oo_.endo_simul(15,1:end);

        iii = 0;
        jjj = 0;

        for k = 1:length(oo_endo_simul_nlIR);
            if (abs(oo_endo_simul_nlIR(k) - 1) < .0001),
                iii = iii + 1;
            end;
        end;
        ZLB_periods_nl(i) = iii;

        for k = 1:length(oo_endo_simul_linIR);
            if (abs(oo_endo_simul_linIR(k) + .0100) < .0001),
                jjj = jjj + 1;
            end;
        end;
        ZLB_periods_lin(i) = jjj;

    %FOR LOOP END
    end;



/////THIS VARIABLE DISPLAYS THE NUMBER OF ZLB PERIODS THE LIN AND NONLIN VERSIONS OF THE MODEL HIT GIVEN EACH SIGNU SHOCK.
alltogether = zeros(length(signus),3);
alltogether(1:end, 1) = ZLB_periods_lin;
alltogether(1:end, 2) = ZLB_periods_nl;
alltogether(1:end, 3) = transpose(signus);

/////FUNCTION BELOW PRODUCES AN NX2 ARRAY OF ZLB DURATIONS AND CORRESPONDING MAX SIGNU SHOCKS FOR LIN AND NONLIN VERSIONS
/////OF THE MODEL. (FOR DOCUMENTATION, SEE FUNCTION FILE OR TYPE "help getsignus".) USE THESE VALUES OF SIGNU TO REPEATEDLY
/////ESTIMATE THE MODEL, BELOW. THESE VALUES NEED TO BE ENTERED INTO THE do_fig=6 CODE MANUALLY.

[lin_signus nonlin_signus] = getsignus(alltogether);
end;


if do_fig==8,

    j = 1;
    for linear = [0];

        %% SET PARAMETER VALUES %%%%%%%%%%%%%%%%%%%%%%%%%%%%

        %Calvo sticky price parameter
        xip_idx=loc(M_.param_names(:,:),'xip'); 
       M_.params(xip_idx)=.667;
       % M_.params(xip_idx)=.9;

        %Taylor rule parameters
        gampi_idx=loc(M_.param_names(:,:),'gampi'); 
        M_.params(gampi_idx)=1.5;
        gamx_idx=loc(M_.param_names(:,:),'gamx'); 
        M_.params(gamx_idx)=.125;

        %Government shock parameter
        sigG_idx=loc(M_.param_names(:,:),'sigG'); 
        M_.params(sigG_idx)=.0001;

        %make sure ZLB is imposed
        imposeZLB_idx=loc(M_.param_names(:,:),'imposeZLB');
        M_.params(imposeZLB_idx)=1;


        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        %values of signu to loop through
        if M_.params(xip_idx) == .667,
            if linear == 1,
                %for psie = -12.2:
                signus = [0.001 0.1210 0.1280 0.134 0.1420 0.1490 0.1570 0.165 0.1740 0.183 0.1930 0.2030 0.2140];
                %for psie = 0:
                %signus = [0.001 0.1015 0.1070 0.1125 0.1185 0.1250 0.1315 0.1385 0.1455];
                %for indexation test
                signus = [0.059 0.059 0.059 0.059 0.059 0.059 0.059 0.059 0.059]; %for 4 to 2 drop in i-rate 0.1260

            else,
                %Nonlinear model 'breaking points'
                %for psie = -12.2:
             %signus = [0.001 0.1650 0.2045 0.2450 0.2840 0.3205 0.3545 0.3865 0.4165 0.4455 0.4740 0.5030 0.5325]; %with indexation   
            %signus = [0.001 .16 .163 .168 .175 .183 .192 .202 .213 .225 .237 .25 .263];
                %this is just the linear 8-quarter trap shock size:
               % signus = [0.1740 0.1740 0.1740 0.1740 0.1740 0.1740 0.1740 0.1740 0.1740];
                %for psie = -1.25:
                %signus = [0.001 0.053 0.055 0.059 0.062 0.065 0.069 0.073 0.077 0.081 0.086 0.091 0.096];
                %no indexation
                signus = [0.001 0.1600 0.1635 0.1685 0.1755 0.1835 0.1925 0.2025 0.2135 0.2250 0.2375 0.2500 0.2635];
            end;
            %initialize files in which will save the above vars
            %for psie = -12.2:
            %file1 = 'linear_vars667_sn_v3.mat';
            %file2 = 'index_vars667_sn_v3_with_indexation.mat';
            %for the linear 8ZLB shock size nonlin values:
            %file2 = 'nonlinear_vars9_ONEsn_v3.mat';
            %for psie = 0:
            %file1 = 'linear_vars667_sn_psie0_v3.mat';
            %file2 = 'nonlinear_vars667_sn_psie0_v3.mat';
            %nonlin test
             %file2 = 'index_vars667_sn_v3_with_indexation.mat';
            %no indexation
            file2 = 'index_vars667_sn_v3_no_indexation.mat';
        end;

%%% Dixit Stiglitz psie = 0.01 and xip = 0.9
        if M_.params(xip_idx) == .9,
            if linear == 1,
                %for psie = -12.2:
                signus = [0.001 0.1215 0.1280 0.1345 0.1420 0.1495 0.1570 0.1655 0.1740 0.1835 0.1930 0.2030 0.2140];
                %for psie = 0:
                %signus = [0.001 0.1215 0.1280 0.1350 0.1420 0.1495 0.1570 0.1655 0.1740 0.1835 0.1930 0.2030 0.2140];

            else,
                %Nonlinear model 'breaking points'
                %for psie = -12.2:
                signus = [0.001 0.061 0.065 0.069 0.073 0.077 0.082 0.087 0.092 0.098 0.105 0.112 0.12];
                %this is just the linear 8-quarter trap shock size:
                %signus = [0.1740 0.1740 0.1740 0.1740 0.1740 0.1740 0.1740 0.1740 0.1740];
                %for psie = 0:
                %signus = [0.001 0.061 0.065 0.069 0.073 0.077 0.082 0.087 0.092 0.098 0.105 0.112 0.12];

            end;
            %initialize files in which will save the above vars
            %for psie = -12.2:
            file1 = 'linear_vars9_sn_v3.mat';
            file2 = 'nonlinear_vars9_sn_v3.mat';
            %for the linear 8ZLB shock size nonlin values:
            %file2 = 'nonlinear_vars9_ONEsn_v3.mat';
            %for psie = 0:
            %file1 = 'linear_vars9_sn_psie0_v3.mat';
            %file2 = 'nonlinear_vars9_sn_psie0_v3.mat';
        end;

        %initialize cells in which model's variable values will be stored for each set of parameters
        var_values_lin_index = cell(length(signus),1);
        var_values_index = cell(length(signus),1);
        %with government shock
        var_values_linG_index = cell(length(signus),1);
        var_values_indexG = cell(length(signus),1);


        %FOR LOOP START
        for i=1:length(signus);

            %set value of signu for this iteration
            signu_idx=loc(M_.param_names(:,:),'signu'); 
            M_.params(signu_idx)=signus(i);

            shocks;   
                var deltaV_eps;
                periods 1:1; 
                values 0;
                var nuV_eps;  %cons. demand   
                periods 1:1; 
                values -1;  
                var gV_eps;  %gov. consumption  
                periods 1:1; 
                values 0; 
            end;

            steady;resid;check; modelindex_steadystate;
            
            options_.slowc = .5;
            
            %start simulating next time from previous solution
            if i > 1,
                oo_.endo_simul=oo_endo_simul_lastiter1;
            end;    

            %reset starting point for simulation when going from big shocks back to small shocks (lin to index)
            if i == 1 & j > 1
                oo_.endo_simul = oo_endo_simul_first;
            end;

            simul(periods=250,stack_solve_algo=0);

            %save values at last simulation
            oo_endo_simul_lastiter1=oo_.endo_simul;

            %after first estimation, save values
            if i == 1 & j == 1
                oo_endo_simul_first = oo_.endo_simul;
            end;

            if linear == 1,
                %save LINEAR output, NO government shock
                oo_endo_simul_lin=oo_.endo_simul([13:23,24,53,50],1:end);
                var_values_lin_index{i} = oo_endo_simul_lin;

            else,
                %save NON-LINEAR output, NO government shock
                oo_endo_simul_nl=oo_.endo_simul([1:11,12,41,29],1:end);
                var_values_index{i} = oo_endo_simul_nl;
            end;

            //////////

            %add in a government shock
            shocks;   
                var deltaV_eps;
                periods 1:1; 
                values 0;
                var nuV_eps;  %cons. demand   
                periods 1:1; 
                values -1;  
                var gV_eps;  %gov. consumption  
                periods 1:1; 
                values 1; 
            end;

            steady;resid;check; modelindex_steadystate;    

            if i > 1,
                %start simulating next time from previous solution
                oo_.endo_simul=oo_endo_simul_lastiter2;
            end;

            %reset starting point for simulation when going from big shocks back to small shocks (lin to index)
            if i == 1 & j > 1
                oo_.endo_simul = oo_endo_simul_first2;
            end;

            simul(periods=250,stack_solve_algo=0); 

            %save values at last simulation
            oo_endo_simul_lastiter2=oo_.endo_simul;

            %after first estimation, save values
            if i == 1 & j == 1
                oo_endo_simul_first2 = oo_.endo_simul;
            end;

            if linear == 1,
                %save LINEAR output, WITH government shock
                oo_endo_simul_linG=oo_.endo_simul([13:23,24,53,50],1:end);
                var_values_linG_index{i} = oo_endo_simul_linG;   

            else,
                %save NON-LINEAR output, WITH government shock
                oo_endo_simul_nlG=oo_.endo_simul([1:11,12,41,29],1:end);
                var_values_indexG{i} = oo_endo_simul_nlG;
            end;

        %FOR LOOP END
        end;

        if linear == 1,
            save(file1, 'var_values_lin_index');
            save(file1, 'var_values_linG_index', '-append');
            save(file1, 'gy', '-append');
            save(file1, 'bGy', '-append');
        else,
            save(file2, 'var_values_index');
            save(file2, 'var_values_indexG', '-append');
            save(file2, 'gy', '-append');
            save(file2, 'bGy', '-append');
        end; 

    j = j+1;
    end;
end
 