% Calculate government debt multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear

    load('nonlinear_vars667_sn_v2.mat');
    

    %/// DEBT MULTIPLIER
        
    gov_mult_kim = zeros(length(var_values_nonlin),1);

    for i = 1:length(var_values_nonlin)
        temp3 = var_values_nonlin{i,1};
        temp4 = var_values_nonlinG{i,1};

        % NONLINEAR: (b_GC - b_C)/(g_GC - g_C)
        gov_mult_kim(i) = (temp4(6,2)-temp3(6,2))/(temp4(11,2)-temp3(11,2));

    end;

    save('gov_mult_kim.mat', 'gov_mult_kim');