% Calculate government debt multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear

    load('index_vars667_sn_v3_no_indexation.mat');
    %/// DEBT MULTIPLIER
    
    debt_mult_noindex = zeros(length(var_values_index),1);
    GovDebtY_Scenario_noindex = zeros(length(var_values_index),1);
    GovDebtY_Baseline_noindex = zeros(length(var_values_index),1);

    for i = 1:length(var_values_index)
        temp7 = var_values_index{i,1};
        temp8 = var_values_indexG{i,1};

        % index
        GovDebtY_Scenario_noindex(i) = temp8(8,5) - (bGy/4) * temp8(6,5);
        GovDebtY_Baseline_noindex(i) = temp7(8,5) - (bGy/4) * temp7(6,5);
        debt_mult_noindex(i) = (GovDebtY_Scenario_noindex(i) - GovDebtY_Baseline_noindex(i))/.0001;

    end;

 
    save('debt_mult_noindex.mat', 'debt_mult_noindex');