% Calculate government debt multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear


    load('nonlinear_vars9_sn_psie0_v2.mat');
    

    %/// DEBT MULTIPLIER
        
    debt_mult_ds = zeros(length(var_values_nonlin),1);
    GovDebtY_Scenario_nonlin = zeros(length(var_values_nonlin),1);
    GovDebtY_Baseline_nonlin = zeros(length(var_values_nonlin),1);

    for i = 1:length(var_values_nonlin)
        temp3 = var_values_nonlin{i,1};
        temp4 = var_values_nonlinG{i,1};

        % NONLINEAR: (b_GC - b_C)/(g_GC - g_C)
        GovDebtY_Scenario_nonlin(i) = temp4(8,5) - (bGy/4) * temp4(6,5);
        GovDebtY_Baseline_nonlin(i) = temp3(8,5) - (bGy/4) * temp3(6,5);
        debt_mult_ds(i) = (GovDebtY_Scenario_nonlin(i) - GovDebtY_Baseline_nonlin(i))/.0001;

    end;

    save('debt_mult_ds.mat', 'debt_mult_ds');