clear
close all

load('gov_mult_noindex.mat');

load('debt_mult_noindex.mat');

load('index_vars667_sn_v3_no_indexation.mat');
var_values_noindexG_122 = var_values_indexG;
var_values_noindex = var_values_index;
clear var_values_nonlin var_values_nonlinG;
[exp_inf_noindex] = get_exp_inf(var_values_index, var_values_indexG);

load('nonlinear_vars667_sn_v2.mat');
var_values_kimG = var_values_nonlinG;
var_values_kim = var_values_nonlin;
clear var_values_nonlin var_values_nonlinG;
[exp_inf_kim] = get_exp_inf(var_values_kim, var_values_kimG);

load('gov_mult_kim.mat');

load('gov_mult_ds.mat');

load('debt_mult_kim.mat');

load('debt_mult_ds.mat');

load('nonlinear_vars9_sn_psie0_v2.mat');
var_values_ds = var_values_nonlin;
var_values_dsG = var_values_nonlinG;
clear var_values_nonlin var_values_nonlinG;

[exp_inf_ds] = get_exp_inf(var_values_ds, var_values_dsG);

ZLBquarters = [0 1 2 3 4 5 6 7 8 9 10 11 12];
ZLBquarters1 = [0 1 2 3 4 5 6 7 8 9 10 11 12];

figure1 = figure;

[xb, yb] = stairs(ZLBquarters, gov_mult_kim(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, gov_mult_ds(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h1=subplot(2,3,1);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
axis([-.5 12 .2 2.2]);
set(gca,'XTick',(0:2:12));
temp2=title('Impact Spending Multiplier');
xlabel('ZLB duration, quarters');
ylabel('Multiplier');
hold off;

[xb, yb] = stairs(ZLBquarters, exp_inf_kim(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, exp_inf_ds(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h2=subplot(2,3,2);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
axis([-.5 12 0 1.8]);
set(gca,'XTick',(0:2:12));
title('Expected Inflation (4\cdotE_t\pi_t_+_1)');
ylabel('Percentage Points');
xlabel('ZLB duration, quarters');
hold off;

[xb, yb] = stairs(ZLBquarters, debt_mult_kim(1:length(ZLBquarters), 1));
[xc, yc] = stairs(ZLBquarters, debt_mult_ds(1:length(ZLBquarters), 1));

xb = [xb ; ZLBquarters(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters(end)+.5];
yc = [yc; yc(end)];

xb = xb - .5;
xc = xc - .5;

yc(1) = yb(1);
yc(2) = yb(1);

h3=subplot(2,3,3);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
line ([-.5 12],[0 0],'Color',[.8 .8 .8],'LineWidth',1.1);
axis([-.5 12 -7.5 3.5]);
set(gca,'XTick',(0:2:12));
title('Govt Debt to GDP (After 1 Year)');
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

[xc, yc] = stairs(ZLBquarters1, gov_mult_kim(1:length(ZLBquarters1), 1));
[xd, yd] = stairs(ZLBquarters1, gov_mult_noindex(1:length(ZLBquarters1), 1));

xc = [xc ; ZLBquarters1(end)+.5];
yc = [yc; yc(end)];
xd = [xd; ZLBquarters1(end)+.5];
yd = [yd; yd(end)];

xc = xc - .5;
xd = xd - .5;

yd(1) = yc(1);
yd(2) = yc(1);

leg1 = legend('Kimball (Benchmark)', 'Dixit Stiglitz');
set(leg1, 'Orientation', 'Horizontal','Position',[0.433738425925924 0.868322608843306 0.157118055555556 0.0228215767634855],'FontSize',8);

h4=subplot(2,3,4);
plot(xc, yc, '-k','LineWidth',1.5);
hold on;
plot(xd, yd, ':r','LineWidth',1.5);
axis([-.5 12 .2 2.2]);
%axis([-.5 12 .238 .24]);
set(gca,'XTick',(0:2:12));
title('Impact Spending Multiplier');
%temp1=title('Potential Multiplier');
xlabel('ZLB duration, quarters');
ylabel('Multiplier');
hold off;

[xc, yc] = stairs(ZLBquarters1, exp_inf_kim(1:length(ZLBquarters1), 1));
[xd, yd] = stairs(ZLBquarters1, exp_inf_noindex(1:length(ZLBquarters1), 1));

xc = [xc ; ZLBquarters1(end)+.5];
yc = [yc; yc(end)];
xd = [xd; ZLBquarters1(end)+.5];
yd = [yd; yd(end)];

xc = xc - .5;
xd = xd - .5;

yd(1) = yc(1);
yd(2) = yc(1);

h5=subplot(2,3,5);
plot(xc, yc, '-k','LineWidth',1.5);
hold on;
plot(xd, yd, ':r','LineWidth',1.5);
axis([-.5 12 0 1.8]);
set(gca,'XTick',(0:2:12));
t1=title('Expected inflation (4\cdotE_t\pi_t_+_1)');
set(t1,'Position',[5.6979 1.81 1.0001]);
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

[xc, yc] = stairs(ZLBquarters1, debt_mult_kim(1:length(ZLBquarters1), 1));
[xd, yd] = stairs(ZLBquarters1, debt_mult_noindex(1:length(ZLBquarters1), 1));

xc = [xc ; ZLBquarters1(end)+.5];
yc = [yc; yc(end)];
xd = [xd; ZLBquarters1(end)+.5];
yd = [yd; yd(end)];

xc = xc - .5;
xd = xd - .5;

yd(1) = yc(1);
yd(2) = yc(1);

h6=subplot(2,3,6);
plot(xc, yc, '-k','LineWidth',1.5);
hold on;
plot(xd, yd, ':r','LineWidth',1.5);
line ([-.5 12],[0 0],'Color',[.8 .8 .8],'LineWidth',1.1);
axis([-.5 12 -7.5 3.5]);
set(gca,'XTick',(0:2:12));
title('Govt Debt to GDP (After 1 Year)');
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

set(h1,'Position',[0.1315625 0.584585968947067 0.213405797101449 0.2251869720014]);
set(h2,'Position',[0.406109601449275 0.584585968947067 0.213405797101449 0.2251869720014]);
set(h3,'Position',[0.687948369565218 0.584585968947067 0.213405797101449 0.2251869720014]);
set(h4,'Position',[0.1315625 0.12442934806894 0.213405797101449 0.242895555243912]);
set(h5,'Position',[0.406630434782608 0.123464272105368 0.213405797101449 0.242895555243912]);
set(h6,'Position',[0.686385869565218 0.12442934806894 0.213405797101449 0.242895555243912]);

annotation(figure1,'textbox',[0.356979166666666 0.885373443983401 0.8 0.0311203319502075],'String',{'Panel A: Kimball (\xi_{p}=0.667; \psi=-12.2) vs. Dixit-Stiglitz (\xi_{p}=0.9; \psi=0)'},'FontSize',10, 'LineStyle','none','FontWeight','demi');
annotation(figure1,'textbox',[0.349999999999999 0.452261410788381 0.8 0.033195020746888],'String',{'Panel B: Impact of Indexation Assumption for Non-Optimizing Firms'},'FontSize',10,'LineStyle','none','FontWeight','demi');

suptitle('       Figure A.4: Sensitivity Analysis of Marginal Multipliers in Nonlinear Model');


leg2 = legend('With Indexation (Benchmark)', 'No Indexation');
set(leg2, 'Orientation', 'Horizontal','Position',[0.429571759259258 0.408291396060367 0.186284722222222 0.024896265560166],'FontSize',8);

orient(figure(1),'landscape');
set(figure(1), 'PaperUnits', 'inches', 'PaperPosition', [.25 .25 10.5 8]);

print -depsc2 '-r1200' 'FigureA4.eps';
fixPSlinestyle('FigureA4.eps');