% Calculate government debt multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear
    load('linear_vars667_sn_v2.mat');
    load('nonlinear_vars667_sn_v2.mat');

    %/// DEBT MULTIPLIER
        
    debt_mult_lin = zeros(length(var_values_lin),1);
    GovDebtY_Scenario_lin = zeros(length(var_values_lin),1);
    GovDebtY_Baseline_lin = zeros(length(var_values_lin),1);
    debt_mult_nonlin = zeros(length(var_values_nonlin),1);
    GovDebtY_Scenario_nonlin = zeros(length(var_values_nonlin),1);
    GovDebtY_Baseline_nonlin = zeros(length(var_values_nonlin),1);

    for i = 1:length(var_values_lin)

        temp1 = var_values_lin{i,1};
        temp2 = var_values_linG{i,1};
        
        temp3 = var_values_nonlin{i,1};
        temp4 = var_values_nonlinG{i,1};
        
        
        % LINEAR: [bhat_GC - bhat_C] / [(1+ghat_GC)*gbar -
        % (1+ghat_C)*gbar] = (b_GC - b_C)/(g_GC - g_C)
        GovDebtY_Scenario_lin(i) = temp2(8,5) - (bGy/4) * temp2(6,5);
        GovDebtY_Baseline_lin(i) = temp1(8,5) - (bGy/4) * temp1(6,5);
        debt_mult_lin(i) = (GovDebtY_Scenario_lin(i) - GovDebtY_Baseline_lin(i))/.0001;
        % NONLINEAR: (b_GC - b_C)/(g_GC - g_C)
        GovDebtY_Scenario_nonlin(i) = temp4(8,5) - (bGy/4) * temp4(6,5);
        GovDebtY_Baseline_nonlin(i) = temp3(8,5) - (bGy/4) * temp3(6,5);
        debt_mult_nonlin(i) = (GovDebtY_Scenario_nonlin(i) - GovDebtY_Baseline_nonlin(i))/.0001;
    end;

    save('debt_mult_sn.mat', 'debt_mult_lin', 'debt_mult_nonlin');