%plot difference of scenario and baseline

        
load baseline_data realG_base_det_lin realG_base_det_nonlin realG_base_stoch_lin realG_base_stoch_nonlin realGDP_base_det_lin realGDP_base_det_nonlin realGDP_base_stoch_lin realGDP_base_stoch_nonlin infl_base_det_lin infl_base_det_nonlin infl_base_stoch_lin infl_base_stoch_nonlin
load scenario_data realG_scen_det_lin realG_scen_det_nonlin realG_scen_stoch_lin realG_scen_stoch_nonlin realGDP_scen_det_lin realGDP_scen_det_nonlin realGDP_scen_stoch_lin realGDP_scen_stoch_nonlin infl_scen_det_lin infl_scen_det_nonlin infl_scen_stoch_lin infl_scen_stoch_nonlin

load steadystate

show_time=8;

scale=1/100;%scaling of shocks set in comp_scenario.m; Watch out: hard-coded here to redo figure 5 as Jesper wants it.

%calc GDP deviations of scenario from baseline (in percent of ss GDP)
GDP_diff_det_lin=1/scale*100*((realGDP_scen_det_lin(1:show_time+1)-ss.y)/ss.y-(realGDP_base_det_lin(1:show_time+1)-ss.y)/ss.y); 
GDP_diff_det_nonlin=1/scale*100*((realGDP_scen_det_nonlin(1:show_time+1)-ss.y)/ss.y-(realGDP_base_det_nonlin(1:show_time+1)-ss.y)/ss.y); 
GDP_diff_stoch_lin=1/scale*100*((realGDP_scen_stoch_lin(1:show_time+1)-ss.y)/ss.y-(realGDP_base_stoch_lin(1:show_time+1)-ss.y)/ss.y); 
GDP_diff_stoch_nonlin=1/scale*100*((realGDP_scen_stoch_nonlin(1:show_time+1)-ss.y)/ss.y-(realGDP_base_stoch_nonlin(1:show_time+1)-ss.y)/ss.y); 

%calc inflation deviations
infl_diff_det_lin=1/scale*((infl_scen_det_lin(1:show_time+1)-ss.pie)-(infl_base_det_lin(1:show_time+1)-ss.pie));
infl_diff_det_nonlin=1/scale*((infl_scen_det_nonlin(1:show_time+1))-ss.pie-(infl_base_det_nonlin(1:show_time+1)-ss.pie));
infl_diff_stoch_lin=1/scale*((infl_scen_stoch_lin(1:show_time+1))-ss.pie-(infl_base_stoch_lin(1:show_time+1)-ss.pie));
infl_diff_stoch_nonlin=1/scale*((infl_scen_stoch_nonlin(1:show_time+1)-ss.pie)-(infl_base_stoch_nonlin(1:show_time+1)-ss.pie));
 
time=0:1:show_time;
figure;
subplot(2,2,1)
plot(time,GDP_diff_det_lin,'k-','LineWidth',2); hold on
plot(time,GDP_diff_stoch_lin,'r--','LineWidth',2); hold off  
%text(time(2),GDP_diff_det_lin(2)+0.05,['  ',num2str(GDP_diff_det_lin(2),'%1.2f\n')]);
%text(time(2),GDP_diff_stoch_lin(2)+0.05,['  ',num2str(GDP_diff_stoch_lin(2),'%1.2f\n')]);
axis tight
axis([0 8 -0.1 2.2])
set(gca,'Fontsize',12);
title('Real GDP (Percent)','Fontsize',12);
%xlabel('Quarters','Fontsize',12);
%legend('Perfect Foresight (No Shock Uncertainty)','Stochastic Solution (Shock Uncertainty)','Location','Northeast');
%legend boxoff;
 

subplot(2,2,2)
plot(time,infl_diff_det_lin,'k-','LineWidth',2); hold on
plot(time,infl_diff_stoch_lin,'r--','LineWidth',2); hold off   
%text(time(2),infl_diff_det_lin(2)+0.05,['  ',num2str(infl_diff_det_lin(2),'%1.2f\n')]);
%text(time(2),infl_diff_stoch_lin(2)+0.025,['  ',num2str(infl_diff_stoch_lin(2),'%1.2f\n')]);
axis tight
axis([0 8 -0.1 2.2])
set(gca,'Fontsize',12);
title('Inflation (Annual Percent)','Fontsize',12);
%xlabel('Quarters','Fontsize',12);
%legend('Perfect Foresight (No Shock Uncertainty)','Stochastic Solution (Shock Uncertainty)','Location','Northeast');
%legend boxoff;



subplot(2,2,3)
plot(time,GDP_diff_det_nonlin,'k-','LineWidth',2); hold on
plot(time,GDP_diff_stoch_nonlin,'r--','LineWidth',2); hold on
%text(time(2),GDP_diff_det_nonlin(2)-0.07,['  ',num2str(GDP_diff_det_nonlin(2),'%1.2f\n')]);
%text(time(2),GDP_diff_stoch_nonlin(2)+0.07,['  ',num2str(GDP_diff_stoch_nonlin(2),'%1.2f\n')]);
axis tight
axis([0 8 -0.1 2.2])
set(gca,'Fontsize',12);
title('Real GDP (Percent)','Fontsize',12);
xlabel('Quarters','Fontsize',12);
%legend('Perfect Foresight (No Shock Uncertainty)','Stochastic Solution (Shock Uncertainty)','Location','Northeast');
%legend boxoff;


subplot(2,2,4)
plot(time,infl_diff_det_nonlin,'k-','LineWidth',2); hold on
plot(time,infl_diff_stoch_nonlin,'r--','LineWidth',2); hold on
%text(time(2),infl_diff_det_nonlin(2)-0.06,['  ',num2str(infl_diff_det_nonlin(2),'%1.3f\n')]);
%text(time(2),infl_diff_stoch_nonlin(2)+0.08,['  ',num2str(infl_diff_stoch_nonlin(2),'%1.3f\n')]);
axis tight
axis([0 8 -0.1 2.2])
set(gca,'Fontsize',12);
title('Inflation (Annual Percent)','Fontsize',12);
xlabel('Quarters','Fontsize',12);
 
suptitle('Figure 5: Effects of an Increase in Government Spending in an 8-Quarter Liquidity Trap     ');
legend('Deterministic Solution (No Shock Uncertainty)','Stochastic Solution (Shock Uncertainty)','Location','Northeast');
legend boxoff;


annotation('textbox',[0.00644329896907217 0.821904761904762 1 0.1],...
    'String','Panel A: Linearized Model Solution',...
    'HorizontalAlignment','center',...
    'FitBoxToText','off',...
    'EdgeColor','none','FontSize',14);


annotation('textbox',[0.00399531855291547 0.378809162511743 1 0.1],...
    'String','Panel B: Nonlinear Model Solution',...
    'HorizontalAlignment','center',...
    'FitBoxToText','off',...
    'EdgeColor','none','FontSize',14);


text(-11,-.52-0.2,['  Notes: GDP and Inflation dev. of scenario from baseline (in % of steady state GDP). Baseline: 8-quarter ZLB. Scenario: baseline plus government spending (scaled to 1% of steady state GDP).'],'Interpreter','Tex','FontSize',9); 

orient landscape
set(gcf, 'PaperPositionMode', 'manual');
set(gcf, 'PaperUnits', 'inches');
set(gcf, 'PaperPosition', [-1 .2 13 8.2]);
print('-dpdf', ['Figure5']);
%print('-depsc2', ['Figure5']);
print -depsc2 '-r1200' 'Figure5.eps';

  

