% Calculate government spending multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear
for file = [667]
    
    load(sprintf('nonlinear_vars%d_sn_v2.mat', file));
    load(sprintf('linear_vars%d_sn_v2.mat', file));
    load(sprintf('pseudolinear_vars%d_sn_v2.mat', file));
    load(sprintf('pcurve_vars%d_sn_v3.mat', file));

    %/// GOV SPENDING MULTIPLIER

    gov_mult_lin = zeros(length(var_values_lin),1);
    gov_mult_nonlin = zeros(length(var_values_nonlin),1);
    gov_mult_pcurve = zeros(length(var_values_pcurve),1);
    gov_mult_pseudolin = zeros(length(var_values_pseudolin),1);

    for i = 1:length(var_values_lin)

        temp1 = var_values_lin{i,1};
        temp2 = var_values_linG{i,1};

        temp3 = var_values_nonlin{i,1};
        temp4 = var_values_nonlinG{i,1};
        
        temp5 = var_values_pseudolin{i,1};
        temp6 = var_values_pseudolinG{i,1};
       
        temp7 = var_values_pcurve{i,1};
        temp8 = var_values_pcurveG{i,1};

        % LINEAR: (yG-ybase)/(gG-gbase) * 1/.2, gbase is 0
        gov_mult_lin(i) = ((temp2(6,2)-temp1(6,2))/(temp2(11,2)-temp1(11,2)))*1/gy;
        % NONLINEAR: (yG-ybase)/(gG-gbase)
        gov_mult_nonlin(i) = (temp4(6,2)-temp3(6,2))/(temp4(11,2)-temp3(11,2));
        % PSEUDOLINEAR: (yG-ybase)/(gG-gbase)
        gov_mult_pseudolin(i) = (temp6(6,2)-temp5(6,2))/(temp6(11,2)-temp5(11,2));
       % PCURVE
       gov_mult_pcurve(i) = (temp8(6,2)-temp7(6,2))/(temp8(11,2)-temp7(11,2));
    end;

    filename = sprintf('gov_mult%d_sn_pcurve', file);
    save(filename, 'gov_mult_lin', 'gov_mult_nonlin', 'gov_mult_pseudolin', 'gov_mult_pcurve');

end;