% Calculate government debt multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear
for file = [667]

    load(sprintf('nonlinear_vars%d_sn_v2.mat', file));
    load(sprintf('linear_vars%d_sn_v2.mat', file));
    load(sprintf('pseudolinear_vars%d_sn_v2.mat', file));
    load(sprintf('pcurve_vars%d_sn_v3.mat', file));


    %/// DEBT MULTIPLIER
        
    debt_mult_lin = zeros(length(var_values_lin),1);
    debt_mult_nonlin = zeros(length(var_values_nonlin),1);
    debt_mult_pcurve = zeros(length(var_values_pcurve),1);
    debt_mult_pseudolin = zeros(length(var_values_pseudolin),1);
    GovDebtY_Scenario_lin = zeros(length(var_values_lin),1);
    GovDebtY_Baseline_lin = zeros(length(var_values_lin),1);
    GovDebtY_Scenario_nonlin = zeros(length(var_values_nonlin),1);
    GovDebtY_Baseline_nonlin = zeros(length(var_values_nonlin),1);
    GovDebtY_Scenario_pcurve = zeros(length(var_values_pcurve),1);
    GovDebtY_Baseline_pcurve = zeros(length(var_values_pcurve),1);
    GovDebtY_Scenario_pseudolin = zeros(length(var_values_pseudolin),1);
    GovDebtY_Baseline_pseudolin = zeros(length(var_values_pseudolin),1);

    for i = 1:length(var_values_lin)

        temp1 = var_values_lin{i,1};
        temp2 = var_values_linG{i,1};

        temp3 = var_values_nonlin{i,1};
        temp4 = var_values_nonlinG{i,1};
        
        temp5 = var_values_pseudolin{i,1};
        temp6 = var_values_pseudolinG{i,1};
        
        temp7 = var_values_pcurve{i,1};
        temp8 = var_values_pcurveG{i,1};

        % LINEAR: [bhat_GC - bhat_C] / [(1+ghat_GC)*gbar -
        % (1+ghat_C)*gbar] = (b_GC - b_C)/(g_GC - g_C)
        GovDebtY_Scenario_lin(i) = temp2(8,5) - (bGy/4) * temp2(6,5);
        GovDebtY_Baseline_lin(i) = temp1(8,5) - (bGy/4) * temp1(6,5);
        debt_mult_lin(i) = (GovDebtY_Scenario_lin(i) - GovDebtY_Baseline_lin(i))/.0001;
        % NONLINEAR: (b_GC - b_C)/(g_GC - g_C)
        GovDebtY_Scenario_nonlin(i) = temp4(8,5) - (bGy/4) * temp4(6,5);
        GovDebtY_Baseline_nonlin(i) = temp3(8,5) - (bGy/4) * temp3(6,5);
        debt_mult_nonlin(i) = (GovDebtY_Scenario_nonlin(i) - GovDebtY_Baseline_nonlin(i))/.0001;
        % PSEUDOLINEAR: (b_GC - b_C)/(g_GC - g_C)
       GovDebtY_Scenario_pseudolin(i) = temp6(8,5) - (bGy/4) * temp6(6,5);
        GovDebtY_Baseline_pseudolin(i) = temp5(8,5) - (bGy/4) * temp5(6,5);
        debt_mult_pseudolin(i) = (GovDebtY_Scenario_pseudolin(i) - GovDebtY_Baseline_pseudolin(i))/.0001;
        % PCURVE
        GovDebtY_Scenario_pcurve(i) = temp8(8,5) - (bGy/4) * temp8(6,5);
        GovDebtY_Baseline_pcurve(i) = temp7(8,5) - (bGy/4) * temp7(6,5);
        debt_mult_pcurve(i) = (GovDebtY_Scenario_pcurve(i) - GovDebtY_Baseline_pcurve(i))/.0001;

    end;

    filename = sprintf('debt_mult%d_sn_pcurve', file);
    save(filename, 'debt_mult_lin', 'debt_mult_nonlin', 'debt_mult_pseudolin', 'debt_mult_pcurve');

end;