% Calculate government debt multiplier for Calvo price stickiness
% parameters .75, .8, and .9 for the linear and nonlinear versions of the
% model.

clear
for file = [667]

    load(sprintf('nonlinear_vars%d_sn_v2.mat', file));
    load(sprintf('linear_vars%d_sn_v2.mat', file));
    load(sprintf('pseudolinear_vars%d_sn_v2.mat', file));


    %/// DEBT MULTIPLIER
        
    debt_mult_lin = zeros(length(var_values_lin),1);
    debt_mult_nonlin = zeros(length(var_values_nonlin),1);
    debt_mult_pseudolin = zeros(length(var_values_pseudolin),1);

    for i = 1:length(var_values_lin)

        temp1 = var_values_lin{i,1};
        temp2 = var_values_linG{i,1};

        temp3 = var_values_nonlin{i,1};
        temp4 = var_values_nonlinG{i,1};
        
        temp5 = var_values_pseudolin{i,1};
        temp6 = var_values_pseudolinG{i,1};

        % LINEAR: [bhat_GC - bhat_C] / [(1+ghat_GC)*gbar -
        % (1+ghat_C)*gbar] = (b_GC - b_C)/(g_GC - g_C)
        debt_mult_lin(i) = (temp2(8,5) - temp1(8,5))/.0001;
        % NONLINEAR: (b_GC - b_C)/(g_GC - g_C)
        debt_mult_nonlin(i) = (temp4(8,5)-temp3(8,5))/.0001;
        % PSEUDOLINEAR: (b_GC - b_C)/(g_GC - g_C)
        debt_mult_pseudolin(i) = (temp6(8,5)-temp5(8,5))/.0001;

    end;

    filename = sprintf('debt_mult%d_sn_v2', file);
    save(filename, 'debt_mult_lin', 'debt_mult_nonlin', 'debt_mult_pseudolin');

end;