clear all;
close all;

%%%RUN calc_debt_mult_v3_figure3.m to calculate proper debt_multipliers!

load('gov_mult667_sn_v2');
gov_mult_lin_122 = gov_mult_lin;
gov_mult_nonlin_122 = gov_mult_nonlin;
gov_mult_pseudolin_122 = gov_mult_pseudolin;
clear gov_mult_lin gov_mult_nonlin gov_mult_pseudolin;

load('gov_mult667_sn_psie0_v2');
gov_mult_lin_0 = gov_mult_lin;
gov_mult_nonlin_0 = gov_mult_nonlin;
gov_mult_pseudolin_0 = gov_mult_pseudolin;
clear gov_mult_lin gov_mult_nonlin gov_mult_pseudolin;

load('debt_mult667_sn_v2.mat');
debt_mult_lin_122 = debt_mult_lin;
debt_mult_nonlin_122 = debt_mult_nonlin;
debt_mult_pseudolin_122 = debt_mult_pseudolin;
clear debt_mult_lin debt_mult_nonlin debt_mult_pseudolin;

load('debt_mult667_sn_psie0_v2.mat');
debt_mult_lin_0 = debt_mult_lin;
debt_mult_nonlin_0 = debt_mult_nonlin;
debt_mult_pseudolin_0 = debt_mult_pseudolin;
clear debt_mult_lin debt_mult_nonlin debt_mult_pseudolin;

load('linear_vars667_sn_v2.mat');
load('nonlinear_vars667_sn_v2.mat');
load('pseudolinear_vars667_sn_v2.mat');
model = 5;
var_values_nonlin_122 = var_values_nonlin;
var_values_nonlinG_122 = var_values_nonlinG;
var_values_pseudolin_122 = var_values_pseudolin;
var_values_pseudolinG_122 = var_values_pseudolinG;


inf_from_nonlin_mc=lin_inf_nonlin(var_values_nonlin);
inf_from_nonlin_mcG=lin_inf_nonlin(var_values_nonlinG);


[var_values_lin_levels_122, var_values_linG_levels_122] = make_levels_from_lin(var_values_lin, var_values_linG, var_values_nonlin, model);
clear var_values_nonlin var_values_nonlinG var_values_pseudolin var_values_pseudolinG var_values_lin var_values_linG;

load('linear_vars667_sn_psie0_v2.mat');
load('nonlinear_vars667_sn_psie0_v2.mat');
load('pseudolinear_vars667_sn_psie0_v2.mat');
model = 5;
var_values_nonlin_0 = var_values_nonlin;
var_values_nonlinG_0 = var_values_nonlinG;
var_values_pseudolin_0 = var_values_pseudolin;
var_values_pseudolinG_0 = var_values_pseudolinG;

inf_from_nonlin_mc_DS=lin_inf_nonlin_DS(var_values_nonlin);
inf_from_nonlin_mcG_DS=lin_inf_nonlin_DS(var_values_nonlinG);

[var_values_lin_levels_0, var_values_linG_levels_0] = make_levels_from_lin(var_values_lin, var_values_linG, var_values_nonlin, model);
clear var_values_nonlin var_values_nonlinG var_values_pseudolin var_values_pseudolinG var_values_lin var_values_linG;


% 
% [exp_r_lin_0] = get_exp_r(var_values_lin_levels_0, var_values_linG_levels_0);
% [exp_r_lin_122] = get_exp_r(var_values_lin_levels_122, var_values_linG_levels_122);
% [exp_r_nonlin_0] = get_exp_r(var_values_nonlin_0, var_values_nonlinG_0);
% [exp_r_nonlin_122] = get_exp_r(var_values_nonlin_122, var_values_nonlinG_122);


[exp_inf_lin_122] = get_exp_inf(var_values_lin_levels_122, var_values_linG_levels_122);
[exp_inf_lin_mc] = get_exp_inf_mc(inf_from_nonlin_mc, inf_from_nonlin_mcG);
[exp_inf_nonlin_122] = get_exp_inf(var_values_nonlin_122, var_values_nonlinG_122);
[exp_inf_pseudolin_122] = get_exp_inf(var_values_pseudolin_122, var_values_pseudolinG_122);


[exp_inf_lin_0] = get_exp_inf(var_values_lin_levels_0, var_values_linG_levels_0);
[exp_inf_lin_mc_DS] = get_exp_inf_mc(inf_from_nonlin_mc_DS, inf_from_nonlin_mcG_DS);
[exp_inf_nonlin_0] = get_exp_inf(var_values_nonlin_0, var_values_nonlinG_0);
[exp_inf_pseudolin_0] = get_exp_inf(var_values_pseudolin_0, var_values_pseudolinG_0);


ZLBquarters1 = [0 1 2 3 4 5 6 7 8 9 10 11 12];
ZLBquarters2 = [0 1 2 3 4 5 6 7 8];

figure1 = figure;


[xb, yb] = stairs(ZLBquarters1, gov_mult_lin_122(1:length(ZLBquarters1), 1));
[xc, yc] = stairs(ZLBquarters1, gov_mult_nonlin_122(1:length(ZLBquarters1), 1));
[xd, yd] = stairs(ZLBquarters1, gov_mult_pseudolin_122(1:length(ZLBquarters1), 1));


xb = [xb ; ZLBquarters1(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters1(end)+.5];
yc = [yc; yc(end)];

xd = [xd ; ZLBquarters1(end)+.5];
yd = [yd ; yd(end)];

xb = xb - .5;
xc = xc - .5;
xd = xd - .5;

yc(1) = yb(1);
yd(1) = yb(1);
yc(2) = yb(1);
yd(2) = yb(1);

h1=subplot(2,3,1);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
%plot(xd, yd, '-.b','LineWidth',1.5);
axis([-.5 12 .2 2.2]);
%axis([-.5 12 .238 .24]);
set(gca,'XTick',(0:2:12));
temp1=title('Impact Spending Multiplier');
%temp1=title('Potential Multiplier');
xlabel('ZLB duration, quarters');
ylabel('Multiplier');
hold off;



[xb, yb] = stairs(ZLBquarters1, exp_inf_lin_122(1:length(ZLBquarters1), 1));
[xc, yc] = stairs(ZLBquarters1, exp_inf_nonlin_122(1:length(ZLBquarters1), 1));
[xd, yd] = stairs(ZLBquarters1, exp_inf_pseudolin_122(1:length(ZLBquarters1), 1));
[xe, ye] = stairs(ZLBquarters1, exp_inf_lin_mc(1:length(ZLBquarters1), 1));

xb = [xb ; ZLBquarters1(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters1(end)+.5];
yc = [yc; yc(end)];

xd = [xd ; ZLBquarters1(end)+.5];
yd = [yd ; yd(end)];

xe = [xe ; ZLBquarters1(end)+.5];
ye = [ye ; ye(end)];

xb = xb - .5;
xc = xc - .5;
xd = xd - .5;
xe = xe - .5;

yc(1) = yb(1);
yd(1) = yb(1);
yc(2) = yb(1);
yd(2) = yb(1);
ye(1)=yb(1);
ye(2)=yb(1);


h2=subplot(2,3,2);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
%plot(xe, ye, '-.b','LineWidth',1.5);
axis([-.5 12 0 1.8]);
set(gca,'XTick',(0:2:12));
t1=title('Expected inflation (4\cdotE_t\pi_t_+_1)');
set(t1,'Position',[5.6979 1.81 1.0001]);
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;


[xb, yb] = stairs(ZLBquarters1, debt_mult_lin_122(1:length(ZLBquarters1), 1));
[xc, yc] = stairs(ZLBquarters1, debt_mult_nonlin_122(1:length(ZLBquarters1), 1));
[xd, yd] = stairs(ZLBquarters1, debt_mult_pseudolin_122(1:length(ZLBquarters1), 1));

xb = [xb ; ZLBquarters1(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters1(end)+.5];
yc = [yc; yc(end)];

xd = [xd ; ZLBquarters1(end)+.5];
yd = [yd ; yd(end)];

xb = xb - .5;
xc = xc - .5;
xd = xd - .5;

yc(1) = yb(1);
yd(1) = yb(1);
yc(2) = yb(1);
yd(2) = yb(1);

h3=subplot(2,3,3);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
%plot(xd, yd, '-.b','LineWidth',1.5);
line ([-.5 12],[0 0],'Color',[.8 .8 .8],'LineWidth',1.1);
axis([-.5 12 -7.5 3.5]);
set(gca,'XTick',(0:2:12));
title('Govt Debt to GDP (After 1 Year)');
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

[xb, yb] = stairs(ZLBquarters2, gov_mult_lin_0(1:length(ZLBquarters2), 1));
[xc, yc] = stairs(ZLBquarters2, gov_mult_nonlin_0(1:length(ZLBquarters2), 1));
[xd, yd] = stairs(ZLBquarters2, gov_mult_pseudolin_0(1:length(ZLBquarters2), 1));

xb = [xb ; ZLBquarters2(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters2(end)+.5];
yc = [yc; yc(end)];

xd = [xd ; ZLBquarters2(end)+.5];
yd = [yd ; yd(end)];

xb = xb - .5;
xc = xc - .5;
xd = xd - .5;

yc(1) = yb(1);
yd(1) = yb(1);
yc(2) = yb(1);
yd(2) = yb(1);

h4=subplot(2,3,4);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
%plot(xd, yd, '-.b','LineWidth',1.5);
axis([-.5 8 -1 30]);
%axis([-.5 8 .238 .24]);
temp2=title('Impact Spending Multiplier');
%temp2=title('Potential Multiplier');
xlabel('ZLB duration, quarters');
ylabel('Multiplier');
hold off;


[xb, yb] = stairs(ZLBquarters2, exp_inf_lin_0(1:length(ZLBquarters2), 1));
[xc, yc] = stairs(ZLBquarters2, exp_inf_nonlin_0(1:length(ZLBquarters2), 1));
[xd, yd] = stairs(ZLBquarters2, exp_inf_pseudolin_0(1:length(ZLBquarters2), 1));
[xe, ye] = stairs(ZLBquarters2, exp_inf_lin_mc_DS(1:length(ZLBquarters2), 1));

xb = [xb ; ZLBquarters2(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters2(end)+.5];
yc = [yc; yc(end)];

xd = [xd ; ZLBquarters2(end)+.5];
yd = [yd ; yd(end)];

xe = [xe ; ZLBquarters2(end)+.5];
ye = [ye ; ye(end)];

xb = xb - .5;
xc = xc - .5;
xd = xd - .5;
xe=xe- .5;

yc(1) = yb(1);
yd(1) = yb(1);
yc(2) = yb(1);
yd(2) = yb(1);
ye(1)=yb(1);
ye(2)=yb(2);

h5=subplot(2,3,5);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
%plot(xe, ye, '-.b','LineWidth',1.5);
axis([-.5 8 -1 80]);
t2=title('Expected Inflation (4\cdotE_t\pi_t_+_1)');
set(t2,'Position',[3.7146 80.4 1.0001]);
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;


[xb, yb] = stairs(ZLBquarters2, debt_mult_lin_0(1:length(ZLBquarters2), 1));
[xc, yc] = stairs(ZLBquarters2, debt_mult_nonlin_0(1:length(ZLBquarters2), 1));
[xd, yd] = stairs(ZLBquarters2, debt_mult_pseudolin_0(1:length(ZLBquarters2), 1));

xb = [xb ; ZLBquarters2(end)+.5];
yb = [yb; yb(end)];

xc = [xc ; ZLBquarters2(end)+.5];
yc = [yc; yc(end)];

xd = [xd ; ZLBquarters2(end)+.5];
yd = [yd ; yd(end)];

xb = xb - .5;
xc = xc - .5;
xd = xd - .5;

yc(1) = yb(1);
yd(1) = yb(1);
yc(2) = yb(1);
yd(2) = yb(1);

h6=subplot(2,3,6);
plot(xb,yb,'k','LineWidth',1.5);
hold on;
plot(xc, yc, ':r','LineWidth',1.5);
%plot(xd, yd, '-.b','LineWidth',1.5);
line ([-.5 8],[0 0],'Color',[.8 .8 .8],'LineWidth',1.1);
axis([-.5 8 -230 10]);
title('Govt Debt to GDP (After 1 Year)');
xlabel('ZLB duration, quarters');
ylabel('Percentage Points');
hold off;

set(h1,'Position',[0.13 0.525 0.213405797101449 0.311059569461639]);
set(h2,'Position',[0.410797101449275 0.525 0.213405797101449 0.311059569461639]);
set(h3,'Position',[0.691594202898551 0.525 0.213405797101449 0.311059569461639]);
set(h4,'Position',[0.13 0.09 0.213405797101449 0.311059569461639]);
set(h5,'Position',[0.410797101449275 0.09 0.213405797101449 0.311059569461639]);
set(h6,'Position',[0.691594202898551 0.09 0.213405797101449 0.311059569461639]);

annotation(figure1,'textbox',[0.425624999999999 0.875663900414938 0.8 0.0311203319502075],'String',{'Benchmark Calibration: Kimball'},'FontSize',10, 'LineStyle','none','FontWeight','demi');
annotation(figure1,'textbox',[0.420208333333333 0.438112033195021 0.8 0.033195020746888],'String',{'Alternative Calibration: Dixit Stiglitz'},'FontSize',10,'LineStyle','none','FontWeight','demi');

suptitle('       Figure 3: Marginal Multipliers for Government Spending');
leg1 = legend('Linearized Model', 'Nonlinear Model');
set(leg1, 'Orientation', 'Horizontal','Position',[0.210474537037036 0.915552806848749 0.600520833333333 0.024896265560166],'FontSize',8);

orient(figure(1),'landscape');
set(figure(1), 'PaperUnits', 'inches', 'PaperPosition', [.25 .25 10.5 8]);

print -depsc2 '-r1200' 'Figure3.eps';
fixPSlinestyle('Figure3.eps');


