clear all
close all

load('linear_vars667_sn_v2.mat');
load('nonlinear_vars667_sn_v2.mat');
load('pseudolinear_vars667_sn_v2.mat');
model = 5;
[var_values_lin_levels, var_values_linG_levels] = make_levels_from_lin(var_values_lin, var_values_linG, var_values_nonlin, model);


in_title = 'Taylor rule coefficients 1.5, .125';
num_signus = 9;
ss = var_values_nonlin{1,1}(:,1);

titles = {'1. Output Gap','2. Yearly Inflation (ln(P_t/P_{t-4}))','3. Nominal Interest Rate (APR)','4. Real Interest Rate (APR)','5. Potential Real Interest Rate (APR)','7. Real GDP','6. Price Dispersion','8. Government Debt to GDP','Lump-Sum Taxes (% of SS Output)','Labor Income Taxes','Government Consumption Shock (%)','6. Consumption Demand Shock'};
colors = {'m', 'c', 'r', 'g', 'b', 'k', '--m', 'y', '--c', '--g', ':r', '--b', '--k', '--y', '-.b'};


figure1 = figure;

counter = 1;
for i = [1 2 3 4 5 12];
    
    subplot(2,3,counter);

    if counter == 1
        for iter = 9:num_signus;
            lin_C = var_values_lin_levels{iter,1};
            lin_Ci = lin_C(i,1:21);
            plot(0:20, lin_Ci*100,colors{:,6},'LineWidth',1.7);
            hold on;
            nonlin_C = var_values_nonlin{iter,1};
            nonlin_Ci = nonlin_C(i,1:21);
            plot(0:20, nonlin_Ci*100,colors{:,11},'LineWidth',1.7);
            pseudolin_C = var_values_pseudolin{iter,1};
            pseudolin_Ci = pseudolin_C(i,1:21);
            plot(0:20, pseudolin_Ci*100,colors{:,15},'LineWidth',1.7);
            axis tight;  
            ylabel('Percent');
        end;
    elseif counter == 2      
        for iter = 9:num_signus;
            lin_C = var_values_lin_levels{iter,1};
            lin_Ci = lin_C(i,1:21);
            lin_Cii = (lin_Ci-1)*400;  
            lin_Ciij = 1:21;
            for k = (1:21);
                    lin_Ciij(1) = 0.25*(2 + 2 + 2 + lin_Cii(1));
                    lin_Ciij(2) = 0.25*(2 + 2 + lin_Cii(1) + lin_Cii(2));             
                    lin_Ciij(3) = 0.25*(2 + lin_Cii(1) + lin_Cii(2) + lin_Cii(3));
                    if k>3,
                    lin_Ciij(k) = 0.25*(lin_Cii(k-3) + lin_Cii(k-2) + lin_Cii(k-1) + lin_Cii(k));
                    end;
            end;
            plot(0:20, lin_Ciij,colors{:,6},'LineWidth',1.7);
            hold on;
            nonlin_C = var_values_nonlin{iter,1};
            nonlin_Ci = nonlin_C(i,1:21);
            nonlin_Cii = (nonlin_Ci-1)*400;  
            nonlin_Ciij = 1:21;
            for k = (1:21);
                    nonlin_Ciij(1) = 0.25*(2 + 2 + 2 + nonlin_Cii(1));
                    nonlin_Ciij(2) = 0.25*(2 + 2 + nonlin_Cii(1) + nonlin_Cii(2));             
                    nonlin_Ciij(3) = 0.25*(2 + nonlin_Cii(1) + nonlin_Cii(2) + nonlin_Cii(3));
                    if k>3,
                    nonlin_Ciij(k) = 0.25*(nonlin_Cii(k-3) + nonlin_Cii(k-2) + nonlin_Cii(k-1) + nonlin_Cii(k));
                    end;
            end;
            plot(0:20, nonlin_Ciij,colors{:,11},'LineWidth',1.7);
             pseudolin_C = var_values_pseudolin{iter,1};
             pseudolin_Ci = pseudolin_C(i,1:21);
             pseudolin_Cii = (pseudolin_Ci-1)*400;  
            pseudolin_Ciij = 1:21;
            for k = (1:21);
                    pseudolin_Ciij(1) = 0.25*(2 + 2 + 2 + pseudolin_Cii(1));
                    pseudolin_Ciij(2) = 0.25*(2 + 2 + pseudolin_Cii(1) + pseudolin_Cii(2));             
                    pseudolin_Ciij(3) = 0.25*(2 + pseudolin_Cii(1) + pseudolin_Cii(2) + pseudolin_Cii(3));
                    if k>3,
                    pseudolin_Ciij(k) = 0.25*(pseudolin_Cii(k-3) + pseudolin_Cii(k-2) + pseudolin_Cii(k-1) + pseudolin_Cii(k));
                    end;
            end;
            plot(0:20, pseudolin_Ciij,colors{:,15},'LineWidth',1.7);
            axis tight;   
            ylabel('Percent');
        end
    elseif counter == 3 || counter == 4 || counter == 5
        for iter = 9:num_signus;
            lin_C = var_values_lin_levels{iter,1};
            lin_Ci = lin_C(i,1:21);
            plot(0:20, (lin_Ci-1)*400,colors{:,6},'LineWidth',1.7);
            hold on;
            nonlin_C = var_values_nonlin{iter,1};
            nonlin_Ci = nonlin_C(i,1:21);
            plot(0:20, (nonlin_Ci-1)*400,colors{:,11},'LineWidth',1.7);
             pseudolin_C = var_values_pseudolin{iter,1};
             pseudolin_Ci = pseudolin_C(i,1:21);
             plot(0:20, (pseudolin_Ci-1)*400,colors{:,15},'LineWidth',1.7);
            axis tight;  
            ylabel('Percent');
        end;
        if counter == 4 || counter == 5;
           xlabel('Quarters');
        end;
    elseif counter == 6
        for iter = 9:num_signus;
             lin_C = var_values_lin_levels{iter,1};
            lin_Ci = lin_C(i,1:21);
             plot(0:20, lin_Ci,colors{:,6},'LineWidth',1.7);
             hold on;
             nonlin_C = var_values_nonlin{iter,1};
             nonlin_Ci = nonlin_C(i,1:21);
             plot(0:20, nonlin_Ci,colors{:,11},'LineWidth',1.7);
            pseudolin_C = var_values_pseudolin{iter,1};
            pseudolin_Ci = pseudolin_C(i,1:21);
             plot(0:20, (pseudolin_Ci),colors{:,15},'LineWidth',1.7);
             axis tight;   
         end;
         xlabel('Quarters');
         ylabel('Percent');
    end;
    hold off;
    title(titles{:,i});


    counter = counter+1;
end;
h = suptitle('Figure 2: Baselines in Linearized and Nonlinear Model for an 8-Quarter Liquidity Trap');
%keyboard;
set(h,'FontWeight','bold');
leg1 = legend('Linearized Model', 'Nonlinear Model', 'Nonlinear Model with Linearized Phillips Curve and Resource Constraint');
set(leg1, 'Orientation', 'Horizontal','Position',[0.210474537037036 0.915552806848749 0.600520833333333 0.024896265560166],'FontSize',8);

%orient(figure(1),'landscape');
%set(figure(1), 'PaperUnits', 'inches', 'PaperPosition', [.25 .25 10.5 8]);

orient landscape;
%print('-depsc2', 'Figure2.eps');
print -depsc2 '-r1200' 'Figure2.eps';
fixPSlinestyle('Figure2.eps');
print('-dpdf', 'Figure2.pdf');
