clear all;
close all;
clc;

thetap=0.1; %steady state net markup
eps=(1+thetap)/thetap;
vartheta=1; %steady state value of lagrange multiplier, see manuscript

yi_y_grid=0.815:0.00001:1.225; %grid for relative demand

psi_vec=[0 -3 -12]; %Kimball parameters

markers=['b- '
        'g--'
        'r-.'];
 
for ii=1:1:numel(psi_vec)
    psi=psi_vec(ii);
    phi=eps*(1+psi)/(eps*(1+psi)-1);
    Pi_P_grid_mat(ii,:)=vartheta*( (1+psi)*yi_y_grid-psi).^((1-phi)/(phi));
end

imag_idx=find(imag(Pi_P_grid_mat)>0);
Pi_P_grid_mat(imag_idx)=NaN;

figure1 = figure('Units','centimeters','Position',[0 0 20.5 16.5],'PaperOrientation','landscape','Papertype','usletter');

loglog(yi_y_grid,1+0*yi_y_grid,'k--','LineWidth',1);hold on;
loglog([1 1],[0.98 1.02],'k--','LineWidth',1);hold on;

for jj=1:1:numel(psi_vec)
    loglog(yi_y_grid,Pi_P_grid_mat(jj,:),markers(jj,:),'LineWidth',3);hold on;
end

axis tight
axis([min(yi_y_grid) max(yi_y_grid) 0.98 1.02]);
set(gca,'FontSize',14);
set(gca,'XScale','linear');
set(gca,'YScale','linear');

text(0.858,1.015,['Dixit-Stiglitz (\psi=0)'],'FontSize',14,'Interpreter','Tex');
text(1.1,0.9825,['Kimball (\psi=-3)'],'FontSize',14,'Interpreter','Tex');
text(0.825,1.0055,['Kimball (\psi=-12)'],'FontSize',14,'Interpreter','Tex');

multi_title = sprintf('Figure 1: Demand Curves -- Implications of Kimball vs. Dixit-Stiglitz Aggregators\n\nDemand Curves');
title(multi_title,'LineWidth',22,'FontWeight','bold');

ylabel('Relative Price P_i/P, log-scale','LineWidth',14);
xlabel('Relative Demand y_i/y, log-scale','LineWidth',14);

print('-depsc2', 'Figure1.eps');
fixPSlinestyle('Figure1.eps');
print('-dpdf', 'Figure1.pdf');