**============================================================================**
* Jianhao Lin, Jiacheng Fan, Yifan Zhang, Liangyuan Chen, "Real-time 
*   Macroeconomic Projection Using Narrative Central Bank Communication", 
*   Journal of Applied Econometrics, forthcoming
**----------------------------------------------------------------------------**

* Replicates Tables 4 & 6 in the Paper.

**----------------------------------------------------------------------------**
* Jiacheng Fan, 2022 (fanjch7@mail2.sysu.edu.cn)
**============================================================================**
version 16
capture log close
clear
clear matrix
program drop _all
clear mata
set more off
pause off

* Adjust this path to where you stored the files
global path = "...\lin-fan-zhang-chen-files"

* Set up paths for reading data and storing results
global datpath = "$path\Data\"
global tabpath = "$path\Results\"

cd $path


*===============================================================================
* TABLE 4 Real-time estimation and OOS predictive performance.
*===============================================================================
clear matrix
local tags "GDP IVA FAI CPI M2 PPI"
local savefile $tabpath\Tab_4.xlsx
cap erase `savefile'
foreach tag in `tags' {
	if "`tag'" == "GDP" {
		local sheets "now for1 for2 for3 for4"
	}
	else {
		local sheets "now for1 for3 for6 for12"
	}
	foreach sheet in `sheets' {
		quietly {
			import excel $datpath\Forecast_`tag'_Best_Realtime.xlsx, sheet("rec_`sheet'") firstrow clear
			gen t = tq(2003q1)+_n-1
			tsset t, quarterly
			drop if mf_ew == 0
		}
		// Calculate RMSE, MSE, MAE, MAPE (MSFE-weighted)
		local vars "mf_msfew zp_msfew zz_msfew cb_msfew mfcb_msfew"
		cap mat drop rmse_`sheet' mse_`sheet' mae_`sheet' mape_`sheet'
		foreach var in `vars' {
			gen err = `var' - real
			gen e_sqr = err^2			// squared error
			gen e_abs = abs(err)		// absoluted error
			gen e_pct = abs(err/real)	// pencentage error
			quietly {
				sum e_sqr	
				mat rmse_`sheet' = (nullmat(rmse_`sheet') , sqrt(r(mean)))		// RMSE
				mat mse_`sheet' = (nullmat(mse_`sheet') , r(mean))				// MSE
				sum e_abs
				mat mae_`sheet' = (nullmat(mae_`sheet') , r(mean))				// MAE
				sum e_pct
				mat mape_`sheet' = (nullmat(mape_`sheet') , 100*r(mean))		// MAPE
			}
			drop err e_sqr e_abs e_pct
		}
		// Rename matrix
		local mats "rmse_`sheet' mse_`sheet' mae_`sheet' mape_`sheet'"
		foreach mat in `mats' {
			cap mat drop cp_`mat'
			mat rown `mat' = `mat'
			mat coln `mat' = MF MF+PCI_p MF+PCI_z MF+PCI_2 MF+PCI_12
			mat cp_`mat' = [`mat'[1,2]/`mat'[1,1], `mat'[1,3]/`mat'[1,1], ///
							`mat'[1,4]/`mat'[1,1], `mat'[1,5]/`mat'[1,1]] // Compare PCI to MF
			mat imp_`mat' = [100*(1-`mat'[1,2]/`mat'[1,1]), 100*(1-`mat'[1,3]/`mat'[1,1]), ///
							 100*(1-`mat'[1,4]/`mat'[1,1]), 100*(1-`mat'[1,5]/`mat'[1,1])]	// Imp PCI to MF
			mat coln cp_`mat' = MF+PCI_p MF+PCI_z MF+PCI_`tag' MF+PCI_all
			mat coln imp_`mat' = MF+PCI_p MF+PCI_z MF+PCI_`tag' MF+PCI_all
		}
		// DM-test (MSFE-weighted)
		local vars "rmse mse mae mape"
		cap mat drop dm_rmse_`sheet' dm_mse_`sheet' dm_mae_`sheet' dm_mape_`sheet' ///
					 result_rmse_`sheet' result_mse_`sheet' result_mae_`sheet' result_mape_`sheet'
		foreach var in `vars' {
			if "`var'" == "rmse" {
				qui dmariano real mf_msfew zp_msfew, crit(MAE) kernel(bartlett)		// PCI_p
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
				qui dmariano real mf_msfew zz_msfew, crit(MAE) kernel(bartlett)	    // PCI_z
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
				qui dmariano real mf_msfew cb_msfew, crit(MAE) kernel(bartlett)		// PCI_2
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
				qui dmariano real mf_msfew mfcb_msfew, crit(MAE) kernel(bartlett)	// PCI_12
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
			}
			else {
				qui dmariano real mf_msfew zp_msfew, crit(`var') kernel(bartlett)	// PCI_p
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
				qui dmariano real mf_msfew zz_msfew, crit(`var') kernel(bartlett)	// PCI_z
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
				qui dmariano real mf_msfew cb_msfew, crit(`var') kernel(bartlett)	// PCI_2
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
				qui dmariano real mf_msfew mfcb_msfew, crit(`var') kernel(bartlett)	// PCI_12
				mat dm_`var'_`sheet' = (nullmat(dm_`var'_`sheet') , r(p))
			}
			mat rown dm_`var'_`sheet' = `var'
			mat coln dm_`var'_`sheet' = dm_`tag' dm_all
			mat result_`var'_`sheet' = [`var'_`sheet'[1,1], cp_`var'_`sheet', imp_`var'_`sheet', dm_`var'_`sheet']
		}
	}
	// save to matrix
	local vars "rmse mse mae mape"
	cap mat drop Result_rmse Result_mse Result_mae Result_mape
	foreach var in `vars' {
		if "`tag'" == "GDP" {
			mat Result_`var' = [result_`var'_now \ result_`var'_for1 \ result_`var'_for2 \ result_`var'_for3 \ result_`var'_for4]
			cap mat drop avg
			mata: st_matrix("avg", colsum(st_matrix("Result_`var'"))/5)		// column mean
			mat Result_`var' = (nullmat(Result_`var') \ avg)
			mat coln Result_`var' = MF MF+PCI_p MF+PCI_z MF+PCI_`tag' MF+PCI_all ///
									MF+PCI_p MF+PCI_z  MF+PCI_`tag' MF+PCI_all ///
									dm_zp dm_zz dm_`tag' dm_all
			mat rown Result_`var' = "0" "1" "2" "3" "4" "-"
		}
		else {
			mat Result_`var' = [result_`var'_now \ result_`var'_for1 \ result_`var'_for3 \ result_`var'_for6 \ result_`var'_for12]
			cap mat drop avg
			mata: st_matrix("avg", colsum(st_matrix("Result_`var'"))/5)		// column mean
			mat Result_`var' = (nullmat(Result_`var') \ avg)
			mat coln Result_`var' = MF MF+PCI_p MF+PCI_z MF+PCI_`tag' MF+PCI_all ///
									MF+PCI_p MF+PCI_z  MF+PCI_`tag' MF+PCI_all ///
									dm_zp dm_zz dm_`tag' dm_all
			mat rown Result_`var' = "0" "1" "3" "6" "12" "-"
		}
		
	}
	// save to excel
	quietly {
		putexcel set `savefile', sheet("`tag'") modify
		putexcel A1 = "Type", hcenter
		putexcel B1 = "Horizon", hcenter
		putexcel C1 = "RMSE of Benchmark", hcenter
		putexcel D1:G1 = "Relative RMSE", merge hcenter
		putexcel H1:K1 = "Imp. (%)", merge hcenter
		putexcel L1:O1 = "DM p-value", merge hcenter
		putexcel A2 = "Info.", hcenter
		putexcel A3 = "Nowcast", hcenter
		putexcel A4:A7 = "Forecast", merge hcenter vcenter
		putexcel A8 = "Average", hcenter
		putexcel B2 = mat(Result_rmse), names nformat(0.00)
		putexcel save
	}
	dis "== `tag' is down! =="
}


*===============================================================================
* TABLE 6 Relative RMSE scores of text-augmented forecasts and professional forecasts.
*===============================================================================
clear matrix
local tags "GDP IVA CPI M2 PPI"
local savefile $tabpath\Tab_6.xlsx
cap erase `savefile'
foreach tag in `tags' {
	quietly {
		import excel $datpath\Forecast_Text_PF.xlsx, sheet("`tag'") firstrow clear
		gen t = tq(2003q1)+_n-1
		tsset t, quarterly
	}
	** Calculate RMSE
	local vars "Mean zp_msfew zz_msfew cb_msfew mfcb_msfew"
	cap mat drop rmse_`tag'
	foreach var in `vars' {
		gen err = `var' - Real
		gen e_sqr = err^2			// squared error
		quietly {
			sum e_sqr	
			mat rmse_`tag' = (nullmat(rmse_`tag') , sqrt(r(mean)))		// RMSE
		}
		drop err e_sqr
	}
	** Rename matrix
	local mats "rmse_`tag'"
	foreach mat in `mats' {
		cap mat drop cp_`mat'
		mat cp_`mat' = [`mat'[1,2]/`mat'[1,1] \ `mat'[1,3]/`mat'[1,1] \ `mat'[1,4]/`mat'[1,1] \ `mat'[1,5]/`mat'[1,1]]		
		mat coln cp_`mat' = `tag'
		mat rown cp_`mat' = MF+PCI_z+ MF+PCI_z0 MF+PCI_`tag' MF+PCI_all
	}
	** DM-test
	local var "rmse"
	local bech "Mean"
	cap mat drop dm_`var'_`bech'
	qui dmariano Real `bech' zp_msfew, crit(MAE) kernel(bartlett)		// MF+PCI_z+
	mat dm_`var'_`bech' = (nullmat(dm_`var'_`bech') \ r(p))
	qui dmariano Real `bech' zz_msfew, crit(MAE) kernel(bartlett)	    // MF+PCI_z0
	mat dm_`var'_`bech' = (nullmat(dm_`var'_`bech') \ r(p))
	qui dmariano Real `bech' cb_msfew, crit(MAE) kernel(bartlett)		// MF+PCI_tag
	mat dm_`var'_`bech' = (nullmat(dm_`var'_`bech') \ r(p))
	qui dmariano Real `bech' mfcb_msfew, crit(MAE) kernel(bartlett)		// MF+PCI_all
	mat dm_`var'_`bech' = (nullmat(dm_`var'_`bech') \ r(p))
	mat dm_`var'_`tag' = dm_`var'_`bech'
	mat coln dm_`var'_`tag' = dm_`tag'
	mat Result_`var'_`tag' = [cp_`var'_`tag', dm_`var'_`tag']		
	mat Result_`var' = (nullmat(Result_`var') , Result_`var'_`tag')
	dis "== `tag' is down! =="
}
** Save to excel
quietly {
	putexcel set `savefile', modify
	putexcel A1 = "RMSE", hcenter
	putexcel A2 = mat(Result_rmse), names nformat(0.00)
	putexcel save
}