**** Replication code for computing WEI using DFM estimates *************
// Computes unscaled version of WEI using a DFM
*************************************************************************
// LICENSE FOR CODE:
// Copyright Federal Reserve Bank of New York and Federal Reserve Bank of Dallas.
// You may reproduce, use, modify, make derivative works of, and distribute this code in whole or in part 
// so long as you keep this notice in the documentation associated with any distributed works. 
// Neither the names of the Federal Reserve Bank of New York and Federal Reserve Bank of Dallas nor the names 
// of any of the authors may be used to endorse or promote works derived from this 
// code without prior written permission. Portions of the code attributed to third 
// parties are subject to applicable third party licenses and rights. By your 
// use of this code you accept this license and any applicable third party license.
// THIS CODE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT ANY WARRANTIES OR CONDITIONS 
// OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY WARRANTIES
// OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A 
// PARTICULAR PURPOSE, EXCEPT TO THE EXTENT THAT THESE DISCLAIMERS ARE HELD TO 
// BE LEGALLY INVALID. THE FEDERAL RESERVE BANK OF NEW YORK AND THE FEDERAL 
// RESERVE BANK OF DALLAS ARE NOT, UNDER ANY CIRCUMSTANCES, LIABLE TO YOU FOR
// DAMAGES OF ANY KIND ARISING OUT OF OR IN CONNECTION WITH USE OF OR INABILITY
// TO USE THE CODE, INCLUDING, BUT NOT LIMITED TO DIRECT, INDIRECT, INCIDENTAL,
// CONSEQUENTIAL, PUNITIVE, SPECIAL OR EXEMPLARY DAMAGES, WHETHER BASED ON BREACH
// OF CONTRACT, BREACH OF WARRANTY, TORT OR OTHER LEGAL OR EQUITABLE THEORY, EVEN
// IF THE FEDERAL RESERVE BANK OF NEW YORK OR THE FEDERAL RESERVE BANK OF DALLAS
// HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR LOSS AND REGARDLESS
// OF WHETHER SUCH DAMAGES OR LOSS IS FORESEEABLE.
*************************************************************************

// Read in data
clear 
// Change Path if needed
gl root: pwd // Make sure the current directory is the main folder, so one folder above scripts
gl dataPath "$root\Data"
gl outdataPath "$root\Data\Outdata"

import delimited "$dataPath\Data_WEI_Alt_Spec.csv", varnames(1)

// Changing variable names to label names
global colNames "asasi claims comf date fuel jrrsx licn liun mbampn pelous pstl ras rstotl tdw v12"
foreach v of varlist $colNames{
	local x: variable label `v'
	rename `v' `x'
	
}

// Making transformations d52l
global transformVars "LICN LIUN PSTL ASASI RAS RSTOTL PELOUS FUEL" 
gen timeIndex = _n
tsset timeIndex
// Taking Logs
foreach x of varlist $transformVars{
	
	gen l_`x' = ln(`x')

}
 
global transformVars "l_LICN l_LIUN l_PSTL l_ASASI l_RAS l_RSTOTL l_PELOUS l_FUEL" 

foreach x of varlist $transformVars{
	
 gen d52_`x' = (`x'- (`x'[_n-52])) * 100	
	
}

// Time Setting data
gen Date2 = date(Date, "DMY")
format Date2 %td
drop Date
rename Date2 Date

tsset Date, format(%td)
global tStart = "30dec2007"
global tEnd   = "29feb2020"

// Standardizing data before DFM
global modelVars = "JRRSX d52_l_LICN d52_l_LIUN d52_l_PSTL d52_l_ASASI WITH d52_l_RAS d52_l_RSTOTL d52_l_PELOUS d52_l_FUEL"
foreach x of varlist $modelVars{
	su `x' if tin($tStart, $tEnd)
	gen `x'_sd = (`x' - r(mean)) /r(sd)
	
	
}
egen tIndex1 = min(timeIndex) if tin($tStart, $tEnd)
egen tIndex2 = max(timeIndex) if tin($tStart, $tEnd)

tsset timeIndex

// Estimating DFM
global finalVars_sd "JRRSX_sd d52_l_LICN_sd d52_l_PSTL_sd d52_l_ASASI_sd WITH_sd d52_l_RSTOTL_sd d52_l_LIUN_sd d52_l_RAS_sd d52_l_PELOUS_sd d52_l_FUEL_sd"

dfactor ($finalVars_sd = , noconstant) (f = , ar(1/1)) if (timeIndex >= tIndex1) & (timeIndex <= tIndex2), difficult 
esttab using "$outdataPath\dfm_model_results.csv"

// Predicting using filtering
tsset Date
format Date %td
sort Date
global tNewEnd   = "27dec2020" 
egen tIndex3 = min(timeIndex) if tin($tStart, $tNewEnd)
egen tIndex4 = max(timeIndex) if tin($tStart, $tNewEnd)

keep if tin($tStart, $tNewEnd)

tsset timeIndex
predict dfm_filter, factor smethod(filter)

keep Date dfm_filter
export delimited using "$outdataPath\wei_dfm.csv", replace