insheet using training.out, clear
do label
drop if lnwh==.
drop if age==.

g age2=age^2

gen control1=0
gen control2=0
gen control3=0

cap drop train2
gen train2=0 if train1==0
replace train2=1 if train1==1 & ntrain==1
replace control1=1 if train1==0
replace control2=1 if train1==0 & train4==1
replace control3=1 if train1==0 & train4==1 & reason4==1

foreach v in type provid paycost cert {
	g `v' = `v'1 if train1==1
	replace `v' = `v'4 if train4==1
}
label val type v231
label val provid v233
label val paycost v234
label val cert janee

g t11 = train1

g t12 = train1
replace t12 = . if control2==0 & train1==0

g t13 = train1
replace t13 = . if control3==0 & train1==0

g t21 = train2

g t22 = train2
replace t22 = . if control2==0 & train2==0

g t23 = train2
replace t23 = . if control3==0 & train2==0

// recode education
label drop v61
recode edu 1=1 2=1 3=1 4=2 5=2 6=2 7=3 8=3 9=3
label def edu 1 "Low" 2 "Intermediate" 3 "High"
label val edu edu
tab edu, g(Dedu)

// recode firm size
label drop v111
recode fsize 1=1 2=1 3=2 4=2 5=3 6=3
label def fsize 1 "up to 50" 2 "50 to 200" 3 "more than 200"
label val fsize fsize
tab fsize, g(Dfsize)

// put some small groups together
replace type = 8 if type==9
replace type = 11 if type==2

replace provid = 5 if provid==6
replace provid = 8 if provid==9

// to median
g tenmiss = ten==.
replace ten = 76 if ten==.

keep female age age2 child migrant single temp ten edu Dedu* fsize Dfsize* t?? control? train1 train2 samplew type provid paycost cert lnw
compress
save work2000,replace
