clear
version 9
cap log close
log using annewmethod3, replace
use work2000
svyset [pw=samplew]

// TABLE 2
foreach v of var female age child migrant single temp ten Dedu* Dfsize* {
	di as text %-10s "`v'" _c
	foreach b of var train1 train2 control1 control2 control3 {
		qui svy : mean `v' if `b'==1
		mat b = e(b)
		di as result %9.2f b[1,1] _c
	}
	di
}

// TABLE 3
foreach v of var female age child migrant single temp ten {
	di as result "`v'" _col(20) " " _c
	foreach t of var t11-t23 {
		qui svy : reg `v'  `t'
		mat b = e(b)
		mat se = e(V)
		scalar _pval = 2*ttail(e(df_r)-e(df_m), abs(b[1,1]/sqrt(se[1,1])))
		di %9.3f _pval _c
	}
	di
}

foreach v of var edu fsize {
	di as result "`v'" _col(20) " " _c
	foreach t of var t11-t23 {
		qui svy : tab `v' `t'
		di %9.3f e(p_Pear) _c
	}
	di
}

// TABLE 4
foreach v of var type provid paycost cert {
	svy : tab `v' if train1==1, format(%9.2f)
	svy : tab `v' if control2==1, format(%9.2f)
	svy : tab `v' if control3==1, format(%9.2f)

	di "Variable = `v' "
	qui svy : tab `v' t12
	di "T-I vs. C-II    " %8.1f e(cun_Pear) %8.3f e(p_Pear)
	qui svy : tab `v' t13
	di "T-I vs. C-III    " %8.1f e(cun_Pear) %8.3f e(p_Pear)
}

// TABLE 5
cap program drop myreg
program myreg
syntax [varlist(default=none)]
forv t=1/2 {
	di as result "Participant `t' " _c
	forv c=1/3 {
		qui reg lnw t`t'`c' `varlist' [pw=samplew]
		scalar b    = _b[t`t'`c']
		scalar se   = _se[t`t'`c']
		scalar _pval = 2*ttail(e(df_r)-e(df_m), abs(b/se))
		di %7.3f b  %7.3f se %7.3f _pval _c
	}
	di
}
end

myreg
myreg female age age2 Dedu* Dfsize* ten temp child migrant single

cap program drop myqreg
program myqreg
syntax [varlist(default=none)] [, Quantile(real 0.5)]
forv t=1/2 {
	di as result "Participant `t' " _c
	forv c=1/3 {
		qui qreg lnw t`t'`c' `varlist' [aw=samplew], quantile(`quantile')
		di %7.3f _b[t`t'`c']  %7.3f _se[t`t'`c'] %7.3f 2*ttail(e(df_r)-e(df_m), abs(_b[t`t'`c']/_se[t`t'`c'])) _c
		cap drop wres
	}
	di
}
end

myqreg
myqreg female age age2 Dedu* Dfsize* ten temp child migrant  single

reg lnwh female age age2 Dedu* Dfsize* ten temp child migrant  single t11 control3 [pw=sample]
reg lnwh female age age2 Dedu* Dfsize* ten temp child migrant  single t21 control3 [pw=sample]

log close

