
/*Generate bootstrap results for linear GNR*/ 

clear all
global path "."									/*path on your computer*/
global pathdo "$path\code\code_ols_gmm\linear2"

cd "$pathdo"
set more off
local boot_rep 100 /*100 reps*/

capture log close
set logtype text
log using "boot_base.log", replace
log off

local i=0
while `i' < `boot_rep' {
	local i = `i' + 1
	log on
	di `i'
	log off
	do "testing_boot_linear_2"
		save "boot_results_indiv_`i'", replace
		clear
}

log close

 /*  Compile bootstrap results  */

 local boot_rep 100 /*100 reps*/
 
 forvalues i=1(1)`boot_rep'  {
    use "boot_results_indiv_`i'"
	gen iter = `i'
	if `i' == 1  {
	   save "boot_results", replace
	   }
	else  {
	   append using "boot_results"
	   save "boot_results", replace
	   }
	erase "boot_results_indiv_`i'.dta"
	}
	
/*  Compute standard errors  */

use "boot_results"
drop iter
foreach var of varlist *  {
   egen sd_`var' =sd(`var')
   drop `var'
   rename sd_`var' `var'
   }
collapse *, fast
save "boot_results_se", replace

do "testing_boot_linear_point_est_2"
clear
use "point_est"
append using "boot_results_se"
append using "boot_results_se"
foreach var of varlist   *   {
   replace `var' = `var'[1] / `var'[2] if _n == 3
   }
save "boot_results_all", replace	
	