
/* This code is designed to estimate the extended model (model 2) in LLP(2022). 
The model includes 3 inputs (captial, labor, material) and 2 state variables (u,v).
*/

drop v
rename v4 u
rename v5 v

* First-stage approximation includes 26 terms:
* k l m u v kk ll mm kl km ku kv lm lu lv mu mv klm klu klv kmu kmv  lmu lmv klmu klmv
	
	gen kk=k*k
	gen ll=l*l
	gen mm=m*m 
	
	local linear k l m u v
	local square kk ll mm
	local int_2					// second-order
	local int_3					// third-order (interactions only)
	local int_4					// fourth-order (interactions only)
	local nvar : word count `linear'
	forval i = 1/`nvar' {
		local t = `i'+1
		local x : word `i' of `linear'
			forval j = `t'/`nvar' {
				local r = `j'+1
				local y : word `j' of `linear'
				cap gen `x'`y' = `x'*`y'
				local int_2 `int_2' `x'`y'
					forval s = `r'/`nvar' {
						local w = `s'+1
						local z: word `s' of `linear'
						cap gen `x'`y'`z' = `x'*`y'*`z'
						local int_3 `int_3' `x'`y'`z'
							forval a = `w'/`nvar' {
								local b: word `a' of `linear'
								cap gen `x'`y'`z'`b' = `x'*`y'*`z'*`b'
								local int_4 `int_4' `x'`y'`z'`b'
					}
				}
		}
	}
	cap gen klmuv = k*l*m*u*v
	local poly `linear' `square' `int_2' `int_3' `int_4' klmuv
	local nterm : word count `poly'
	di "`poly'"
	di `nterm'
	
	local trial1 k l m u v kk ll mm kl km ku kv lm lu lv mu mv klm klu klv kmu kmv lmu lmv klmu klmv // uv kuv luv muv
	local nterm: word count `trial1'
	di `nterm'
	local nlreg
	foreach i in `trial1' {
		local nlreg `nlreg' {g`i'=_b[`i']}*`i' +
	}
	macro list _nlreg
	
*** First-stage GNR ***

* Obtain initial values from OLS regression log inputshare
	regress sm `trial1'
	matrix test = e(b)
	predict temp_c
	replace temp_c = temp_c - _b[_cons]

* Correct constant term for initial values
	egen mtemp_c = min(temp_c)
	scalar ntemp_c=mtemp_c
	drop temp_c mtemp_c
	scalar ntemp_c=-ntemp_c + 0.1
	
* NLS using initial values from OLS
	#delimit;
	nl ( sm = ln({g0=ntemp_c} +  {gk=_b[k]}*k + {gl=_b[l]}*l + {gm=_b[m]}*m + {gu=_b[u]}*u + {gv=_b[v]}*v + {gkk=_b[kk]}*kk +
					{gll=_b[ll]}*ll + {gmm=_b[mm]}*mm + {gkl=_b[kl]}*kl + {gkm=_b[km]}*km + {gku=_b[ku]}*ku +
					{gkv=_b[kv]}*kv + {glm=_b[lm]}*lm + {glu=_b[lu]}*lu + {glv=_b[lv]}*lv + {gmu=_b[mu]}*mu +
					{gmv=_b[mv]}*mv + {gklm=_b[klm]}*klm + {gklu=_b[klu]}*klu + {gklv=_b[klv]}*klv + {gkmu=_b[kmu]}*kmu +
					{gkmv=_b[kmv]}*kmv + {glmu=_b[lmu]}*lmu + {glmv=_b[lmv]}*lmv + 
					{gklmu=_b[klmu]}*klmu + {gklmv=_b[klmv]}*klmv) ), iter(100);
	#delimit cr
	
	gen test = e(converge)
	if test ~= 1 exit
	
* Predicted elasticities w.r.t material m
	predict ielas

* Adjust predicted elasticities for measurment errors/random shocks
	predict eg, resid
	replace eg=-eg
	egen mexp_eg=mean(exp(eg))
	su mexp_eg						// should be close to 1
	replace ielas=ielas-ln(mexp_eg)
	replace ielas=exp(ielas)

* Rename and save mean adjusted coefficients of estimation
* k l m u v kk ll mm kl km ku kv lm lu lv mu mv klm klu klv kmu kmv  lmu lmv klmu klmv
	mat beta=e(b)
	svmat double beta
	ren beta1 g0
	ren beta2 gk
	ren beta3 gl
	ren beta4 gm
	ren beta5 gu
	ren beta6 gv
	ren beta7 gkk
	ren beta8 gll
	ren beta9 gmm
	ren beta10 gkl
	ren beta11 gkm
	ren beta12 gku
	ren beta13 gkv
	ren beta14 glm
	ren beta15 glu
	ren beta16 glv
	ren beta17 gmu
	ren beta18 gmv
	ren beta19 gklm
	ren beta20 gklu
	ren beta21 gklv
	ren beta22 gkmu
	ren beta23 gkmv
	ren beta24 glmu
	ren beta25 glmv
	ren beta26 gklmu
	ren beta27 gklmv

* Adjust for measurement errors
	foreach var of varlist g0-gklmv {
		egen s`var'=mean(`var')
		drop `var'
		ren s`var' `var'
		replace `var' = `var' / mexp_eg
	}
	
* Compute integrals
	gen integ_G_I = g0 + gk*k + gl*l + gu*u+ gv*v + gkk*kk + gll*ll + gkl*kl + gku*ku + gkv*kv + glu*lu + glv*lv + ///
						gklu*klu + gklv*klv + (gm*m + gkm*km + glm*lm + gmu*mu + gmv*mv + gklm*klm + gkmu*kmu + gkmv*kmv + glmu*lmu + glmv*lmv + gklmu*klmu + gklmv*klmv)/2 + ///
						gmm*mm/3
	replace integ_G_I=integ_G_I*m

* Construct script_Y
	gen vg = yg - eg - integ_G_I

* Generate lagged variables
* Approximate C(k,l,u,v) by 13 terms
* k l u v kk ll kl ku kv lu lv klu klv // uv kuv luv kluv
	tset id year
	
	gen vg_1=L.vg
	gen l_1=L.l
	gen k_1=L.k
	gen u_1=L.u
	gen v_1=L.v
	gen kk_1=L.kk
	gen ll_1=L.ll
	gen kl_1=L.kl
	gen ku_1=L.ku
	gen kv_1=L.kv
	gen lu_1=L.lu
	gen lv_1=L.lv
	gen klu_1=L.klu
	gen klv_1=L.klv
	
	gen k_l_1=k*l_1
	gen l_1v = l_1*v
	gen kl_1v = k*l_1*v
	
* Define GMM evaluator for the second stage - is this efficient code?
	cap program drop gmm_GNR2
	program gmm_GNR2
		version 14
		syntax varlist if, at(name) mylhs(varlist)
		quietly{
				tempvar C h omega
				matrix C_theta = `at'[1..1,1..13]
				matrix coln C_theta = k l u v kk ll kl ku kv lu lv klu klv
				matrix score double `C' = C_theta `if'		
				matrix h_delta = `at'[1..1,14..17]
				gen `omega'=`mylhs'+`C'
				replace `varlist' = `mylhs' + `C' - h_delta[1,1] ///
								- h_delta[1,2]*L.`omega' - h_delta[1,3]*d_HKMT - h_delta[1,4]*d_OECD `if'
		}
	end

* Set initial values using OLS estimation of script_Y on capital, labor, their squares and interaction term
	reg vg k l u v kk ll kl ku kv lu lv klu klv vg_1 d_HKMT d_OECD
	matrix test2 = e(b)
	matrix test3 = J(1,17,0)
	matrix test3[1,1] = test2[1,"k"]
	matrix test3[1,2] = test2[1,"l"]
	matrix test3[1,3] = test2[1,"u"]
	matrix test3[1,4] = test2[1,"v"]
	matrix test3[1,5] = test2[1,"kk"]
	matrix test3[1,6] = test2[1,"ll"]
	matrix test3[1,7] = test2[1,"kl"]
	matrix test3[1,8] = test2[1,"ku"]
	matrix test3[1,9] = test2[1,"kv"]
	matrix test3[1,10] = test2[1,"lu"]
	matrix test3[1,11] = test2[1,"lv"]
	matrix test3[1,12] = test2[1,"klu"]
	matrix test3[1,13] = test2[1,"klv"]
	matrix test3[1,14] = test2[1,"_cons"]
	matrix test3[1,15] = test2[1,"vg_1"]
	matrix test3[1,16] = test2[1,"d_HKMT"]
	matrix test3[1,17] = test2[1,"d_OECD"]
	
	matrix list test3
	matrix drop test2
	
	*xtset id year
	local dv vg
	gmm gmm_GNR2 $if, nequations(1) ///
	parameters(k l u v kk ll kl ku kv lu lv klu klv _cons rho gamma1 gamma2) ///
	instruments(k l u v kk ll kl ku kv lu lv klu klv vg_1 d_HKMT d_OECD k_1 l_1 u_1 v_1 kk_1 ll_1 kl_1 ku_1 kv_1 lu_1 lv_1 klu_1 klv_1) mylhs(`dv') nolog from(test3) //
 	replace test = e(converged)
	if test ~= 1 exit
	
	matrix coef=e(b)
	svmat double coef
	
	local cvar k l u v kk ll kl ku kv lu lv klu klv
	local ncvar: word count `cvar'
	
	forval i=1/`ncvar' {
		local this_coef `:word `i' of `cvar''
		rename coef`i' c`this_coef'
	}
	
	foreach var of varlist ck-cklv {
		egen s`var' = mean(`var')
		drop `var'
		ren s`var' `var'
	}
	
	matrix list coef
	matrix list C_theta
	matrix list h_delta
	scalar rho = h_delta[1,2]
	scalar gamma1 = h_delta[1,3]
	scalar gamma2 = h_delta[1,4]
	
	cap drop C 
	cap drop omega 
	cap drop f_hat
	cap drop y_hat
		
	matrix score double C = C_theta
	gen omega = vg + C
	kdensity omega
	gen f_hat = yg - eg - omega
	gen y_hat = yg - eg
	
* Generate output elasticities w.r.t labor and capital
* Partial f: k l m u v kk ll mm kl km ku kv lm lu lv mu mv klm klu klv kmu kmv lmu lmv klmu klmv
* C(.): k l u v kk ll kl ku kv lu lv klu klv

	gen kelas = gk*m + 2*gkk*km + gkl*lm + gku*mu + gkv*mv + gklu*lmu + gklv*lmv + gkm*mm/2 + gklm*lm*m/2 + gkmu*mu*m/2 + gkmv*mv*m/2 + gklmu*lmu*m/2 + gklmv*lmv*m/2 ///
					- (C_theta[1,1] + 2*C_theta[1,5]*k + C_theta[1,7]*l + C_theta[1,8]*u + C_theta[1,9]*v + C_theta[1,12]*lu + C_theta[1,13]*lv)
					
	gen lelas = gl*m + 2*gll*lm + gkl*km + glu*mu + glv*mv + gklu*kmu + gklv*kmv + glm*mm/2 + gklm*km*m/2 + glmu*mu*m/2 + glmv*mv*m/2 + gklmu*kmu*m/2 + gklmv*kmv*m/2 ///
					- (C_theta[1,2] + 2*C_theta[1,6]*l + C_theta[1,7]*k + C_theta[1,10]*u + C_theta[1,11]*v + C_theta[1,12]*ku + C_theta[1,13]*kv)
					
	gen melas = ielas
	
	gen uelas = (gu + gku*k + glu*l + gklu*kl + (gmu*m + gkmu*km + glmu*lm + gklmu*klm)/2)*m ///
					- (C_theta[1,3] + C_theta[1,8]*k + C_theta[1,10]*l + C_theta[1,12]*kl)
					
	gen velas = (gv + gkv*k + glv*l + gklv*kl + (gmv*m + gkmv*km + glmv*lm + gklmv*klm)/2)*m ///
					- (C_theta[1,4] + C_theta[1,9]*k + C_theta[1,11]*l + C_theta[1,13]*kl)

* Generate elasticity w.r.t v (long-run effect) and v+d (short-run effect)
	* Generate long-run effect and short-run effect for u
	gen lteffect_u= uelas
	gen steffect_u = lteffect_u + gamma1
	
	* Generate long-run effect and short-run effect for v
	gen lteffect_v = velas
	gen steffect_v = lteffect_v + gamma2
	
* Other parameters
	gen rho = rho
	gen gamma1 = gamma1
	gen gamma2 = gamma2
	
	
	
	
	
	
	
	
	
	
	
	