
clear all
set more off

global path "."									/*path on your computer*/
use "$path\_datasets\TFP_china_tech"			/*path to the cleaned panel dataset 1998-2007*/

rename NewID id

  program tsset_boot
	sort id year
    bys id: gen first = year[_n]==year[_n-1]
    bys id year: gen second = sum(first)
	gen double id2 = 0.01*second + id
    format id2 %8.2f
    rename id idold
    rename id2 id
	drop first second idold
  end program

	bsample, cluster(id)
	tsset_boot
	
*keep id year RGO L K RI si export import hiwag adv
*foreach v of varlist * {
*	replace `v'=. if `v'<-999
*}
*replace si=exp(si)
*ren year time
*ren RGO yg_level
*ren L l_level
*ren K k_level
*ren RI i_level
*ren si si_level

do "llp_code_1"
if test ~= 1 exit

* Generate more statistics needed
gen prod=exp(omega)

	* elasticties
	egen mlelas=mean(lelas)
	egen mkelas=mean(kelas)
	egen mmelas=mean(melas)

	* return to scale
	gen sumelas=lelas+kelas+melas
	egen msumelas=mean(sumelas)
	label var msumelas "return to scale"

	* capital labor ratio
	gen mKelasmLelas=mkelas/mlelas
	label var mKelasmLelas "capital labor ratio"
	drop lelas kelas melas sumelas 

	* long- and short-term effect
	egen m_lteffect = mean(lteffect)
	label var m_lteffect "long-term effect"
	egen m_steffect = mean(steffect)
	label var m_steffect "short-term effect"
	drop lteffect steffect

	* gamma and rho
	egen m_gamma = mean(gamma)
	egen m_rho = mean(rho)
	
sum mmelas mlelas mkelas msumelas mKelasmLelas m_lteffect m_steffect m_gamma m_rho

keep test mlelas mkelas mmelas msumelas mKelas m_lteffect m_steffect m_gamma m_rho
keep if _n == 1

