
******************************************
************ Checking Data ***************
******************************************

global path "."					/*path on your computer*/
cd "$path"

grstyle clear
set scheme s2mono
grstyle init
grstyle set plain, horizontal noextend grid

*-------------------------------------
use ".\_datasets\TFP_china.dta", clear /*path to the cleaned panel dataset 1998-2007*/
xtset NewID year


* Checking distribution of turnover (Y)
su Y
kdensity Y

count if Y==0

twoway kdensity Y if year==1998 & Y<=200000 || ///
		kdensity Y if year==2001 & Y<=200000 || ///
		kdensity Y if year==2006 & Y<=200000, legend(order(1 2 3) ///
		label(1 1998) label(2 2001)  label(3 2006))		
graph export ".\graph\Y_dis.png", replace
	
* Checking distribution of material (M)
su M
kdensity M

twoway kdensity M if year==1998 & M <=200000|| ///
		kdensity M if year==2001 & M <=200000 || ///
		kdensity M if year==2006 & M <=200000 , legend(order(1 2 3) ///
		label(1 1998) label(2 2001)  label(3 2006))
graph export ".\graph\M_dis.png", replace

* Checking distribution of employment (L)
su L if year==1998
kdensity L if year==1998

twoway kdensity L if year==1998 & L<=1000 || ///
		kdensity L if year==2001 & L<=1000 || ///
		kdensity L if year==2006 & L<=1000 , legend(order(1 2 3) ///
		label(1 1998) label(2 2001)  label(3 2006))
graph export ".\graph\L_dis.png", replace

* Checking distribution of real capital (rK)
su rK
kdensity rK

twoway kdensity rK if year==1998 & rK <=50000|| ///
		kdensity rK if year==2001 & rK <=50000|| ///
		kdensity rK if year==2006 & rK <=50000, legend(order(1 2 3) ///
		label(1 1998) label(2 2001)  label(3 2006))
graph export ".\graph\rK_dis.png", replace
	
* Checking distribution of InputShare
su InputShare

twoway kdensity InputShare if year==1998 || ///
		kdensity InputShare if year==2001 || ///
		kdensity InputShare if year==2006, legend(order(1 2 3) ///
		label(1 1998) label(2 2001)  label(3 2006))
graph export ".\graph\InputShare_dis.png", replace

* Checking distribution of OECDShare

local a "OECDShare>0 & OECDShare<1"
count if OECDShare>1 & OECDShare<.
su OECDShare
kdensity OECDShare if `a'

twoway kdensity OECDShare if year==1998 & `a' || ///
		kdensity OECDShare if year==2001 & `a'|| ///
		kdensity OECDShare if year==2006 & `a', legend(order(1 2 3) ///
		label(1 1998) label(2 2001)  label(3 2006))
graph export ".\graph\OECDShare_dis.png", replace

* Checking distribution of HKMTShare

local a "HKMTShare>0 & HKMTShare<1"
count if HKMTShare>1 & HKMTShare<.
su HKMTShare
kdensity HKMTShare if `a'

twoway kdensity HKMTShare if year==1998 & `a' || ///
		kdensity HKMTShare if year==2001 & `a'|| ///
		kdensity HKMTShare if year==2006 & `a', legend(order(1 2 3) ///
		label(1 1998) label(2 2001)  label(3 2006))
graph export ".\graph\HKMTShare_dis.png", replace

save ".\_datasets\TFP_china.dta", replace
