********************************************************************************

**********************This is PLL project****************************

global path "."					/*path on your computer*/
global pathdo "$path\code"		/*path to code folder*/

cd "$path"

*--------------------------------------
* Main results

*** Prepare the main dataset for analysis (full panel, all industries)
do "$pathdo\1_preparingdata.do"

*** Check some distributions in the data
do "$pathdo\2_checkingdata.do"

*** Producing graphs for foreign ownership China
do "$pathdo\3_graphs.do"

*** Final data preparation
do "$pathdo\4_preparingdata_final.do"

*** Estimate baseline model (point estimate)
do "$pathdo\5_model1.do"

*** Estimate extended model (point estimate)
do "$pathdo\6_model2.do"

*** Non-Hicks-neutral test & decomposition
do "$pathdo\7_testing_decomposition.do"

*--------------------------------------
* Bootstrap standard errors

*** Bootstrap model 1
timer clear 1
timer on 1
do "$pathdo\code_boot_model_1\call_boot_llp_1.do"
timer off 1
timer list 1
global Model1 = r(t1)/3600
di $Model1

*** Bootstrap model 2
timer clear 1
timer on 1
global pathdo "$path\code"
do "$pathdo\code_boot_model_2\call_boot_llp_2.do"
timer off 1
timer list 1
global Model2 = r(t1)/3600
di $Model2



