/* basic information cleaninging up */
/* ct_cons : drop purchasing cost for durable goods - cons10*/
/* ct_cons_d : include purchasing cost for non-durable goods */
/* at_cons : directly asked */

/*1999------------------------------------------------------------------------*/
cd C:\PTM_code\Preparation
set more off

/* current consumption (1), bring current consumption from the following year survey since Questionnaire asked 'previous year consumption' */
use income_cons2000.dta, clear

replace ct_cons=l_ct_cons
replace ct_cons_d=l_ct_cons_d
replace at_cons=l_at_cons
keep hhid ct_cons ct_cons_d at_cons
sort hhid

save current_consumption1999.dta, replace

/*main, adding area and HH size information, indicating nonresponse, calculating consumption for durable and non-durable*/
use  consumption1999_1998.dta, clear
drop if sample98==0

/*HH size*/
sort hhid
joinby hhid using cleaned99_lhsize_merge.dta, unmatched(master)
drop _merge

/* lagged consumption cleanup */

replace l_cons11=0
replace l_cons12=0
replace l_cons13=0
replace l_cons14=0
replace l_cons15=0
replace l_cons16=0

replace l_cons0=. if l_cons0==999999
replace l_cons1=. if l_cons1==999999
replace l_cons2=. if l_cons2==999999
replace l_cons3=. if l_cons3==999999
replace l_cons4=. if l_cons4==999999
replace l_cons5=. if l_cons5==999999
replace l_cons6=. if l_cons6==999999
replace l_cons7=. if l_cons7==999999
replace l_cons8=. if l_cons8==999999
replace l_cons9=. if l_cons9==999999
replace l_cons10=. if l_cons10==999999
replace l_cons11=. if l_cons11==999999
replace l_cons12=. if l_cons12==999999
replace l_cons13=. if l_cons13==999999
replace l_cons14=. if l_cons14==999999
replace l_cons15=. if l_cons15==999999
replace l_cons16=. if l_cons16==999999
replace l_cons17=. if l_cons17==999999

replace l_cons1=(12*(l_cons1)*(100/97.002))/l_hsize
replace l_cons2=(12*(l_cons2)*(100/97.002))/l_hsize
replace l_cons3=(12*(l_cons3)*(100/97.002))/l_hsize
replace l_cons4=(12*(l_cons4)*(100/97.002))/l_hsize
replace l_cons5=(12*(l_cons5)*(100/97.002))/l_hsize
replace l_cons6=(12*(l_cons6)*(100/97.002))/l_hsize
replace l_cons7=(12*(l_cons7)*(100/97.002))/l_hsize
replace l_cons8=(12*(l_cons8)*(100/97.002))/l_hsize
replace l_cons9=(12*(l_cons9)*(100/97.002))/l_hsize
replace l_cons10=(12*(l_cons10)*(100/97.002))/l_hsize
replace l_cons11=(12*(l_cons11)*(100/97.002))/l_hsize
replace l_cons12=(12*(l_cons12)*(100/97.002))/l_hsize
replace l_cons13=(12*(l_cons13)*(100/97.002))/l_hsize
replace l_cons14=(12*(l_cons14)*(100/97.002))/l_hsize
replace l_cons15=(12*(l_cons15)*(100/97.002))/l_hsize
replace l_cons16=(12*(l_cons16)*(100/97.002))/l_hsize
replace l_cons17=(12*(l_cons17)*(100/97.002))/l_hsize

/* non-durable consumption */
generate l_ct_cons=l_cons1+ l_cons2+ l_cons3+ l_cons4+ l_cons5+ l_cons6+ l_cons7+ l_cons8+ l_cons9+ l_cons11+ l_cons12+ l_cons13+ l_cons14+ l_cons15+ l_cons16+ l_cons17
replace l_ct_cons=. if l_cons1==. | l_cons2==. | l_cons3==. | l_cons4==. | l_cons5==. | l_cons6==. | l_cons7==. | l_cons8==. | l_cons9==.  | l_cons11==. | l_cons12==. | l_cons13==. | l_cons14==. | l_cons15==. | l_cons16==. | l_cons17==. 
replace l_ct_cons=. if l_ct_cons==.


/* including durable */
generate l_ct_cons_d=l_cons1+ l_cons2+ l_cons3+ l_cons4+ l_cons5+ l_cons6+ l_cons7+ l_cons8+ l_cons9+l_cons10+ l_cons11+ l_cons12+ l_cons13+ l_cons14+ l_cons15+ l_cons16+ l_cons17
replace l_ct_cons_d=. if l_cons1==. | l_cons2==. | l_cons3==. | l_cons4==. | l_cons5==. | l_cons6==. | l_cons7==. | l_cons8==. | l_cons9==.  | l_cons10==. | l_cons11==. | l_cons12==. | l_cons13==. | l_cons14==. | l_cons15==. | l_cons16==. | l_cons17==. 
replace l_ct_cons_d=. if l_ct_cons_d==.

/* asked(already aggregated) consumption */
generate l_at_cons=(12*l_cons0*(100/97.002))/l_hsize
drop l_cons0

sort hhid

/*current consumption (2), add current consumption on lagged consumption file*/
joinby hhid using current_consumption1999.dta, unmatched(master)
drop _merge
 
keep hhid l_ct_cons l_ct_cons_d l_at_cons ct_cons ct_cons_d at_cons

sort hhid
save cleanedup_total_cons1999.dta, replace

/* Add consumption info to demo file*/ 
use cleanup99_total.dta, clear

sort hhid
joinby hhid using cleanedup_total_cons1999.dta, unmatched(master)
drop _merge

sort hhid
save Income_cons1999.dta, replace
