clear 
clc

format short g

load Data_1999_2007.mat;

% data
% [(1)year (2)hhid (3)ln_at_cons (4)ln_l_at_cons (5)hsize 
% (6)d02 (7)d03 (8)d04 (9)d05 (10)d06 (11)d07
% (12)l2_is_head (13)l3_is_head (14)l_is_head
% (15)m65 (16)f55 (17)hsex (18)hedu (19)seoul (20)nonspouse (21)hage ]

data=[yearV hhid ln_at_cons ln_l_at_cons hsize d02 d03 d04 d05 d06 d07 l2_is_head l3_is_head l_is_head m65 f55 hsex hedu seoul nonspouse hage]; 
data(isinf(data)) = NaN(1);
data=sortrows(data, 2);
DATA=sortrows(data, 1);

% DATA generating year by year
DATA1999 = DATA(1:5000,:);
DATA2000 = DATA(5001:10000,:);
DATA2001 = DATA(10001:15000,:);
DATA2002 = DATA(15001:20000,:);
DATA2003 = DATA(20001:25000,:);
DATA2004 = DATA(25001:30000,:);
DATA2005 = DATA(30001:35000,:);
DATA2006 = DATA(35001:40000,:);
DATA2007 = DATA(40001:45000,:);

% DATA generating X, Y, LAG OF Y
DATA1999_Y=DATA1999(:,3);
DATA2000_Y=DATA2000(:,3);
DATA2001_Y=DATA2001(:,3);
DATA2002_Y=DATA2002(:,3);
DATA2003_Y=DATA2003(:,3);
DATA2004_Y=DATA2004(:,3);
DATA2005_Y=DATA2005(:,3);
DATA2006_Y=DATA2006(:,3);
DATA2007_Y=DATA2007(:,3);

DATA1999_LAGY=DATA1999(:,4);
DATA2000_LAGY=DATA2000(:,4);
DATA2001_LAGY=DATA2001(:,4);
DATA2002_LAGY=DATA2002(:,4);
DATA2003_LAGY=DATA2003(:,4);
DATA2004_LAGY=DATA2004(:,4);
DATA2005_LAGY=DATA2005(:,4);
DATA2006_LAGY=DATA2006(:,4);
DATA2007_LAGY=DATA2007(:,4);

% X: (1)hsize (2)d02 (3)d03 (4)d04 (5)d05 (6)d06 (7)d07
DATA1999_X=DATA1999(:,5:11);
DATA2000_X=DATA2000(:,5:11);
DATA2001_X=DATA2001(:,5:11);
DATA2002_X=DATA2002(:,5:11);
DATA2003_X=DATA2003(:,5:11);
DATA2004_X=DATA2004(:,5:11);
DATA2005_X=DATA2005(:,5:11);
DATA2006_X=DATA2006(:,5:11);
DATA2007_X=DATA2007(:,5:11);

Kex=size(DATA2007_X,2);
% [(1)year (2)hhid (3)ln_at_cons (4)ln_l_at_cons (5)hsize 
% (6)d02 (7)d03 (8)d04 (9)d05 (10)d06 (11)d07
% (12)l2_is_head (13)l3_is_head (14)l_is_head
% (15)m65 (16)f55 (17)hsex (18)hedu (19)seoul (20)nonspouse (21)hage ]

% EX: (1) m65 (2)f55 (3)hsex (4)hedu (5)seoul (6)nonspouse (7)hage (8)sq_hage
DATA1999_EX=[DATA1999(:,15:21) DATA1999(:,21).^2];
DATA2000_EX=[DATA2000(:,15:21) DATA2000(:,21).^2];
DATA2001_EX=[DATA2001(:,15:21) DATA2001(:,21).^2];
DATA2002_EX=[DATA2002(:,15:21) DATA2002(:,21).^2];
DATA2003_EX=[DATA2003(:,15:21) DATA2003(:,21).^2];
DATA2004_EX=[DATA2004(:,15:21) DATA2004(:,21).^2];
DATA2005_EX=[DATA2005(:,15:21) DATA2005(:,21).^2];
DATA2006_EX=[DATA2006(:,15:21) DATA2006(:,21).^2];
DATA2007_EX=[DATA2007(:,15:21) DATA2007(:,21).^2];

% EXIV: (1)l2_is_head (2)l3_is_head 
DATA1999_EXIV=[DATA1999(:,12) DATA1999(:,13)];
DATA2000_EXIV=[DATA2000(:,12) DATA2000(:,13)];
DATA2001_EXIV=[DATA2001(:,12) DATA2001(:,13)];
DATA2002_EXIV=[DATA2002(:,12) DATA2002(:,13)];
DATA2003_EXIV=[DATA2003(:,12) DATA2003(:,13)];
DATA2004_EXIV=[DATA2004(:,12) DATA2004(:,13)];
DATA2005_EXIV=[DATA2005(:,12) DATA2005(:,13)];
DATA2006_EXIV=[DATA2006(:,12) DATA2006(:,13)];
DATA2007_EXIV=[DATA2007(:,12) DATA2007(:,13)];

% sfddm - zero:analyzed
% Preparation steps are required to have the file DataH_sfddm
load DataH_sfddm
% CHECK THE MISSING SAMPLE SIZE!
MHHID=ones(5000,1);
k1=1;
for j1=1:5000
    if missing_sfddm(k1)==j1;
    MHHID(j1,1)=0;
    k1=k1+1;
    else 
        k1=k1;
    end
end


% YX: (1)Y (2)LAG Y (3)hsize 
% (4)d02 (5)d03 (6)d04 (7)d05 (8)d04 (9)d05 (10)MHHID
% (11)l2_is_head (12)l3_is_head (13)l_is_head 
DATA1999_YX=[DATA1999_Y DATA1999_LAGY DATA1999_X MHHID DATA1999_EXIV DATA1999(:,14)];
DATA2000_YX=[DATA2000_Y DATA2000_LAGY DATA2000_X MHHID DATA2000_EXIV DATA2000(:,14)];
DATA2001_YX=[DATA2001_Y DATA2001_LAGY DATA2001_X MHHID DATA2001_EXIV DATA2001(:,14)];
DATA2002_YX=[DATA2002_Y DATA2002_LAGY DATA2002_X MHHID DATA2002_EXIV DATA2002(:,14)];
DATA2003_YX=[DATA2003_Y DATA2003_LAGY DATA2003_X MHHID DATA2003_EXIV DATA2003(:,14)];
DATA2004_YX=[DATA2004_Y DATA2004_LAGY DATA2004_X MHHID DATA2004_EXIV DATA2004(:,14)];
DATA2005_YX=[DATA2005_Y DATA2005_LAGY DATA2005_X MHHID DATA2005_EXIV DATA2005(:,14)];
DATA2006_YX=[DATA2006_Y DATA2006_LAGY DATA2006_X MHHID DATA2006_EXIV DATA2006(:,14)];
DATA2007_YX=[DATA2007_Y DATA2007_LAGY DATA2007_X MHHID DATA2007_EXIV DATA2007(:,14)];

DATA1999_YX(any(DATA1999_YX(:,10)==1,2), :)=[];
DATA2000_YX(any(DATA2000_YX(:,10)==1,2), :)=[];
DATA2001_YX(any(DATA2001_YX(:,10)==1,2), :)=[];
DATA2002_YX(any(DATA2002_YX(:,10)==1,2), :)=[];
DATA2003_YX(any(DATA2003_YX(:,10)==1,2), :)=[];
DATA2004_YX(any(DATA2004_YX(:,10)==1,2), :)=[];
DATA2005_YX(any(DATA2005_YX(:,10)==1,2), :)=[];
DATA2006_YX(any(DATA2006_YX(:,10)==1,2), :)=[];
DATA2007_YX(any(DATA2007_YX(:,10)==1,2), :)=[];

DATA1999_YX(:,10)=[];
DATA2000_YX(:,10)=[];
DATA2001_YX(:,10)=[];
DATA2002_YX(:,10)=[];
DATA2003_YX(:,10)=[];
DATA2004_YX(:,10)=[];
DATA2005_YX(:,10)=[];
DATA2006_YX(:,10)=[];
DATA2007_YX(:,10)=[];

YX(:,:,1)=DATA1999_YX;
YX(:,:,2)=DATA2000_YX;
YX(:,:,3)=DATA2001_YX;
YX(:,:,4)=DATA2002_YX;
YX(:,:,5)=DATA2003_YX;
YX(:,:,6)=DATA2004_YX;
YX(:,:,7)=DATA2005_YX;
YX(:,:,8)=DATA2006_YX;
YX(:,:,9)=DATA2007_YX;

A1=[size(YX,1) size(YX,2) size(YX,3)];
ng=A1(1,1); % number of groups
T=A1(1,3); % total years (including IVs)

% clearvars -except YX A EXIV MHHID

% W{i}: (1)Y (2)LAG Y (3)hsize 
% (4)d02 (5)d03 (6)d04 (7)d05 (8)d06 (9)d07 
% (10)l2_is_head (11)l3_is_head  
% (12)l_is_head 

for i=1:ng
   W{i}(:,:)=squeeze(YX(i,:,:))';
end

% For Summary Statistics 
% SS: (1)year (2)hhid (3)ln_at_cons (4)hsize (5)m65 (6)f55 (7)hsex (8)hedu 
%     (9)seoul (10)nonspouse (11)hage (12)MHHID
DATA_S1999=[DATA(1:5000,1:3) DATA(1:5000,5) DATA(1:5000,15:21)                 MHHID];
DATA_S2000=[DATA(5001:10000,1:3) DATA(5001:10000,5) DATA(5001:10000,15:21)     MHHID];
DATA_S2001=[DATA(10001:15000,1:3) DATA(10001:15000,5) DATA(10001:15000,15:21)  MHHID];
DATA_S2002=[DATA(15001:20000,1:3) DATA(15001:20000,5) DATA(15001:20000,15:21)  MHHID];
DATA_S2003=[DATA(20001:25000,1:3) DATA(20001:25000,5) DATA(20001:25000,15:21)  MHHID];
DATA_S2004=[DATA(25001:30000,1:3) DATA(25001:30000,5) DATA(25001:30000,15:21)  MHHID];
DATA_S2005=[DATA(30001:35000,1:3) DATA(30001:35000,5) DATA(30001:35000,15:21)  MHHID];
DATA_S2006=[DATA(35001:40000,1:3) DATA(35001:40000,5) DATA(35001:40000,15:21)  MHHID];
DATA_S2007=[DATA(40001:45000,1:3) DATA(40001:45000,5) DATA(40001:45000,15:21)  MHHID];

DATA_S1999(any(DATA_S1999(:,12)==1,2), :)=[];
DATA_S2000(any(DATA_S2000(:,12)==1,2), :)=[];
DATA_S2001(any(DATA_S2001(:,12)==1,2), :)=[];
DATA_S2002(any(DATA_S2002(:,12)==1,2), :)=[];
DATA_S2003(any(DATA_S2003(:,12)==1,2), :)=[];
DATA_S2004(any(DATA_S2004(:,12)==1,2), :)=[];
DATA_S2005(any(DATA_S2005(:,12)==1,2), :)=[];
DATA_S2006(any(DATA_S2006(:,12)==1,2), :)=[];
DATA_S2007(any(DATA_S2007(:,12)==1,2), :)=[];

S(:,:,1)=DATA_S2002;
S(:,:,2)=DATA_S2003;
S(:,:,3)=DATA_S2004;
S(:,:,4)=DATA_S2005;
S(:,:,5)=DATA_S2006;
S(:,:,6)=DATA_S2007;

SI=[DATA_S2000 DATA_S2001];
SI(:,24)=[];
SI(:,12)=[];


for i=1:ng
   SS{i}(:,:)=squeeze(S(i,:,:))';
end

clearvars -except W T Kex ng SS SI
save 'DataH_ReadyPTM.mat' 





