clear
clc

load SIM_DATA.mat
load POV_SIM.mat

DATA2001_2000_Y=DATA2001_Y-DATA2000_Y;

missing_comparison1=ones(5000,2);
for i=1:5000
    if isnan(DATA2001_2000_Y(i,1))==0 && isnan(u_sim_d_ln_at_cons_2001_2000(i,1))==0
       missing_comparison1(i,1)=0;
    end
    if isnan(DATA2001_Y(i,1))==0 && isnan(u_sim_ln_at_cons_2001(i,1))==0
        missing_comparison1(i,2)=0;
    end
end

missing_comparison2=ones(5000,6);
for i=1:5000
    for j=1:6
        if isnan(pov_sim(i,j+2))==0
        missing_comparison2(i,j)=0;
        end
    end
end

Obs_2000=5000-sum(missing_comparison1(:,1));
Obs_2001=5000-sum(missing_comparison1(:,2));
Obs_2002=5000-sum(missing_comparison2(:,1));
Obs_2003=5000-sum(missing_comparison2(:,2));
Obs_2004=5000-sum(missing_comparison2(:,3));
Obs_2005=5000-sum(missing_comparison2(:,4));
Obs_2006=5000-sum(missing_comparison2(:,5));
Obs_2007=5000-sum(missing_comparison2(:,6));

DATA2000_X0=DATA2000_X(:, 1);
DATA2001_X0=DATA2001_X(:, 1);
DATA2002_X0=DATA2002_X(:, 1);
DATA2003_X0=DATA2003_X(:, 1);
DATA2004_X0=DATA2004_X(:, 1);
DATA2005_X0=DATA2005_X(:, 1);
DATA2006_X0=DATA2006_X(:, 1);
DATA2007_X0=DATA2007_X(:, 1);

DATA2000_Y0=DATA2000_Y;
DATA2001_Y0=DATA2001_Y;
DATA2002_Y0=DATA2002_Y;
DATA2003_Y0=DATA2003_Y;
DATA2004_Y0=DATA2004_Y;
DATA2005_Y0=DATA2005_Y;
DATA2006_Y0=DATA2006_Y;
DATA2007_Y0=DATA2007_Y;

DATA2001_2000_Y0=DATA2001_2000_Y;

u_sim_d_ln_at_cons_2001_2000_0=u_sim_d_ln_at_cons_2001_2000;
l_sim_d_ln_at_cons_2001_2000_0=l_sim_d_ln_at_cons_2001_2000;

u_sim_ln_at_cons_2001_0=u_sim_ln_at_cons_2001;
u_sim_ln_at_cons_2002_0=u_sim_ln_at_cons_2002;
u_sim_ln_at_cons_2003_0=u_sim_ln_at_cons_2003;
u_sim_ln_at_cons_2004_0=u_sim_ln_at_cons_2004;
u_sim_ln_at_cons_2005_0=u_sim_ln_at_cons_2005;
u_sim_ln_at_cons_2006_0=u_sim_ln_at_cons_2006;
u_sim_ln_at_cons_2007_0=u_sim_ln_at_cons_2007;

l_sim_ln_at_cons_2001_0=l_sim_ln_at_cons_2001;
l_sim_ln_at_cons_2002_0=l_sim_ln_at_cons_2002;
l_sim_ln_at_cons_2003_0=l_sim_ln_at_cons_2003;
l_sim_ln_at_cons_2004_0=l_sim_ln_at_cons_2004;
l_sim_ln_at_cons_2005_0=l_sim_ln_at_cons_2005;
l_sim_ln_at_cons_2006_0=l_sim_ln_at_cons_2006;
l_sim_ln_at_cons_2007_0=l_sim_ln_at_cons_2007;


for i=1:5000
    
    if missing_comparison1(i,1)==1
       DATA2000_X0(i,:)=NaN;
       DATA2000_Y0(i,:)=NaN;
       DATA2001_2000_Y0(i,:)=NaN;
       u_sim_d_ln_at_cons_2001_2000_0(i,:)=NaN;
       l_sim_d_ln_at_cons_2001_2000_0(i,:)=NaN;
    end
    
    if missing_comparison1(i,2)==1
       DATA2001_X0(i,:)=NaN;
       DATA2001_Y0(i,:)=NaN;
       u_sim_ln_at_cons_2001_0(i,:)=NaN;
       l_sim_ln_at_cons_2001_0(i,:)=NaN;
     end
    
    if missing_comparison2(i,1)==1
       DATA2002_X0(i,:)=NaN;
       DATA2002_Y0(i,:)=NaN;
       u_sim_ln_at_cons_2002_0(i,:)=NaN;
       l_sim_ln_at_cons_2002_0(i,:)=NaN;
    end
    
    if missing_comparison2(i,2)==1
       DATA2003_X0(i,:)=NaN;           
       DATA2003_Y0(i,:)=NaN;
       u_sim_ln_at_cons_2003_0(i,:)=NaN;
       l_sim_ln_at_cons_2003_0(i,:)=NaN;
    end
    
    if missing_comparison2(i,3)==1
       DATA2004_X0(i,:)=NaN;
       DATA2004_Y0(i,:)=NaN;
       u_sim_ln_at_cons_2004_0(i,:)=NaN;
       l_sim_ln_at_cons_2004_0(i,:)=NaN;
    end
    if missing_comparison2(i,4)==1
       DATA2005_X0(i,:)=NaN;
       DATA2005_Y0(i,:)=NaN;
       u_sim_ln_at_cons_2005_0(i,:)=NaN;
       l_sim_ln_at_cons_2005_0(i,:)=NaN;
    end
    if missing_comparison2(i,5)==1
       DATA2006_X0(i,:)=NaN;
       DATA2006_Y0(i,:)=NaN;
       u_sim_ln_at_cons_2006_0(i,:)=NaN;
       l_sim_ln_at_cons_2006_0(i,:)=NaN;
    end
    if missing_comparison2(i,6)==1
       DATA2007_X0(i,:)=NaN;
       DATA2007_Y0(i,:)=NaN;
       u_sim_ln_at_cons_2007_0(i,:)=NaN;
       l_sim_ln_at_cons_2007_0(i,:)=NaN;
    end
end

%TABLE1: Summary statistics
YX=[DATA2000_Y0 DATA2000_X0 DATA2001_Y0 DATA2001_X0 DATA2002_Y0 DATA2002_X0 DATA2003_Y0 DATA2003_X0 DATA2004_Y0 DATA2004_X0 DATA2005_Y0 DATA2005_X0 DATA2006_Y0 DATA2006_X0 DATA2007_Y0 DATA2007_X0];
MEAN_YX=(nanmean(YX))';
STD_YX=(nanstd(YX))';

RESHAPE1=reshape(MEAN_YX, 2, 8);
RESHAPE2=reshape(STD_YX, 2, 8);

k=1;
for i=1:2:3
    for j=1:8
    TABLE1four(i,j)=RESHAPE1(k,j);
    end
    k=k+1;
end

k=1;
for i=2:2:4
    for j=1:8
    TABLE1four(i,j)=RESHAPE2(k,j);
    end
    k=k+1;
end

TABLE1=ones(4,8);
for i=1:4
    for j=1:8
    a=sprintf('%0.2f',TABLE1four(i,j));
    b=str2num(a);
    TABLE1ro(i,j)=b;
    end
end

TABLE1ro(5,:)=[Obs_2000, Obs_2001, Obs_2002, Obs_2003, Obs_2004, Obs_2005, Obs_2006, Obs_2007];    

format bank
TABLE1=TABLE1ro


%TABLE E5: Statistics for reported/simulated consumption
format shortG
FTHO=ones(24,1);
DS=[DATA2001_2000_Y0 DATA2001_Y0 DATA2002_Y0 DATA2003_Y0 DATA2004_Y0 DATA2005_Y0 DATA2006_Y0 DATA2007_Y0 u_sim_d_ln_at_cons_2001_2000_0 u_sim_ln_at_cons_2001_0 u_sim_ln_at_cons_2002_0 u_sim_ln_at_cons_2003_0 u_sim_ln_at_cons_2004_0 u_sim_ln_at_cons_2005_0 u_sim_ln_at_cons_2006_0 u_sim_ln_at_cons_2007_0 l_sim_d_ln_at_cons_2001_2000_0 l_sim_ln_at_cons_2001_0 l_sim_ln_at_cons_2002_0 l_sim_ln_at_cons_2003_0 l_sim_ln_at_cons_2004_0 l_sim_ln_at_cons_2005_0 l_sim_ln_at_cons_2006_0 l_sim_ln_at_cons_2007_0];
DSNAN=ones(24,1)*5000-(sum(isnan(DS)))';
DSMEAN=(nanmean(DS))';
DSSTD=(nanstd(DS))';
DSMIN=(nanmin(DS))';
DSMAX=(nanmax(DS))';

TABLEa5=[DSNAN DSMEAN  DSSTD DSMIN DSMAX]
 
% TABLE E6: POVERTY RATE
PR=nansum(pov_sim,1)';

format bank;

TABLEe6=[TABLEa5(3,1)-PR(3) TABLEa5(4,1)-PR(4) TABLEa5(5,1)-PR(5) TABLEa5(6,1)-PR(6) TABLEa5(7,1)-PR(7) TABLEa5(8,1)-PR(8) (TABLEa5(3,1)-PR(3)+TABLEa5(4,1)-PR(4)+TABLEa5(5,1)-PR(5)+TABLEa5(6,1)-PR(6)+TABLEa5(7,1)-PR(7)+TABLEa5(8,1)-PR(8))/6 ;
(TABLEa5(3,1)-PR(3))*100/TABLEa5(3,1) (TABLEa5(4,1)-PR(4))*100/TABLEa5(4,1) (TABLEa5(5,1)-PR(5))*100/TABLEa5(5,1) (TABLEa5(6,1)-PR(6))*100/TABLEa5(6,1) (TABLEa5(7,1)-PR(7))*100/TABLEa5(7,1) (TABLEa5(8,1)-PR(8))*100/TABLEa5(8,1) (TABLEa5(3,1)-PR(3)+TABLEa5(4,1)-PR(4)+TABLEa5(5,1)-PR(5)+TABLEa5(6,1)-PR(6)+TABLEa5(7,1)-PR(7)+TABLEa5(8,1)-PR(8))*100/(TABLEa5(3,1)+TABLEa5(4,1)+TABLEa5(5,1)+TABLEa5(6,1)+TABLEa5(7,1)+TABLEa5(8,1));

TABLEa5(3,1)-PR(9) TABLEa5(4,1)-PR(10) TABLEa5(5,1)-PR(11) TABLEa5(6,1)-PR(12) TABLEa5(7,1)-PR(13) TABLEa5(8,1)-PR(14) (TABLEa5(3,1)-PR(9)+TABLEa5(4,1)-PR(10)+TABLEa5(5,1)-PR(11)+TABLEa5(6,1)-PR(12)+TABLEa5(7,1)-PR(13)+TABLEa5(8,1)-PR(14))/6 ;
(TABLEa5(3,1)-PR(9))*100/TABLEa5(3,1) (TABLEa5(4,1)-PR(10))*100/TABLEa5(4,1) (TABLEa5(5,1)-PR(11))*100/TABLEa5(5,1) (TABLEa5(6,1)-PR(12))*100/TABLEa5(6,1) (TABLEa5(7,1)-PR(13))*100/TABLEa5(7,1) (TABLEa5(8,1)-PR(14))*100/TABLEa5(8,1) (TABLEa5(3,1)-PR(9)+TABLEa5(4,1)-PR(10)+TABLEa5(5,1)-PR(11)+TABLEa5(6,1)-PR(12)+TABLEa5(7,1)-PR(13)+TABLEa5(8,1)-PR(14))*100/(TABLEa5(3,1)+TABLEa5(4,1)+TABLEa5(5,1)+TABLEa5(6,1)+TABLEa5(7,1)+TABLEa5(8,1));

TABLEa5(3,1)-PR(15) TABLEa5(4,1)-PR(16) TABLEa5(5,1)-PR(17) TABLEa5(6,1)-PR(18) TABLEa5(7,1)-PR(19) TABLEa5(8,1)-PR(20) (TABLEa5(3,1)-PR(3)+TABLEa5(4,1)-PR(4)+TABLEa5(5,1)-PR(5)+TABLEa5(6,1)-PR(6)+TABLEa5(7,1)-PR(7)+TABLEa5(8,1)-PR(8))/6 ;
(TABLEa5(3,1)-PR(15))*100/TABLEa5(3,1) (TABLEa5(4,1)-PR(16))*100/TABLEa5(4,1) (TABLEa5(5,1)-PR(17))*100/TABLEa5(5,1) (TABLEa5(6,1)-PR(18))*100/TABLEa5(6,1) (TABLEa5(7,1)-PR(19))*100/TABLEa5(7,1) (TABLEa5(8,1)-PR(20))*100/TABLEa5(8,1) (TABLEa5(3,1)-PR(15)+TABLEa5(4,1)-PR(16)+TABLEa5(5,1)-PR(17)+TABLEa5(6,1)-PR(18)+TABLEa5(7,1)-PR(19)+TABLEa5(8,1)-PR(20))*100/(TABLEa5(3,1)+TABLEa5(4,1)+TABLEa5(5,1)+TABLEa5(6,1)+TABLEa5(7,1)+TABLEa5(8,1))]

% TABLE4: NUMBER OF YEARS
NY=[pov_sim(:,3)+pov_sim(:,4)+pov_sim(:,5)+pov_sim(:,6)+pov_sim(:,7)+pov_sim(:,8) pov_sim(:,9)+pov_sim(:,10)+pov_sim(:,11)+pov_sim(:,12)+pov_sim(:,13)+pov_sim(:,14)  pov_sim(:,15)+pov_sim(:,16)+pov_sim(:,17)+pov_sim(:,18)+pov_sim(:,19)+pov_sim(:,20) pov_sim(:,21)+pov_sim(:,22)+pov_sim(:,23)+pov_sim(:,24)+pov_sim(:,25)+pov_sim(:,26)];
  
for t=1:4
ny6{t}=1;
for i=1:5000
    if NY(i,t)==0
    ny6{t}=ny6{t}+1;
    end
end
end

for t=1:4
ny5{t}=1;
for i=1:5000
    if NY(i,t)==1
    ny5{t}=ny5{t}+1;
    end
end
end

for t=1:4
ny4{t}=1;
for i=1:5000
    if NY(i,t)==2
    ny4{t}=ny4{t}+1;
    end
end
end

for t=1:4
ny3{t}=1;
for i=1:5000
    if NY(i,t)==3
    ny3{t}=ny3{t}+1;
    end
end
end

for t=1:4
ny2{t}=1;
for i=1:5000
    if NY(i,t)==4
    ny2{t}=ny2{t}+1;
    end
end
end


for t=1:4
ny1{t}=1;
for i=1:5000
    if NY(i,t)==5
    ny1{t}=ny1{t}+1;
    end
end
end


for t=1:4
ny0{t}=1;
for i=1:5000
    if NY(i,t)==6
    ny0{t}=ny0{t}+1;
    end
end
end

TABLE4=[ny0{1} ny1{1} ny2{1} ny3{1} ny4{1} ny5{1} ny6{1};
ny0{1}/TABLEa5(8,1)*100 ny1{1}/TABLEa5(8,1)*100 ny2{1}/TABLEa5(8,1)*100 ny3{1}/TABLEa5(8,1)*100 ny4{1}/TABLEa5(8,1)*100 ny5{1}/TABLEa5(8,1)*100 ny6{1}/TABLEa5(8,1)*100;
 
ny0{2} ny1{2} ny2{2} ny3{2} ny4{2} ny5{2} ny6{2};
ny0{2}/TABLEa5(8,1)*100 ny1{2}/TABLEa5(8,1)*100 ny2{2}/TABLEa5(8,1)*100 ny3{2}/TABLEa5(8,1)*100 ny4{2}/TABLEa5(8,1)*100 ny5{2}/TABLEa5(8,1)*100 ny6{2}/TABLEa5(8,1)*100;
 
ny0{3} ny1{3} ny2{3} ny3{3} ny4{3} ny5{3} ny6{3};
ny0{3}/TABLEa5(8,1)*100 ny1{3}/TABLEa5(8,1)*100 ny2{3}/TABLEa5(8,1)*100 ny3{3}/TABLEa5(8,1)*100 ny4{3}/TABLEa5(8,1)*100 ny5{3}/TABLEa5(8,1)*100 ny6{3}/TABLEa5(8,1)*100;
]





