% #3 SIMULATION WITH EMPIRICAL DISTRIBUTION + BOOTSTRAP SE
% TM1 - estimates_survey, gamma and ng (in addition to DXY0, I1 and I2)

clear
clc
format short;

display('Bootstrapping for the results based on Empirical Distribution')

randn('state',sum(100*clock));
rand('state',sum(100*clock));  %initialize random number generator

load Data_ReadyPTM; 
clearvars -except ng

B=1000; % # of repetitions
var_errors=zeros(B,15);
rep=0;nega1=0; nega2=0; nega3=0; nega4=0; nega5=0; nega6=0; 
nanE=0;count=0;
R=rand(5*B,ng);
%stream = RandStream.getGlobalStream;
%savedState = stream.State;


while rep<B;
    rep=rep+1;
    count=count+1;
    load Data_ReadyPTM;   
    rep
    
    W0=W;
    SS0=SS;
    SI0=SI;
    k1=zeros(ng,1);
    
    for i=1:ng
        j=round(R(rep+nega1+nega2+nega3+nega4+nega5+nega6+nanE+count,i)*(ng-1))+1;
        W{i}=W0{j};
        SS{i}=SS0{j};
        SI(i,:)=SI0(j,:);
        k1(i)=j;

    DATA2001_X(i,:)=W{i}(3,3:9);
    DATA2002_X(i,:)=W{i}(4,3:9);
    DATA2003_X(i,:)=W{i}(5,3:9);
    DATA2004_X(i,:)=W{i}(6,3:9);
    DATA2005_X(i,:)=W{i}(7,3:9);
    DATA2006_X(i,:)=W{i}(8,3:9);
    DATA2007_X(i,:)=W{i}(9,3:9);
    
    DATA2002_Y(i,:)=W{i}(4,1);
    DATA2003_Y(i,:)=W{i}(5,1);
    DATA2004_Y(i,:)=W{i}(6,1);
    DATA2005_Y(i,:)=W{i}(7,1);
    DATA2006_Y(i,:)=W{i}(8,1);
    DATA2007_Y(i,:)=W{i}(9,1);
    
    end
    
% Two-step GMM estimation
% calculate the size of Z
LagBegin=3; % first internal IV - t-3 
sgiv=1+2+3+4+5+6; % internal IV t-3 and t-4 :21
sei=2*(T-LagBegin); % t-2 and t-3 lags *6 years external IVs: 12
sex=(Kex-5)*(T-LagBegin); % # of exogenous variable, which is reduced (dummy correction) 
sZ=sgiv+sex+sei; %size of Z:  6K+6+21+12=45 with K=1, and 1 constant each year
sW=Kex+1; %size of W: 8

% initiate matrices
obs=0;
ANINV0=zeros(sZ,sZ);
WZ=zeros(sW,sZ);
ZW=zeros(sZ,sW);
Zy=zeros(sZ,1);

s1=0;

% to construct Z instrument matrix
 for i=1:ng
   % first differencing (but keep time dummies as levels)
   for t=1:6
   W_star0{i}(t,1:sW+1)=[W{i}(t+3,1:3)-W{i}(t+2,1:3) W{i}(t+3, 4:sW+1)]; % consumption and hhsize first differencing
   end
      
   % to control sample size for l_is_head
   % to control sample size for ln_l3_at_cons (preserving t-3 consumption)
   for t=1:6
   W_star0{i}(t,sW+2:sW+3)=[W{i}(t+3,12) W{i}(t,1)];    
   end

   % GMM-Style instrumental variable matrix Z
   % exogenous variables (differenced) and external IVs (not differenced)
   % without dummy variables (but a constant term included)
   Z{i}(:,:)=zeros(6,sZ);   % initiate matrix
   Z{i}(1,1:1+1+1+2)   = [1 W{i}(1,1)                                                   W_star0{i}(1, 3) W{i}(4, 10:11)];
   Z{i}(2,6:6+2+1+2)   = [1 W{i}(1,1) W{i}(2,1)                                         W_star0{i}(2, 3) W{i}(5, 10:11)];
   Z{i}(3,12:12+3+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1)                               W_star0{i}(3, 3) W{i}(6, 10:11)];
   Z{i}(4,19:19+4+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1)                     W_star0{i}(4, 3) W{i}(7, 10:11)];
   Z{i}(5,27:27+5+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1)           W_star0{i}(5, 3) W{i}(8, 10:11)];
   Z{i}(6,36:36+6+1+2) = [1 W{i}(1,1) W{i}(2,1) W{i}(3,1) W{i}(4,1) W{i}(5,1) W{i}(6,1) W_star0{i}(6, 3) W{i}(9, 10:11)];
      

   %to keep observations with NaN for consumption at t-4 and earlier
   if  isnan(W{i}(1,1))==1
       Z{i}(2,7)=0;
       Z{i}(3,13)=0;
       Z{i}(4,20)=0;
       Z{i}(5,28)=0;
       Z{i}(6,37)=0;
   end
   if isnan(W{i}(2,1))==1
       Z{i}(3,14)=0;
       Z{i}(4,21)=0;
       Z{i}(5,29)=0;
       Z{i}(6,38)=0;
   end
   if isnan(W{i}(3,1))==1
       Z{i}(4,22)=0;
       Z{i}(5,30)=0;
       Z{i}(6,39)=0; 
   end
   if isnan(W{i}(4,1))==1
       Z{i}(5,31)=0;
       Z{i}(6,40)=0; 
   end
   if isnan(W{i}(5,1))==1
       Z{i}(6,41)=0; 
   end

   
   DXY0{i}=W_star0{i}(:,1:9);
   DXY0{i}(1,10)=2002;
   DXY0{i}(2,10)=2003;
   DXY0{i}(3,10)=2004;
   DXY0{i}(4,10)=2005;
   DXY0{i}(5,10)=2006;
   DXY0{i}(6,10)=2007;
   DXY0{i}(1,11)=i;
   DXY0{i}(2,11)=i;
   DXY0{i}(3,11)=i;
   DXY0{i}(4,11)=i;
   DXY0{i}(5,11)=i;
   DXY0{i}(6,11)=i;
   
   I1{i}=W_star0{i};
   I2{i}=Z{i};
   
   % sample size control, delete NaN 
   k2=0; 
   for t=1:6
        if sum(isnan(W_star0{i}(t-k2,:)))>0 || sum(isnan(Z{i}(t-k2,:)))>0  
        W_star0{i}(t-k2,:)=[];
        Z{i}(t-k2,:)=[];
        SS{i}(t-k2,:)=[];
        k2=k2+1;  
       end
   end
   

   % dependent and independent variables
   W_star{i}=W_star0{i}(:,2:9);
   y_star{i}=W_star0{i}(:,1);
    
   % calculating # of observations (this is not # of groups)
   s=size(W_star0{i},1);
   obs=obs+s;
      
   % Weight Matrix for one step estimator
   H0{i}=eye(6,6);
      
   % for unbalanced panel      
   for j=1:6-s
   H0{i}(:,6-j+1)=[];
   H0{i}(6-j+1,:)=[];
   end   
   
   AN00{i}=Z{i}'*H0{i}*Z{i}; 
   ANINV0=(ANINV0+AN00{i});
   WZ0{i}=W_star{i}'*Z{i};
   WZ=(WZ+WZ0{i});
   ZW0{i}=Z{i}'*W_star{i};
   ZW=(ZW+ZW0{i});
   Zy0{i}=Z{i}'*y_star{i};
   Zy=(Zy+Zy0{i});
 end
     
 ANINV0=ANINV0/ng;
 ev1=eig(ANINV0);
 if min(ev1)<=0
     disp('Warning: One-step Covariance matrix of moment conditions is singular')
 end
 AN0=inv(ANINV0); 
  
 % one-step estimator
 delta1=(inv(WZ*AN0*ZW))*(WZ*AN0*Zy);
 ev11=eig(WZ*AN0*ZW);
 if min(ev11)<=0
     disp('Warning: Matrix is singular')
 end
 
 ANINV=zeros(sZ,sZ);
 
 for i=1:ng
  % residuals from the first step GMM   
  r{i}=y_star{i}-W_star{i}*delta1;
  % weight matrix for two step estimator
  H1{i}= (r{i})*(r{i})';
  AN1{i}=Z{i}'*H1{i}*Z{i}; 
  ANINV=(ANINV+AN1{i});
 end
  
 ANINV=ANINV/ng; 
 ev2=eig(ANINV);
 if min(ev2)<=0
     disp('Warning: Two-step Covariance matrix of moment conditions is singular')
 end
 AN=inv(ANINV);
   
 % two-step estimator
 delta=(inv(WZ*AN*ZW))*(WZ*AN*Zy);
 delta0=delta;
 ev22=eig(WZ*AN*ZW);
 if min(ev22)<=0
     disp('Warning: Matrix is singular')
 end 
 
  
% original parameterization for time dummies
A=blkdiag(eye(2,2),tril(ones(6,6)));
delta_c=A*delta;
delta=delta_c;

estimates_survey=delta;
gamma=estimates_survey(1)

s=1; 
for i=1:ng
    ut0{i}=DXY0{i}(:,1)-DXY0{i}(:,2:3)*estimates_survey(1:2);
    ut0{i}(1)=ut0{i}(1)-delta0(3);
    ut0{i}(2)=ut0{i}(2)-delta0(4);
    ut0{i}(3)=ut0{i}(3)-delta0(5);
    ut0{i}(4)=ut0{i}(4)-delta0(6);
    ut0{i}(5)=ut0{i}(5)-delta0(7);
    ut0{i}(6)=ut0{i}(6)-delta0(8);
    % DXY00: (1)Revised HHID (2)year (3)ut0 
    DXY00{i}=[DXY0{i}(:,11) DXY0{i}(:,10) ut0{i}];
    
    
    d_tau_2002(s,1:2)=[ut0{i}(1,1) SS{i}(1,2)];
    s=s+1;
    
    DXY00{i}(1,4)= NaN(1,1);
    DXY00{i}(2,4)= DXY00{i}(1,3);
    DXY00{i}(3,4)= DXY00{i}(2,3);
    DXY00{i}(4,4)= DXY00{i}(3,3);
    DXY00{i}(5,4)= DXY00{i}(4,3);
    DXY00{i}(6,4)= DXY00{i}(5,3);
    
    DXY00{i}(1,5)= NaN(1,1);
    DXY00{i}(2,5)= NaN(1,1);
    DXY00{i}(3,5)= DXY00{i}(2,4);
    DXY00{i}(4,5)= DXY00{i}(3,4);
    DXY00{i}(5,5)= DXY00{i}(4,4);
    DXY00{i}(6,5)= DXY00{i}(5,4);   
    
    DXY00{i}(1,6)= NaN(1,1);
    DXY00{i}(2,6)= NaN(1,1);
    DXY00{i}(3,6)= NaN(1,1);
    DXY00{i}(4,6)= DXY00{i}(3,5);
    DXY00{i}(5,6)= DXY00{i}(4,5);
    DXY00{i}(6,6)= DXY00{i}(5,5);   
    
    %Forward + 1
    DXY00{i}(1,7)= DXY00{i}(2,3);
    DXY00{i}(2,7)= DXY00{i}(3,3);
    DXY00{i}(3,7)= DXY00{i}(4,3);
    DXY00{i}(4,7)= DXY00{i}(5,3);
    DXY00{i}(5,7)= DXY00{i}(6,3);
    DXY00{i}(6,7)= NaN(1,1);   
        
    d_tau{i}=DXY00{i};
    
    ut0{i}=DXY00{i};
          
    E{i}=[I1{i} I2{i}];
    
    k1=7; 
    for t=1:6
       if sum(isnan(E{i}(k1-t,:)))>0   
       ut0{i}(k1-t,:)=[];
       end
    end  
end
 
clear d_tau
obs0=0;
for i=1:ng
     swi=size(ut0{i},1);
     d_tau_i(obs0+1:obs0+swi,:)=ut0{i}(:,:);
     obs0=size(d_tau_i,1);
end
obs0;
 
ut=d_tau_i(:,3);
ut_1=d_tau_i(:,4);
ut_2=d_tau_i(:,5);    
 
% a hat / var a hat
ut_ut=ut.*ut;
ut_ut_1=ut.*ut_1;
ut_ut_2=ut.*ut_2;
 

w0=nanmean(ut_ut,1);
w1=nanmean(ut_ut_1,1);
w2=nanmean(ut_ut_2,1);

% G hat
G=[ 0   2*((gamma)^2+gamma+1) 1;
    1   (-1)*((gamma)^2+2*gamma+1) 0;
    0   gamma 0];

a=[w0;w1;w2];
 
% b hat
b_hat=inv(G)*a;
sq_b_hat=b_hat.^(1/2);
 
C0=b_hat(1,1); 
var_me2=b_hat(2,1);
var_s=b_hat(3,1); 

if var_me2<0 | var_s<0
    rep=rep-1;
    clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE  TABLE44B TABLE55B;
    nega1=nega1+1;
    continue
end

% G hat (further decomposition as main)
G0=[ 2   2*((gamma)^2+gamma+1) 1;
   -1   (-1)*((gamma)^2+2*gamma+1) 0;
    0   gamma 0];

b_hat0=inv(G0)*a;
var_equ=b_hat0(1,1);
var_u=b_hat0(3,1);

%Skewness
ut_b1=d_tau_i(:,4);
ut_f1=d_tau_i(:,7);

ut_ut=ut.*ut;
s1=ut_ut.*ut;
s2=ut_ut.*ut_b1;
s3=ut_ut.*ut_f1;

sw0=nanmean(s1,1);
sw1=nanmean(s2,1);
sw2=nanmean(s3,1);

a3=[sw0;sw1;sw2];

% S hat
S=[0 (-3).*((gamma.^2)+gamma)      1 ;
   1 (-1).*(gamma.^3)+2.*gamma+1   0 ;
   -1 (gamma.^3)+2.*(gamma.^2)-1     0 ];

% m3 hat
m3_hat=inv(S)*a3;
C1=m3_hat(1);
m3_hat=m3_hat(2:3);

b_hat_s=[var_me2; var_s];
skewN=m3_hat./(b_hat_s.^(3/2));

skew_me2=skewN(1,1);
skew_s=skewN(2,1);


%Kurtosis
ut_ut_ut=ut.*ut.*ut;
k1=ut_ut_ut.*ut;
k2=ut_ut_ut.*ut_b1;
k3=ut_ut_ut.*ut_f1;
k4=ut.*ut.*ut_1.*ut_1;


r10=var_me2.*var_me2.*( 6.*(gamma.^4)+12.*(gamma.^3)+ 18.*(gamma.^2)+12.*gamma+6 );
r11=r10+12.*var_me2.*var_s*((gamma.^2)+gamma+1);
r1=r11;

r20=(-1).*var_me2.*var_me2.*(3.*(gamma.^4)+12.*(gamma.^3)+15.*(gamma.^2)+9.*gamma+3);
r21=r20+(-1).*var_me2.*var_s.*(3.*(gamma.^2)+6.*gamma+3);
r22=r21+C0.*var_me2.*(6.*(gamma.^2)+6.*gamma+6);
r2=r22;

r30=(-1).*var_me2.*var_me2.*(3.*(gamma.^4)+9.*(gamma.^3)+15.*(gamma.^2)+12.*gamma+3);
r31=r30+(-1).*var_me2.*var_s.*(3.*(gamma.^2)+6.*gamma+3);
r32=r31+C0.*var_me2.*(6.*(gamma.^2)+6.*gamma+6);
r3=r32;

r40=var_me2.*var_me2.*(3.*(gamma.^4)+10.*(gamma.^3)+18.*(gamma.^2)+10.*gamma+3);
r41=r40+var_s.*var_s;
r42=r41+var_me2.*var_s.*(4.*(gamma.^2)+4.*gamma+4);
r43=r42+(-1).*C0.*var_me2.*(4.*(gamma.^2)+8.*gamma+4);
r4=r43;

kw0=nanmean(k1,1)-r1;
kw1=nanmean(k2,1)-r2;
kw2=nanmean(k3,1)-r3;
kw3=nanmean(k4,1)-r4;

a4=[kw0;kw1;kw2;kw3];

% K hat
K=[ 0   2.*(gamma.^4)+4.*(gamma.^3)+6.*(gamma.^2)+4.*gamma+2           1;
    1   (-1).*( (gamma.^4)+2.*(gamma.^3)+3.*(gamma.^2)+3.*gamma+1 )    0;
    1   (-1).*( (gamma.^4)+3.*(gamma.^3)+3.*(gamma.^2)+2.*gamma+1 )    0;
    0   (gamma.^4)+2.*(gamma.^3)+2.*(gamma.^2)+2.*gamma+1              0];                                                   

% m4 hat
m4_hat=inv(K'*K)*K'*a4;
C2=m4_hat(1);
m4_hat=m4_hat(2:3);
excessK=(m4_hat./(b_hat_s.^2))-3*ones(2,1);

K_me2=excessK(1,1);
K_s=excessK(2,1);

if m4_hat(1)<0 | m4_hat(2)<0 
    rep=rep-1;
    rep
    clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE  TABLE44B TABLE55B;
    nega2=nega2+1;
    continue
end

% PROJECTION

% DATA generating year by year
DATA2000 = SI(:,1:11);
DATA2001 = SI(:,12:22);
% DATA generating X, Y
DATA2000_Y=DATA2000(:,3);
DATA2001_Y=DATA2001(:,3);

% FIRST INITIAL CONDITION
% DATA
D_DATA2001_Y=DATA2001_Y-DATA2000_Y;
XX1=[DATA2001(:,2), D_DATA2001_Y, DATA2001(:,3:11), DATA2000(:,3:11)];
X1=XX1;
res0forres1=X1(:,1); % to match res0 and res1 later /hhid

Y1=X1(:,2);
X1(:,1:3)=[];
X1(:,9)=X1(:,8).*X1(:,8); %drop y_2000 and generate age^2
X1(:,18)=X1(:,17).*X1(:,17); %generate age^2

N1=length(X1);
X1(:,19)=ones(N1,1);
K1=size(X1,2);

XXX1=X1;
YYY1=Y1;

CXY1=[Y1 X1];

Y1(any(isnan(CXY1),2),:) = [];
%res0forres1(any(isnan(CXY1),2),:) = [];
X1(any(isnan(CXY1),2),:) = [];
N1=length(X1);   


% OLS regression
beta1=inv(X1'*X1)*X1'*Y1;
res0=Y1-X1*beta1;
std1=diag(((res0'*res0)./(N1-K1))*inv(X1'*X1));

v_psi0=var(res0);
v_zeta0=var(res0)-2*var_me2;

res00=YYY1-XXX1*beta1;


% SECOND INITIAL CONDITION
XX2=[DATA2001(:,2), DATA2001_Y, DATA2001(:,3:11), DATA2000(:,3:11)];
X2=XX2;
Y2=X2(:,3);
res1forres0=X2(:,1); % to match res0 and res1 later /hhid
X2(:,1:3)=[];

X2(:,9)=X2(:,8).*X2(:,8); %drop y_2000 and generate age^2
X2(:,18)=X2(:,17).*X2(:,17); %generate age^2
N2=length(X2);
X2(:,19)=ones(N2,1);
K2=size(X2,2);

YYY2=Y2;
XXX2=X2;

CXY2=[Y2 X2];
Y2(any(isnan(CXY2),2),:) = [];
%res1forres0(any(isnan(CXY2),2),:) = [];
X2(any(isnan(CXY2),2),:) = [];
N2=length(X2);

% OLS regression
beta2=inv(X2'*X2)*X2'*Y2;
res1=Y2-X2*beta2;
std2=diag(((res1'*res1)./(N2-K2))*inv(X2'*X2));

v_psi1=var(res1);
ubound=v_psi1-var_me2;

res11=YYY2-XXX2*beta2;

ERT012=[res00 res0forres1 res11 res1forres0 d_tau_2002]; 
tau_2_1=[res00 d_tau_2002(:,1)];
tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov0=cov(tau_2_1);
E_zeta0_derr =(1+2*gamma)*var_me2+cov0(1,2);

tau_2_1=[res11 d_tau_2002(:,1)];
tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov1=cov(tau_2_1);
E_zeta1_derr =(1+gamma)*var_me2+cov1(1,2);

res=[res00 res11];
res(any(isnan(res),2),:)=[];
C_res=cov(res);
C_zeta0_zeta1=C_res(1,2)-var_me2;
 
% CHECK POSITIVE SEMIDEFINITE
COVMU=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 ubound          E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
du = eig(COVMU) ;
if min(du)<0
    %break
    rep=rep-1;
    rep
    nega6=nega6+1;
    clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE TABLE44B TABLE55B; 
    continue
end
% Positive semidefinite
for x1= 0.0100:0.0001:ubound
 
COVML=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 x1              E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
 
dl = eig(COVML); 
 
if min(dl)>0
    break
end
   
end
 
x1;
[V, D]= eig(COVML) ;
 
% check whether the 7*7 positive definite matrix
COVML77=[v_zeta0         E_zeta0_derr       0                 0                0                0                 0;
         E_zeta0_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
         0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
         0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
         0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
         0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
         0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
dl77 = eig(COVML77);


%projection error 0
m03_hat=mean(res0.^3);
skew0=m03_hat./(v_zeta0.^(3/2));
m04_hat=mean(res0.^4)-2*m4_hat(1)-12*var_me2*v_zeta0-6*var_me2*var_me2;
excessK0=(m04_hat./(v_zeta0.^2))-3*ones(1,1);

if m04_hat<0 
    rep=rep-1;
    rep
    %break
    clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE TABLE44B TABLE55B;
    nega3=nega3+1;
    continue
end

%projection error 1/upper bound
m13u_hat=mean(res1.^3)-m3_hat(1);
skew1u=m13u_hat./(ubound.^(3/2));
m14u_hat=mean(res1.^4)-m4_hat(1)-6*var_me2*ubound; 
excessK1u=(m14u_hat./(ubound.^2))-3*ones(1,1);

if m14u_hat<0 
    rep=rep-1;
    rep
    clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE TABLE44B TABLE55B;
    nega4=nega4+1;
    continue
end

%projection error 1/lower bound
c0=V(1,1); c1=V(2,1); c2=V(3,1); c3=V(4,1);
c4=V(5,1); c5=V(6,1); c6=V(7,1); c7=V(8,1);

m13l_hat0=(-1)*(c0^3)*m03_hat + ((c2^3)+(c3^3)+(c4^3)+(c5^3)+(c6^3)+(c7^3))*m3_hat(2); 
m13l_hat1=m13l_hat0+3*C1*(c2*(c3^2)+c3*(c4^2)+c4*(c5^2)+c5*(c6^2)+c6*(c7^2)+(-1)*((c2^2)*c3+(c3^2)*c4+(c4^2)*c5+(c5^2)*c6+(c6^2)*c7));
m13l_hat=(1/(c1^3))*m13l_hat1;
skew1l=m13l_hat./(x1.^(3/2));

cc0=    (c0^2)*((c2^2)+(c3^2)+(c4^2)+(c5^2)+(c6^2)+(c7^2));
cc1=cc0+(c2^2)*((c3^2)+(c4^2)+(c5^2)+(c6^2)+(c7^2));
cc2=cc1+(c3^2)*((c4^2)+(c5^2)+(c6^2)+(c7^2));
cc3=cc2+(c4^2)*((c5^2)+(c6^2)+(c7^2));
cc4=cc3+(c5^2)*((c6^2)+(c7^2));
cc =cc4+(c6^2)*((c7^2));

m14l_hat0=(c0^4)*m04_hat +((c2^4)+(c3^4)+(c4^4)+(c5^4)+(c6^4)+(c7^4))*m4_hat(2);
m14l_hat1=m14l_hat0+6*v_zeta0*var_s*(c0^2)*((c2^2)+(c3^2)+(c4^2)+(c5^2)+(c6^2)+(c7^2));
m14l_hat2=m14l_hat1+6*var_s*var_s*cc;
m14l_hat3=m14l_hat2+4*C2*( (c2^3)*c3+(c3^3)*c4+(c4^3)*c5+(c5^3)*c6+(c6^3)*c7 +c2*(c3^3)+c3*(c4^3)+c4*(c5^3)+c5*(c6^3)+c6*(c7^3));
m14l_hat4=m14l_hat3+12*C0*v_zeta0*(c0^2)*(c2*c3+c3*c4+c4*c5+c5*c6+c6*c7);
m14l_hat5=m14l_hat4+12*((-2)*var_equ*var_equ-var_equ*var_u)*((c2^2)*c3*c4+(c3^2)*c4*c5+(c4^2)*c5*c6+(c5^2)*c6*c7+c2*c3*(c4^2)+c3*c4*(c5^2)+c4*c5*(c6^2)+c5*c6*(c7^2));
m14l_hat6=m14l_hat5+12*2*var_equ*var_equ*(c2*(c3^2)*c4+c3*(c4^2)*c5+c4*(c5^2)*c6+c5*(c6^2)*c7);
m14l_hat=(1/(c1^4))*m14l_hat6; 
excessK1l=(m14l_hat./(x1.^2))-3*ones(1,1);

if m14l_hat<0 
    rep=rep-1;
    rep
    clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE TABLE44B TABLE55B;
    nega5=nega5+1;
    continue
end

errorM=[var_s skew_s excessK(2); 
        v_zeta0 skew0 excessK0; 
        ubound skew1u excessK1u; 
        x1 skew1l excessK1l]


% SIMULATE ERRORS FROM NORMAL DISTRIBUTION
mu=[0 0 0 0 0 0 0 0 ];
mu77=[0 0 0 0 0 0 0 ];
error_u = mvnrnd(mu,COVMU,ng);
error_l = mvnrnd(mu,COVML,ng);
error_l77 = mvnrnd(mu77,COVML77,ng);
 
zeta1=NaN(ng,1);
zeta1=(1/(V(2,1))) * (-1) *(V(1,1)*error_l77(:,1)+V(3,1)*error_l77(:,2)+V(4,1)*error_l77(:,3)+V(5,1)*error_l77(:,4)+V(6,1)*error_l77(:,5)+V(7,1)*error_l77(:,6)+V(8,1)*error_l77(:,7));
error_l=[error_l77(:,1) zeta1 error_l77(:,2:7)];

covmu=diag(COVMU.^(1/2))';
covml=diag(cov(error_l).^(1/2))';

U_upper0=normcdf(error_u(:,1), mu(1),covmu(1));
U_upper1=normcdf(error_u(:,2), mu(2),covmu(2));
U_upper2=normcdf(error_u(:,3), mu(3),covmu(3));
U_upper3=normcdf(error_u(:,4), mu(4),covmu(4));
U_upper4=normcdf(error_u(:,5), mu(5),covmu(5));
U_upper5=normcdf(error_u(:,6), mu(6),covmu(6));
U_upper6=normcdf(error_u(:,7), mu(7),covmu(7));
U_upper7=normcdf(error_u(:,8), mu(8),covmu(8));

U_upper=[U_upper0 U_upper1 U_upper2 U_upper3 U_upper4 U_upper5 U_upper6 U_upper7];

U_lower0=normcdf(error_l(:,1), mu(1),covml(1));
U_lower1=normcdf(error_l(:,2), mu(2),covml(2));
U_lower2=normcdf(error_l(:,3), mu(3),covml(3));
U_lower3=normcdf(error_l(:,4), mu(4),covml(4));
U_lower4=normcdf(error_l(:,5), mu(5),covml(5));
U_lower5=normcdf(error_l(:,6), mu(6),covml(6));
U_lower6=normcdf(error_l(:,7), mu(7),covml(7));
U_lower7=normcdf(error_l(:,8), mu(8),covml(8));

U_lower=[U_lower0 U_lower1 U_lower2 U_lower3 U_lower4 U_lower5 U_lower6 U_lower7];

rho_upper = copulafit('Gaussian',U_upper);
rho_lower = copulafit('Gaussian',U_lower);

ERROR_U= copularnd('Gaussian',rho_upper,ng);
ERROR_L= copularnd('Gaussian',rho_lower,ng);

[EMP]=TransitionMatrix3b(errorM);

if sum(sum(isnan(EMP)))>0
    rep=rep-1;
    rep
    clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE TABLE44B TABLE55B;
    nanE=nanE+1;
    continue
end

display('inverse cdf calculating....')
eu0=ksdensity(EMP(:,1),ERROR_U(:,1),'function','icdf');
eu1=ksdensity(EMP(:,2),ERROR_U(:,2),'function','icdf');
eu2=ksdensity(EMP(:,4),ERROR_U(:,3),'function','icdf');
eu3=ksdensity(EMP(:,4),ERROR_U(:,4),'function','icdf');
eu4=ksdensity(EMP(:,4),ERROR_U(:,5),'function','icdf');
eu5=ksdensity(EMP(:,4),ERROR_U(:,6),'function','icdf');
eu6=ksdensity(EMP(:,4),ERROR_U(:,7),'function','icdf');
eu7=ksdensity(EMP(:,4),ERROR_U(:,8),'function','icdf');
eu=[eu0 eu1 eu2 eu3 eu4 eu5 eu6 eu7];
EDCu=cov(eu);

el0=ksdensity(EMP(:,1),ERROR_L(:,1),'function','icdf');
el1=ksdensity(EMP(:,3),ERROR_L(:,2),'function','icdf');
el2=ksdensity(EMP(:,4),ERROR_L(:,3),'function','icdf');
el3=ksdensity(EMP(:,4),ERROR_L(:,4),'function','icdf');
el4=ksdensity(EMP(:,4),ERROR_L(:,5),'function','icdf');
el5=ksdensity(EMP(:,4),ERROR_L(:,6),'function','icdf');
el6=ksdensity(EMP(:,4),ERROR_L(:,7),'function','icdf');
el7=ksdensity(EMP(:,4),ERROR_L(:,8),'function','icdf');
el=[el0 el1 el2 el3 el4 el5 el6 el7];
EDlC=cov(el);
display('inverse cdf calculated.')

HMC=[var(eu5) skewness(eu5) kurtosis(eu5)-3;
     var(eu0) skewness(eu0) kurtosis(eu0)-3;
     var(eu1) skewness(eu1) kurtosis(eu1)-3;
     var(el1) skewness(el1) kurtosis(el1)-3];

 
% SIMULATE CONSUMPTION for UPPER BOUND 
u_sim_d_ln_at_cons_2001_2000=XXX1*beta1+eu0;
u_sim_ln_at_cons_2001=XXX2*beta2+eu1;
u_sim_ln_at_cons_2002=u_sim_ln_at_cons_2001+[u_sim_d_ln_at_cons_2001_2000 (DATA2002_X-DATA2001_X)]*estimates_survey+eu2;
u_sim_ln_at_cons_2003=u_sim_ln_at_cons_2002+[(u_sim_ln_at_cons_2002-u_sim_ln_at_cons_2001) (DATA2003_X-DATA2002_X)]*estimates_survey+eu3;
u_sim_ln_at_cons_2004=u_sim_ln_at_cons_2003+[(u_sim_ln_at_cons_2003-u_sim_ln_at_cons_2002) (DATA2004_X-DATA2003_X)]*estimates_survey+eu4;
u_sim_ln_at_cons_2005=u_sim_ln_at_cons_2004+[(u_sim_ln_at_cons_2004-u_sim_ln_at_cons_2003) (DATA2005_X-DATA2004_X)]*estimates_survey+eu5;
u_sim_ln_at_cons_2006=u_sim_ln_at_cons_2005+[(u_sim_ln_at_cons_2005-u_sim_ln_at_cons_2004) (DATA2006_X-DATA2005_X)]*estimates_survey+eu6;
u_sim_ln_at_cons_2007=u_sim_ln_at_cons_2006+[(u_sim_ln_at_cons_2006-u_sim_ln_at_cons_2005) (DATA2007_X-DATA2006_X)]*estimates_survey+eu7;
 
% SIMULATE CONSUMPTION for CONSTRAINED LOWER BOUND
l_sim_d_ln_at_cons_2001_2000=XXX1*beta1+el0;
l_sim_ln_at_cons_2001=XXX2*beta2+el1;
l_sim_ln_at_cons_2002=l_sim_ln_at_cons_2001+[l_sim_d_ln_at_cons_2001_2000 (DATA2002_X-DATA2001_X)]*estimates_survey+el2;
l_sim_ln_at_cons_2003=l_sim_ln_at_cons_2002+[(l_sim_ln_at_cons_2002-l_sim_ln_at_cons_2001) (DATA2003_X-DATA2002_X)]*estimates_survey+el3;
l_sim_ln_at_cons_2004=l_sim_ln_at_cons_2003+[(l_sim_ln_at_cons_2003-l_sim_ln_at_cons_2002) (DATA2004_X-DATA2003_X)]*estimates_survey+el4;
l_sim_ln_at_cons_2005=l_sim_ln_at_cons_2004+[(l_sim_ln_at_cons_2004-l_sim_ln_at_cons_2003) (DATA2005_X-DATA2004_X)]*estimates_survey+el5;
l_sim_ln_at_cons_2006=l_sim_ln_at_cons_2005+[(l_sim_ln_at_cons_2005-l_sim_ln_at_cons_2004) (DATA2006_X-DATA2005_X)]*estimates_survey+el6;
l_sim_ln_at_cons_2007=l_sim_ln_at_cons_2006+[(l_sim_ln_at_cons_2006-l_sim_ln_at_cons_2005) (DATA2007_X-DATA2006_X)]*estimates_survey+el7;
 
U_SIM=[u_sim_ln_at_cons_2002 u_sim_ln_at_cons_2003 u_sim_ln_at_cons_2004 u_sim_ln_at_cons_2005 u_sim_ln_at_cons_2006 u_sim_ln_at_cons_2007];
L_SIM=[l_sim_ln_at_cons_2002 l_sim_ln_at_cons_2003 l_sim_ln_at_cons_2004 l_sim_ln_at_cons_2005 l_sim_ln_at_cons_2006 l_sim_ln_at_cons_2007];
 
sim=[d_tau_2002(:,2) ones(ng,1) DATA2002_Y DATA2003_Y DATA2004_Y DATA2005_Y DATA2006_Y DATA2007_Y U_SIM L_SIM];

a1=5.659266125;

% INDICATE IN POVERTY
pov_sim=[];
pov_sim(:,1:2)=sim(:,1:2);

NAN_BM=sum(isnan(sim));

%under the poverty=0
for i=1:ng
    for j=3:20
        if sim(i,j)<a1
        pov_sim(i,j)=0;
        else
        pov_sim(i,j)=1;
        end
        if isnan(sim(i,j))==1
        pov_sim(i,j)=NaN;  
        end
    end
end

% MATCH SURVEY AND S.DATA
for i=1:ng
    for j=3:8
    if isnan(pov_sim(i,j))+isnan(pov_sim(i,j+6))>0
        pov_sim(i,j)=NaN; 
        pov_sim(i,j+6)=NaN;
        pov_sim(i,j+12)=NaN;
        pov_sim(i,j+18)=NaN;
    end
    end
end

NAN_M=sum(isnan(pov_sim));

% TABLE4 - 2*2
% FUNCTION (YEAR1, YEAR2, TYPE, filename)
% TYPE: 1-SURVEY, 2-UBOUND, 3-LBOUNDCONSTRAINED, 4-IMPOSING STATIONARITY

% CALCULATION TRANSITION MATRIX for SURVEY
[PS, CS, cs]=TransitionMatrix4(2002,2007,1, pov_sim, ng);

% CALCULATION TRANSITION MATRIX for UBOUND
[PU, CU, cu]=TransitionMatrix4(2002,2007,2, pov_sim, ng); 

% CALCULATION TRANSITION MATRIX for LBOUND
[PL, CL, cl]=TransitionMatrix4(2002,2007,3, pov_sim, ng);  

TABLE44B(:,:, rep)=[100*PS(1,1) 100*PS(1,2);
                 100*PU(1,1) 100*PU(1,2);
                 100*PL(1,1) 100*PL(1,2);
                 100*PS(2,1) 100*PS(2,2);
                 100*PU(2,1) 100*PU(2,2);
                 100*PL(2,1) 100*PL(2,2);];
   
%TABLE - 5*5
for t=1:3
r{t}=quantile(sim(:,3+6*(t-1)), [.20 .40 .60 .80])';
end

quintile_sim=[];
quintile_sim(:,1:2)=sim(:,1:2);
for t=1:3
for i=1:ng
    for j=3:8
        if sim(i,j+6*(t-1))<r{1,t}(1)
        quintile_sim(i,j+6*(t-1))=1;
        elseif sim(i,j+6*(t-1))<r{1,t}(2);
        quintile_sim(i,j+6*(t-1))=2;
        elseif sim(i,j+6*(t-1))<r{1,t}(3);
        quintile_sim(i,j+6*(t-1))=3;
        elseif sim(i,j+6*(t-1))<r{1,t}(4);
        quintile_sim(i,j+6*(t-1))=4;
        elseif sim(i,j+6*(t-1))>=r{1,t}(4)
        quintile_sim(i,j+6*(t-1))=5;  
        else 
        quintile_sim(i,j+6*(t-1))=NaN;
        end
    end
end
end

for i=1:ng
    for j=3:8
    if isnan(quintile_sim(i,j))+isnan(quintile_sim(i,j+6))>0
        quintile_sim(i,j)=NaN; 
        quintile_sim(i,j+6)=NaN;
        quintile_sim(i,j+12)=NaN;
    end
    end
end


[PSQ,CSQ,csq]=TransitionMatrix5(2002,2007,1, quintile_sim, ng);
[PUQ,CUQ,cuq]=TransitionMatrix5(2002,2007,2, quintile_sim, ng);
[PLQ,CLQ,clq]=TransitionMatrix5(2002,2007,3, quintile_sim, ng);  

TABLE55B(:,:, rep)=[PSQ(1,1:5);  PUQ(1,1:5); PLQ(1,1:5); 
                   PSQ(2,1:5);  PUQ(2,1:5); PLQ(2,1:5); 
                   PSQ(3,1:5);  PUQ(3,1:5); PLQ(3,1:5); 
                   PSQ(4,1:5);  PUQ(4,1:5); PLQ(4,1:5); 
                   PSQ(5,1:5);  PUQ(5,1:5); PLQ(5,1:5);];   

var_errors(rep,:)=[rep obs gamma var_me2 var_s skew_me2 skew_s K_me2 K_s skew0 excessK0 skew1u excessK1u skew1l excessK1l];

clearvars -except var_errors B R rep nega1 nega2 nega3 nega4 nega5 nega6 count nanE TABLE44B TABLE55B;
%clearvars -except var_errors B R savedState;

end                 
               
save('ET_EmpDist_1000.mat');




