function [TABLEE9,TABLEE10]=TransitionMatrix3a

% #3 PREPARATION/SIMULATION/WITH EMPIRICAL DISTRIBUTION 
% sfddm - zero:analyzed

load Data_sfddm
MHHID=ones(5000,1);
k1=1;
for j1=1:5000
    if missing_sfddm(k1)==j1;
    MHHID(j1,1)=0;
    k1=k1+1;
    else 
        k1=k1;
    end
end

load Data_GMMmain
gamma=estimates_survey(1);

s=1;
for i=1:ng
    ut0{i}=DXY0{i}(:,1)-DXY0{i}(:,2:3)*estimates_survey(1:2);
    ut0{i}(1)=ut0{i}(1)-delta0(3);
    ut0{i}(2)=ut0{i}(2)-delta0(4);
    ut0{i}(3)=ut0{i}(3)-delta0(5);
    ut0{i}(4)=ut0{i}(4)-delta0(6);
    ut0{i}(5)=ut0{i}(5)-delta0(7);
    ut0{i}(6)=ut0{i}(6)-delta0(8);
    % DXY00: (1)Revised HHID (2)year (3)ut0 
    DXY00{i}=[DXY0{i}(:,11) DXY0{i}(:,10) ut0{i}];
       
    d_tau_2002(s,1:2)=[ut0{i}(1,1) missing_sfddm(s)];
    d_tau_2003(s,1:2)=[ut0{i}(2,1) missing_sfddm(s)];
    d_tau_2004(s,1:2)=[ut0{i}(3,1) missing_sfddm(s)];
    d_tau_2005(s,1:2)=[ut0{i}(4,1) missing_sfddm(s)];
    d_tau_2006(s,1:2)=[ut0{i}(5,1) missing_sfddm(s)];
    d_tau_2007(s,1:2)=[ut0{i}(6,1) missing_sfddm(s)];
    s=s+1;
end

clearvars -except ng gamma estimates_survey MHHID d_tau_2002 d_tau_2003 d_tau_2004 d_tau_2005 d_tau_2006 d_tau_2007 

load('Data_varerror')

% estimates_survey=[(1)ln_l_at_cons (2)hsize (3)d02 (4)d03 (5)d04
% (6)d05 (7)d06 (8)d07 ]

% Data for initial values by projection
% 1999-2005 data are used for the other explanatory variables
    load Data_1999_2007;
    sq_hage=hage.*hage;
    % [(1)year (2)hhid (3)ln_at_cons (4)ln_l_at_cons (5)hsize (6)m65 (7)f55
    % (8)hsex (9)hedu (10)seoul (11)nonspouse (12)hage (13)sq_hage ]
    data=[yearV hhid ln_at_cons ln_l_at_cons hsize m65 f55 hsex hedu seoul nonspouse hage sq_hage];
    data=sortrows(data, 2);
    DATA=sortrows(data, 1);
    % clear colheaders data textdata;

    % DATA generating year by year
    DATA2000 = DATA(5001:10000,:);
    DATA2001 = DATA(10001:15000,:);
    % X: (1)hsize (2)m65 (3)f55 (4)hsex (5)hedu 
    %    (6)seoul (7)nonspouse (8)hage (9)sq_hage 
    data2000_X=DATA2000(:,5:13);
    data2001_X=DATA2001(:,5:13);
    clear data DATA DATA2000 DATA2001; % only data2000_X and data2001_X remain
    
%Main data
% column description 
% sample98=data(:,1); missing=data(:,2); year=data(:,3); hhid=data(:,4); hsize=data(:,5); 
% d07=data(:,6); d06=data(:,7); d05=data(:,8); d04=data(:,9);
% d03=data(:,10); d02=data(:,11); d01=data(:,12); d00=data(:,13); d99=data(:,14); 
% ln_at_cons=data(:,15); ln_l_at_cons=data(:,16); ln_l2_at_cons=data(:,17); ln_l3_at_cons=data(:,18); ln_l4_at_cons=data(:,19); 
% l_is_head=data(:,20); l2_is_head=data(:,21);% l3_is_head=data(:,22);
% ln_l_b_asset=data(:,23); ln_l2_b_asset=data(:,24);% ln_l3_b_asset=data(:,25);

% [(1)year (2)hhid (3)ln_at_cons (4)ln_l_at_cons (5)hsize 
% (6)d02 (7)d03 (8)d04 (9)d05 (10)d06 (11)d07
% (12)l2_is_head (13)ln_l2_b_asset (14)l3_is_head (15) ln_l3_b_asset
% (16)l_is_head (17)ln_l_b_asset]

data=[yearV hhid ln_at_cons ln_l_at_cons hsize d02 d03 d04 d05 d06 d07 l2_is_head l3_is_head l_is_head]; 
data(isinf(data))=NaN;
data=sortrows(data, 2);
DATA=sortrows(data, 1);
% clear colheaders data textdata;

% DATA generating year by year
DATA1999 = DATA(1:5000,:);
DATA2000 = DATA(5001:10000,:);
DATA2001 = DATA(10001:15000,:);
DATA2002 = DATA(15001:20000,:);
DATA2003 = DATA(20001:25000,:);
DATA2004 = DATA(25001:30000,:);
DATA2005 = DATA(30001:35000,:);
DATA2006 = DATA(35001:40000,:);
DATA2007 = DATA(40001:45000,:);

% DATA generating X, Y, LAG OF Y
DATA1999_Y=DATA1999(:,3);
DATA2000_Y=DATA2000(:,3);
DATA2001_Y=DATA2001(:,3);
DATA2002_Y=DATA2002(:,3);
DATA2003_Y=DATA2003(:,3);
DATA2004_Y=DATA2004(:,3);
DATA2005_Y=DATA2005(:,3);
DATA2006_Y=DATA2006(:,3);
DATA2007_Y=DATA2007(:,3);

DATA1999_LAGY=DATA1999(:,4);
DATA2000_LAGY=DATA2000(:,4);
DATA2001_LAGY=DATA2001(:,4);
DATA2002_LAGY=DATA2002(:,4);
DATA2003_LAGY=DATA2003(:,4);
DATA2004_LAGY=DATA2004(:,4);
DATA2005_LAGY=DATA2005(:,4);
DATA2006_LAGY=DATA2006(:,4);
DATA2007_LAGY=DATA2007(:,4);

% X: (1)hsize (2)d02 (3)d03 (4)d04 (5)d05 (6)d06 (7)d07
DATA1999_X=DATA1999(:,5:11);
DATA2000_X=DATA2000(:,5:11);
DATA2001_X=DATA2001(:,5:11);
DATA2002_X=DATA2002(:,5:11);
DATA2003_X=DATA2003(:,5:11);
DATA2004_X=DATA2004(:,5:11);
DATA2005_X=DATA2005(:,5:11);
DATA2006_X=DATA2006(:,5:11);
DATA2007_X=DATA2007(:,5:11);

% PROJECTION
% FIRST INITIAL CONDITION
% DATA
D_DATA2001_Y=DATA2001_Y-DATA2000_Y;
XX1=[DATA2001(:,2), MHHID, D_DATA2001_Y, data2001_X(:,1:9), data2000_X(:,1:9) ones(5000,1)];
X1=XX1;

N1=length(X1);
k2=1;
while k2<N1  
    if X1(k2,2)==1
    X1(k2,:)=[];
    N1=length(X1);
    else
    k2=k2+1;
    end
end;
 
X1(any(isnan(X1),2),:) = [];
N1=length(X1);
 
res0forres1=X1(:,1); % to match res0 and res1 later /hhid
Y1=X1(:,3);
X1(:,1:3)=[];
K1=size(X1,2);

% OLS regression
beta1=inv(X1'*X1)*X1'*Y1;
res0=Y1-X1*beta1;
std1=diag(((res0'*res0)./(N1-K1))*inv(X1'*X1));

v_psi0=var(res0);
v_zeta0=var(res0)-2*var_me2;

res0=[res0 res0forres1];

% SECOND INITIAL CONDITION
XX2=[DATA2001(:,2), MHHID, DATA2001_Y, data2001_X(:,1:9), data2000_X(:,1:9),  ones(5000,1)];
X2=XX2;

N2=length(X2);
k3=1;
while k3<N2  
    if X2(k3,2)==1
    X2(k3,:)=[];
    N2=length(X2);
    else
    k3=k3+1;
    end
end;

X2(any(isnan(X2),2),:) = [];
N2=length(X2);

res1forres0=X2(:,1); % to match res0 and res1 later /hhid
Y2=X2(:,3);
X2(:,1:3)=[];
K2=size(X2,2);

% OLS regression
beta2=inv(X2'*X2)*X2'*Y2;
res1=Y2-X2*beta2;
std2=diag(((res1'*res1)./(N2-K2))*inv(X2'*X2));

v_psi1=var(res1);
ubound=v_psi1-var_me2;

res1=[res1 res1forres0];

% SAMPLE MATCH WITH TAU AND RES
s=1;
tau_2_1=zeros(ng,4);
for i=1:ng
    if d_tau_2002(i,2)==res0(s,2)
       tau_2_1(i,:)=[d_tau_2002(i,:) res0(s,:)];
       s=s+1;
    else
       tau_2_1(i,:)=[d_tau_2002(i,:) NaN NaN];
    end  
end

tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov0=cov(tau_2_1(:,1),tau_2_1(:,3));

s=1;
tau_2_1=zeros(ng,4);
for i=1:ng
    if d_tau_2002(i,2)==res1(s,2)
       tau_2_1(i,:)=[d_tau_2002(i,:) res1(s,:)];
       s=s+1;
    else
       tau_2_1(i,:)=[d_tau_2002(i,:) NaN NaN];
    end  
end

tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov1=cov(tau_2_1(:,1),tau_2_1(:,3));

E_zeta0_derr =(1+2*gamma)*var_me2+cov0(1,2);
E_zeta1_derr =(1+gamma)*var_me2+cov1(1,2);

% COV PROJECTION ERRORS: zeta0 and zeta1
% sample match
k4=5000;
for j=1:k4
    if res0(j,2)<res1(j,2)
    res0(j,:)=[];
    end 
    if res0(j,2)>res1(j,2)
    res1(j,:)=[];
    end
    k4=max(size(res0,1), size(res1,1));
    if (res0(j,2)==5000 || res1(j,2)==5000)
        break
    end
end

res00=[res0(:,1) res1(:,1) res0(:,2) res1(:,2)]; % matching check
res=[res0(:,1) res1(:,1)];
C_res=cov(res);
C_zeta0_zeta1=C_res(1,2)-var_me2;


 
% CHECK POSITIVE SEMIDEFINITE
COVMU=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 ubound          E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
du = eig(COVMU); 
 
 
% Positive semidefinite
for x1= 0.0100:0.0001:ubound
 
COVML=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 x1              E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
 
dl = eig(COVML); 
 
if min(dl)>0
    break
end
   
end
 
x1;
[V, D]= eig(COVML); 
 
% check whether the 7*7 positive definite matrix
COVML77=[v_zeta0         E_zeta0_derr       0                 0                0                0                 0;
         E_zeta0_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
         0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
         0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
         0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
         0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
         0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
dl77 = eig(COVML77);
 
 
 
% SIMULATE ERRORS FROM NORMAL DISTRIBUTION
mu=[0 0 0 0 0 0 0 0 ];
mu77=[0 0 0 0 0 0 0 ];
error_u = mvnrnd(mu,COVMU,5000);
error_l = mvnrnd(mu,COVML,5000);
error_l77 = mvnrnd(mu77,COVML77,5000);
 
zeta1=NaN(5000,1);
zeta1=(1/(V(2,1))) * (-1) *(V(1,1)*error_l77(:,1)+V(3,1)*error_l77(:,2)+V(4,1)*error_l77(:,3)+V(5,1)*error_l77(:,4)+V(6,1)*error_l77(:,5)+V(7,1)*error_l77(:,6)+V(8,1)*error_l77(:,7));
error_l=[error_l77(:,1) zeta1 error_l77(:,2:7)];

covmu=diag(COVMU.^(1/2))';
covml=diag(cov(error_l).^(1/2))';

U_upper0=normcdf(error_u(:,1), mu(1),covmu(1));
U_upper1=normcdf(error_u(:,2), mu(2),covmu(2));
U_upper2=normcdf(error_u(:,3), mu(3),covmu(3));
U_upper3=normcdf(error_u(:,4), mu(4),covmu(4));
U_upper4=normcdf(error_u(:,5), mu(5),covmu(5));
U_upper5=normcdf(error_u(:,6), mu(6),covmu(6));
U_upper6=normcdf(error_u(:,7), mu(7),covmu(7));
U_upper7=normcdf(error_u(:,8), mu(8),covmu(8));

U_upper=[U_upper0 U_upper1 U_upper2 U_upper3 U_upper4 U_upper5 U_upper6 U_upper7];

U_lower0=normcdf(error_l(:,1), mu(1),covml(1));
U_lower1=normcdf(error_l(:,2), mu(2),covml(2));
U_lower2=normcdf(error_l(:,3), mu(3),covml(3));
U_lower3=normcdf(error_l(:,4), mu(4),covml(4));
U_lower4=normcdf(error_l(:,5), mu(5),covml(5));
U_lower5=normcdf(error_l(:,6), mu(6),covml(6));
U_lower6=normcdf(error_l(:,7), mu(7),covml(7));
U_lower7=normcdf(error_l(:,8), mu(8),covml(8));

U_lower=[U_lower0 U_lower1 U_lower2 U_lower3 U_lower4 U_lower5 U_lower6 U_lower7];

load Data_skerror;
[EMP]=TransitionMatrix3b(errorM);

eu0=ksdensity(EMP(:,1),U_upper(:,1),'function','icdf');
eu1=ksdensity(EMP(:,2),U_upper(:,2),'function','icdf');
eu2=ksdensity(EMP(:,4),U_upper(:,3),'function','icdf');
eu3=ksdensity(EMP(:,4),U_upper(:,4),'function','icdf');
eu4=ksdensity(EMP(:,4),U_upper(:,5),'function','icdf');
eu5=ksdensity(EMP(:,4),U_upper(:,6),'function','icdf');
eu6=ksdensity(EMP(:,4),U_upper(:,7),'function','icdf');
eu7=ksdensity(EMP(:,4),U_upper(:,8),'function','icdf');
eu=[eu0 eu1 eu2 eu3 eu4 eu5 eu6 eu7];
EDCu=cov(eu);

el0=ksdensity(EMP(:,1),U_lower(:,1),'function','icdf');
el1=ksdensity(EMP(:,3),U_lower(:,2),'function','icdf');
el2=ksdensity(EMP(:,4),U_lower(:,3),'function','icdf');
el3=ksdensity(EMP(:,4),U_lower(:,4),'function','icdf');
el4=ksdensity(EMP(:,4),U_lower(:,5),'function','icdf');
el5=ksdensity(EMP(:,4),U_lower(:,6),'function','icdf');
el6=ksdensity(EMP(:,4),U_lower(:,7),'function','icdf');
el7=ksdensity(EMP(:,4),U_lower(:,8),'function','icdf');
el=[el0 el1 el2 el3 el4 el5 el6 el7];
EDlC=cov(el);

HMC=[var(eu5) skewness(eu5) kurtosis(eu5)-3;
     var(eu0) skewness(eu0) kurtosis(eu0)-3;
     var(eu1) skewness(eu1) kurtosis(eu1)-3;
     var(el1) skewness(el1) kurtosis(el1)-3];

 
% SIMULATE CONSUMPTION for UPPER BOUND 
u_sim_d_ln_at_cons_2001_2000=[data2001_X(:,1:9), data2000_X(:,1:9), ones(5000,1)]*beta1+eu0;
u_sim_ln_at_cons_2001=[data2001_X(:,1:9), data2000_X(:,1:9) ones(5000,1)]*beta2+eu1;
u_sim_ln_at_cons_2002=u_sim_ln_at_cons_2001+[u_sim_d_ln_at_cons_2001_2000 (DATA2002_X-DATA2001_X)]*estimates_survey+eu2;
u_sim_ln_at_cons_2003=u_sim_ln_at_cons_2002+[(u_sim_ln_at_cons_2002-u_sim_ln_at_cons_2001) (DATA2003_X-DATA2002_X)]*estimates_survey+eu3;
u_sim_ln_at_cons_2004=u_sim_ln_at_cons_2003+[(u_sim_ln_at_cons_2003-u_sim_ln_at_cons_2002) (DATA2004_X-DATA2003_X)]*estimates_survey+eu4;
u_sim_ln_at_cons_2005=u_sim_ln_at_cons_2004+[(u_sim_ln_at_cons_2004-u_sim_ln_at_cons_2003) (DATA2005_X-DATA2004_X)]*estimates_survey+eu5;
u_sim_ln_at_cons_2006=u_sim_ln_at_cons_2005+[(u_sim_ln_at_cons_2005-u_sim_ln_at_cons_2004) (DATA2006_X-DATA2005_X)]*estimates_survey+eu6;
u_sim_ln_at_cons_2007=u_sim_ln_at_cons_2006+[(u_sim_ln_at_cons_2006-u_sim_ln_at_cons_2005) (DATA2007_X-DATA2006_X)]*estimates_survey+eu7;
 
    for j=1:5000
       if MHHID(j)==1
           u_sim_d_ln_at_cons_2001_2000(j)=NaN;
           u_sim_ln_at_cons_2001(j)=NaN;
           u_sim_ln_at_cons_2002(j)=NaN;
           u_sim_ln_at_cons_2003(j)=NaN;
           u_sim_ln_at_cons_2004(j)=NaN;
           u_sim_ln_at_cons_2005(j)=NaN;           
           u_sim_ln_at_cons_2006(j)=NaN;   
           u_sim_ln_at_cons_2007(j)=NaN;   
       end
    end
    
% SIMULATE CONSUMPTION for CONSTRAINED LOWER BOUND
l_sim_d_ln_at_cons_2001_2000=[data2001_X(:,1:9), data2000_X(:,1:9), ones(5000,1)]*beta1+el0;
l_sim_ln_at_cons_2001=[data2001_X(:,1:9), data2000_X(:,1:9), ones(5000,1)]*beta2+el1;
l_sim_ln_at_cons_2002=l_sim_ln_at_cons_2001+[l_sim_d_ln_at_cons_2001_2000 (DATA2002_X-DATA2001_X)]*estimates_survey+el2;
l_sim_ln_at_cons_2003=l_sim_ln_at_cons_2002+[(l_sim_ln_at_cons_2002-l_sim_ln_at_cons_2001) (DATA2003_X-DATA2002_X)]*estimates_survey+el3;
l_sim_ln_at_cons_2004=l_sim_ln_at_cons_2003+[(l_sim_ln_at_cons_2003-l_sim_ln_at_cons_2002) (DATA2004_X-DATA2003_X)]*estimates_survey+el4;
l_sim_ln_at_cons_2005=l_sim_ln_at_cons_2004+[(l_sim_ln_at_cons_2004-l_sim_ln_at_cons_2003) (DATA2005_X-DATA2004_X)]*estimates_survey+el5;
l_sim_ln_at_cons_2006=l_sim_ln_at_cons_2005+[(l_sim_ln_at_cons_2005-l_sim_ln_at_cons_2004) (DATA2006_X-DATA2005_X)]*estimates_survey+el6;
l_sim_ln_at_cons_2007=l_sim_ln_at_cons_2006+[(l_sim_ln_at_cons_2006-l_sim_ln_at_cons_2005) (DATA2007_X-DATA2006_X)]*estimates_survey+el7;
 
    for j=1:5000
       if MHHID(j)==1
           l_sim_d_ln_at_cons_2001_2000(j)=NaN;
           l_sim_ln_at_cons_2001(j)=NaN;
           l_sim_ln_at_cons_2002(j)=NaN;
           l_sim_ln_at_cons_2003(j)=NaN;
           l_sim_ln_at_cons_2004(j)=NaN;
           l_sim_ln_at_cons_2005(j)=NaN;     
           l_sim_ln_at_cons_2006(j)=NaN;  
           l_sim_ln_at_cons_2007(j)=NaN;  
       end
    end
 
U_SIM=[u_sim_ln_at_cons_2002 u_sim_ln_at_cons_2003 u_sim_ln_at_cons_2004 u_sim_ln_at_cons_2005 u_sim_ln_at_cons_2006 u_sim_ln_at_cons_2007];
L_SIM=[l_sim_ln_at_cons_2002 l_sim_ln_at_cons_2003 l_sim_ln_at_cons_2004 l_sim_ln_at_cons_2005 l_sim_ln_at_cons_2006 l_sim_ln_at_cons_2007];
 
sim=[DATA2001(:,2) MHHID DATA2002_Y DATA2003_Y DATA2004_Y DATA2005_Y DATA2006_Y DATA2007_Y U_SIM L_SIM];

a1=5.659266125;

% INDICATE IN POVERTY
pov_sim=[];
pov_sim(:,1:2)=sim(:,1:2);

NAN_BM=sum(isnan(sim));

%under the poverty=0
for i=1:5000
    for j=3:20
        if sim(i,j)<a1
        pov_sim(i,j)=0;
        else
        pov_sim(i,j)=1;
        end
        if isnan(sim(i,j))==1
        pov_sim(i,j)=NaN;  
        end
    end
end

% MATCH SURVEY AND S.DATA
for i=1:5000
    for j=3:8
    if isnan(pov_sim(i,j))+isnan(pov_sim(i,j+6))>0
        pov_sim(i,j)=NaN; 
        pov_sim(i,j+6)=NaN;
        pov_sim(i,j+12)=NaN;
        pov_sim(i,j+18)=NaN;
    end
    end
end

NAN_M=sum(isnan(pov_sim));

% TABLE E9 - 2*2
% FUNCTION (YEAR1, YEAR2, TYPE, filename)
% TYPE: 1-SURVEY, 2-UBOUND, 3-LBOUNDCONSTRAINED, 4-IMPOSING STATIONARITY
% Should block load command in TransitionMatrix4 
 
% CALCULATION TRANSITION MATRIX for SURVEY
[PS, CS, cs]=TransitionMatrix4(2002,2007,1, pov_sim, 5000);

% CALCULATION TRANSITION MATRIX for UBOUND
[PU, CU, cu]=TransitionMatrix4(2002,2007,2, pov_sim, 5000); 

% CALCULATION TRANSITION MATRIX for LBOUND
[PL, CL, cl]=TransitionMatrix4(2002,2007,3, pov_sim, 5000);  

TABLEE9=[100*PS(1,1) 100*PS(1,2);
       100*PU(1,1) 100*PU(1,2);
       100*PL(1,1) 100*PL(1,2);
       100*PS(2,1) 100*PS(2,2);
       100*PU(2,1) 100*PU(2,2);
       100*PL(2,1) 100*PL(2,2);];
   
   
%TABLE E10 - 5*5
for t=1:3
r{t}=quantile(sim(:,3+6*(t-1)), [.20 .40 .60 .80])';
end

quintile_sim=[];
quintile_sim(:,1:2)=sim(:,1:2);
for t=1:3
for i=1:ng
    for j=3:8
        if sim(i,j+6*(t-1))<r{1,t}(1)
        quintile_sim(i,j+6*(t-1))=1;
        elseif sim(i,j+6*(t-1))<r{1,t}(2);
        quintile_sim(i,j+6*(t-1))=2;
        elseif sim(i,j+6*(t-1))<r{1,t}(3);
        quintile_sim(i,j+6*(t-1))=3;
        elseif sim(i,j+6*(t-1))<r{1,t}(4);
        quintile_sim(i,j+6*(t-1))=4;
        elseif sim(i,j+6*(t-1))>=r{1,t}(4)
        quintile_sim(i,j+6*(t-1))=5;  
        else 
        quintile_sim(i,j+6*(t-1))=NaN;
        end
    end
end
end

for i=1:ng
    for j=3:8
    if isnan(quintile_sim(i,j))+isnan(quintile_sim(i,j+6))>0
        quintile_sim(i,j)=NaN; 
        quintile_sim(i,j+6)=NaN;
        quintile_sim(i,j+12)=NaN;
    end
    end
end

% CALCULATION TRANSITION MATRIX for SURVEY
[PSQ,CSQ,csq]=TransitionMatrix5(2002,2007,1, quintile_sim, ng);

% CALCULATION TRANSITION MATRIX for UBOUND
[PUQ,CUQ,cuq]=TransitionMatrix5(2002,2007,2, quintile_sim, ng);

% CALCULATION TRANSITION MATRIX for LBOUND
[PLQ,CLQ,clq]=TransitionMatrix5(2002,2007,3, quintile_sim, ng);  

TABLEE10(:,:)=[PSQ(1,1:5);  PUQ(1,1:5); PLQ(1,1:5); 
                   PSQ(2,1:5);  PUQ(2,1:5); PLQ(2,1:5); 
                   PSQ(3,1:5);  PUQ(3,1:5); PLQ(3,1:5); 
                   PSQ(4,1:5);  PUQ(4,1:5); PLQ(4,1:5); 
                   PSQ(5,1:5);  PUQ(5,1:5); PLQ(5,1:5);];  
    
               
return
 


