function TransitionMatrix3

% #3 PREPARATION/SIMULATION 
% Calculating tau and variance-covariance matrix
% Simultate errors/consumption

% sfddm - zero:analyzed
load Data_sfddm
MHHID=ones(5000,1);
k1=1;
for j1=1:5000
    if missing_sfddm(k1)==j1;
    MHHID(j1,1)=0;
    k1=k1+1;
    else 
        k1=k1;
    end
end

load Data_GMMmain
gamma=estimates_survey(1)

s=1;
for i=1:ng
    ut0{i}=DXY0{i}(:,1)-DXY0{i}(:,2:3)*estimates_survey(1:2);
    ut0{i}(1)=ut0{i}(1)-delta0(3);
    ut0{i}(2)=ut0{i}(2)-delta0(4);
    ut0{i}(3)=ut0{i}(3)-delta0(5);
    ut0{i}(4)=ut0{i}(4)-delta0(6);
    ut0{i}(5)=ut0{i}(5)-delta0(7);
    ut0{i}(6)=ut0{i}(6)-delta0(8);
    % DXY00: (1)Revised HHID (2)year (3)ut0 
    DXY00{i}=[DXY0{i}(:,11) DXY0{i}(:,10) ut0{i}];
       
    d_tau_2002(s,1:2)=[ut0{i}(1,1) missing_sfddm(s)];
    d_tau_2003(s,1:2)=[ut0{i}(2,1) missing_sfddm(s)];
    d_tau_2004(s,1:2)=[ut0{i}(3,1) missing_sfddm(s)];
    d_tau_2005(s,1:2)=[ut0{i}(4,1) missing_sfddm(s)];
    d_tau_2006(s,1:2)=[ut0{i}(5,1) missing_sfddm(s)];
    d_tau_2007(s,1:2)=[ut0{i}(6,1) missing_sfddm(s)];
    s=s+1;
end

clearvars -except ng gamma estimates_survey MHHID d_tau_2002 d_tau_2003 d_tau_2004 d_tau_2005 d_tau_2006 d_tau_2007 

load('Data_varerror')

% Data for initial values by projection
    load('Data_1999_2007');
    sq_hage=hage.*hage;
    % [(1)year (2)hhid (3)ln_at_cons (4)ln_l_at_cons (5)hsize (6)m65 (7)f55
    % (8)hsex (9)hedu (10)seoul (11)nonspouse (12)hage (13)sq_hage ]
    data=[yearV hhid ln_at_cons ln_l_at_cons hsize m65 f55 hsex hedu seoul nonspouse hage sq_hage];
    data(isinf(data))=NaN;
    data=sortrows(data, 2);
    DATA=sortrows(data, 1);

    % DATA generating year by year
    DATA2000 = DATA(5001:10000,:);
    DATA2001 = DATA(10001:15000,:);
    % X: (1)hsize (2)m65 (3)f55 (4)hsex (5)hedu 
    %    (6)seoul (7)nonspouse (8)hage (9)sq_hage 
    data2000_X=DATA2000(:,5:13);
    data2001_X=DATA2001(:,5:13);
    clear data DATA DATA2000 DATA2001; % only data2000_X and data2001_X remain
    
%Main data
% column description 
% [(1)year (2)hhid (3)ln_at_cons (4)ln_l_at_cons (5)hsize 
% (6)d02 (7)d03 (8)d04 (9)d05 (10)d06 (11)d07
% (12)l2_is_head (13)l3_is_head (14)l_is_head ]

data=[yearV hhid ln_at_cons ln_l_at_cons hsize d02 d03 d04 d05 d06 d07 l2_is_head l3_is_head l_is_head]; 
data(isinf(data))=NaN;
data=sortrows(data, 2);
DATA=sortrows(data, 1);
% clear colheaders data textdata;

% DATA generating year by year
DATA1999 = DATA(1:5000,:);
DATA2000 = DATA(5001:10000,:);
DATA2001 = DATA(10001:15000,:);
DATA2002 = DATA(15001:20000,:);
DATA2003 = DATA(20001:25000,:);
DATA2004 = DATA(25001:30000,:);
DATA2005 = DATA(30001:35000,:);
DATA2006 = DATA(35001:40000,:);
DATA2007 = DATA(40001:45000,:);

% DATA generating X, Y, LAG OF Y
DATA1999_Y=DATA1999(:,3);
DATA2000_Y=DATA2000(:,3);
DATA2001_Y=DATA2001(:,3);
DATA2002_Y=DATA2002(:,3);
DATA2003_Y=DATA2003(:,3);
DATA2004_Y=DATA2004(:,3);
DATA2005_Y=DATA2005(:,3);
DATA2006_Y=DATA2006(:,3);
DATA2007_Y=DATA2007(:,3);

DATA1999_LAGY=DATA1999(:,4);
DATA2000_LAGY=DATA2000(:,4);
DATA2001_LAGY=DATA2001(:,4);
DATA2002_LAGY=DATA2002(:,4);
DATA2003_LAGY=DATA2003(:,4);
DATA2004_LAGY=DATA2004(:,4);
DATA2005_LAGY=DATA2005(:,4);
DATA2006_LAGY=DATA2006(:,4);
DATA2007_LAGY=DATA2007(:,4);

% X: (1)hsize (2)d02 (3)d03 (4)d04 (5)d05 (6)d06 (7)d07
DATA1999_X=DATA1999(:,5:11);
DATA2000_X=DATA2000(:,5:11);
DATA2001_X=DATA2001(:,5:11);
DATA2002_X=DATA2002(:,5:11);
DATA2003_X=DATA2003(:,5:11);
DATA2004_X=DATA2004(:,5:11);
DATA2005_X=DATA2005(:,5:11);
DATA2006_X=DATA2006(:,5:11);
DATA2007_X=DATA2007(:,5:11);



% PROJECTION
% FIRST INITIAL CONDITION
% DATA
D_DATA2001_Y=DATA2001_Y-DATA2000_Y;
XX1=[DATA2001(:,2), MHHID, D_DATA2001_Y, data2001_X(:,1:9), data2000_X(:,1:9) ones(5000,1)];
X1=XX1;

N1=length(X1);
k2=1;
while k2<N1  
    if X1(k2,2)==1
    X1(k2,:)=[];
    N1=length(X1);
    else
    k2=k2+1;
    end
end;
 
X1(any(isnan(X1),2),:) = [];
N1=length(X1)
 
res0forres1=X1(:,1); % to match res0 and res1 later /hhid
Y1=X1(:,3);
X1(:,1:3)=[];
K1=size(X1,2);

% OLS regression
beta1=inv(X1'*X1)*X1'*Y1
res0=Y1-X1*beta1;
std1=diag(((res0'*res0)./(N1-K1))*inv(X1'*X1));

v_psi0=var(res0)
v_zeta0=var(res0)-2*var_me2

res0=[res0 res0forres1];


% SECOND INITIAL CONDITION
XX2=[DATA2001(:,2), MHHID, DATA2001_Y, data2001_X(:,1:9), data2000_X(:,1:9),  ones(5000,1)];
X2=XX2;

N2=length(X2);
k3=1;
while k3<N2  
    if X2(k3,2)==1
    X2(k3,:)=[];
    N2=length(X2);
    else
    k3=k3+1;
    end
end;

X2(any(isnan(X2),2),:) = [];
N2=length(X2)

res1forres0=X2(:,1); % to match res0 and res1 later /hhid
Y2=X2(:,3);
X2(:,1:3)=[];
K2=size(X2,2);

% OLS regression
beta2=inv(X2'*X2)*X2'*Y2
res1=Y2-X2*beta2;
std2=diag(((res1'*res1)./(N2-K2))*inv(X2'*X2));

v_psi1=var(res1)
ubound=v_psi1-var_me2

res1=[res1 res1forres0];

% SAMPLE MATCH WITH TAU AND RES
s=1;
tau_2_1=zeros(ng,4);
for i=1:ng
    if d_tau_2002(i,2)==res0(s,2)
       tau_2_1(i,:)=[d_tau_2002(i,:) res0(s,:)];
       s=s+1;
    else
       tau_2_1(i,:)=[d_tau_2002(i,:) NaN NaN];
    end  
end

tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov0=cov(tau_2_1(:,1),tau_2_1(:,3));

s=1;
tau_2_1=zeros(ng,4);
for i=1:ng
    if d_tau_2002(i,2)==res1(s,2)
       tau_2_1(i,:)=[d_tau_2002(i,:) res1(s,:)];
       s=s+1;
    else
       tau_2_1(i,:)=[d_tau_2002(i,:) NaN NaN];
    end  
end

tau_2_1(any(isnan(tau_2_1),2),:)=[];
cov1=cov(tau_2_1(:,1),tau_2_1(:,3));

E_zeta0_derr =(1+2*gamma)*var_me2+cov0(1,2)
E_zeta1_derr =(1+gamma)*var_me2+cov1(1,2)

% COV PROJECTION ERRORS: zeta0 and zeta1
% sample match
k4=5000;
for j=1:k4
    if res0(j,2)<res1(j,2)
    res0(j,:)=[];
    end 
    if res0(j,2)>res1(j,2)
    res1(j,:)=[];
    end
    k4=max(size(res0,1), size(res1,1));
    if (res0(j,2)==5000 || res1(j,2)==5000)
        break
    end
end

res00=[res0(:,1) res1(:,1) res0(:,2) res1(:,2)]; % matching check
res=[res0(:,1) res1(:,1)];
C_res=cov(res)
C_zeta0_zeta1=C_res(1,2)-var_me2


 
% CHECK POSITIVE SEMIDEFINITE
COVMU=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 ubound          E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
du = eig(COVMU) 
 
 
% Positive semidefinite
for x1= 0.0100:0.0001:ubound
 
COVML=[v_zeta0       C_zeta0_zeta1   E_zeta0_derr       0                 0                0                0                 0;
       C_zeta0_zeta1 x1              E_zeta1_derr       0                 0                0                0                 0;
       E_zeta0_derr  E_zeta1_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
       0             0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
       0             0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
       0             0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
       0             0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
       0             0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
 
dl = eig(COVML); 
 
if min(dl)>0
    break
end
   
end
 
x1
[V, D]= eig(COVML) 
 
% check whether the 7*7 positive definite matrix
COVML77=[v_zeta0         E_zeta0_derr       0                 0                0                0                 0;
         E_zeta0_derr    var_u+2*var_equ    (-1)*var_equ      0                0                0                 0;
         0               (-1)*var_equ       var_u+2*var_equ  (-1)*var_equ      0                0                 0;  
         0               0                  (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ      0                 0;
         0               0                  0                (-1)*var_equ     var_u+2*var_equ  (-1)*var_equ       0;
         0               0                  0                 0               (-1)*var_equ      var_u+2*var_equ   (-1)*var_equ;
         0               0                  0                 0                0               (-1)*var_equ       var_u+2*var_equ];
dl77 = eig(COVML77)
 
 
 
% SIMULATE ERRORS FROM NORMAL DISTRIBUTION
mu=[0 0 0 0 0 0 0 0 ];
mu77=[0 0 0 0 0 0 0 ];
error_u = mvnrnd(mu,COVMU,5000);
error_l = mvnrnd(mu,COVML,5000);
error_l77 = mvnrnd(mu77,COVML77,5000);
 
zeta1=NaN(5000,1);
zeta1=(1/(V(2,1))) * (-1) *(V(1,1)*error_l77(:,1)+V(3,1)*error_l77(:,2)+V(4,1)*error_l77(:,3)+V(5,1)*error_l77(:,4)+V(6,1)*error_l77(:,5)+V(7,1)*error_l77(:,6)+V(8,1)*error_l77(:,7));
error_l=[error_l77(:,1) zeta1 error_l77(:,2:7)];
 
% SIMULATE CONSUMPTION for UPPER BOUND 
u_sim_d_ln_at_cons_2001_2000=[data2001_X(:,1:9), data2000_X(:,1:9), ones(5000,1)]*beta1+error_u(:,1);
u_sim_ln_at_cons_2001=[data2001_X(:,1:9), data2000_X(:,1:9) ones(5000,1)]*beta2+error_u(:,2);
u_sim_ln_at_cons_2002=u_sim_ln_at_cons_2001+[u_sim_d_ln_at_cons_2001_2000 (DATA2002_X-DATA2001_X)]*estimates_survey+error_u(:,3);
u_sim_ln_at_cons_2003=u_sim_ln_at_cons_2002+[(u_sim_ln_at_cons_2002-u_sim_ln_at_cons_2001) (DATA2003_X-DATA2002_X)]*estimates_survey+error_u(:,4);
u_sim_ln_at_cons_2004=u_sim_ln_at_cons_2003+[(u_sim_ln_at_cons_2003-u_sim_ln_at_cons_2002) (DATA2004_X-DATA2003_X)]*estimates_survey+error_u(:,5);
u_sim_ln_at_cons_2005=u_sim_ln_at_cons_2004+[(u_sim_ln_at_cons_2004-u_sim_ln_at_cons_2003) (DATA2005_X-DATA2004_X)]*estimates_survey+error_u(:,6);
u_sim_ln_at_cons_2006=u_sim_ln_at_cons_2005+[(u_sim_ln_at_cons_2005-u_sim_ln_at_cons_2004) (DATA2006_X-DATA2005_X)]*estimates_survey+error_u(:,7);
u_sim_ln_at_cons_2007=u_sim_ln_at_cons_2006+[(u_sim_ln_at_cons_2006-u_sim_ln_at_cons_2005) (DATA2007_X-DATA2006_X)]*estimates_survey+error_u(:,8);
 
    for j=1:5000
       if MHHID(j)==1
           u_sim_d_ln_at_cons_2001_2000(j)=NaN;
           u_sim_ln_at_cons_2001(j)=NaN;
           u_sim_ln_at_cons_2002(j)=NaN;
           u_sim_ln_at_cons_2003(j)=NaN;
           u_sim_ln_at_cons_2004(j)=NaN;
           u_sim_ln_at_cons_2005(j)=NaN;           
           u_sim_ln_at_cons_2006(j)=NaN;   
           u_sim_ln_at_cons_2007(j)=NaN;   
       end
    end
    
% SIMULATE CONSUMPTION for CONSTRAINED LOWER BOUND
l_sim_d_ln_at_cons_2001_2000=[data2001_X(:,1:9), data2000_X(:,1:9), ones(5000,1)]*beta1+error_l(:,1);
l_sim_ln_at_cons_2001=[data2001_X(:,1:9), data2000_X(:,1:9), ones(5000,1)]*beta2+error_l(:,2);
l_sim_ln_at_cons_2002=l_sim_ln_at_cons_2001+[l_sim_d_ln_at_cons_2001_2000 (DATA2002_X-DATA2001_X)]*estimates_survey+error_l(:,3);
l_sim_ln_at_cons_2003=l_sim_ln_at_cons_2002+[(l_sim_ln_at_cons_2002-l_sim_ln_at_cons_2001) (DATA2003_X-DATA2002_X)]*estimates_survey+error_l(:,4);
l_sim_ln_at_cons_2004=l_sim_ln_at_cons_2003+[(l_sim_ln_at_cons_2003-l_sim_ln_at_cons_2002) (DATA2004_X-DATA2003_X)]*estimates_survey+error_l(:,5);
l_sim_ln_at_cons_2005=l_sim_ln_at_cons_2004+[(l_sim_ln_at_cons_2004-l_sim_ln_at_cons_2003) (DATA2005_X-DATA2004_X)]*estimates_survey+error_l(:,6);
l_sim_ln_at_cons_2006=l_sim_ln_at_cons_2005+[(l_sim_ln_at_cons_2005-l_sim_ln_at_cons_2004) (DATA2006_X-DATA2005_X)]*estimates_survey+error_l(:,7);
l_sim_ln_at_cons_2007=l_sim_ln_at_cons_2006+[(l_sim_ln_at_cons_2006-l_sim_ln_at_cons_2005) (DATA2007_X-DATA2006_X)]*estimates_survey+error_l(:,8);
 
    for j=1:5000
       if MHHID(j)==1
           l_sim_d_ln_at_cons_2001_2000(j)=NaN;
           l_sim_ln_at_cons_2001(j)=NaN;
           l_sim_ln_at_cons_2002(j)=NaN;
           l_sim_ln_at_cons_2003(j)=NaN;
           l_sim_ln_at_cons_2004(j)=NaN;
           l_sim_ln_at_cons_2005(j)=NaN;     
           l_sim_ln_at_cons_2006(j)=NaN;  
           l_sim_ln_at_cons_2007(j)=NaN;  
       end
    end
 
U_SIM=[u_sim_ln_at_cons_2002 u_sim_ln_at_cons_2003 u_sim_ln_at_cons_2004 u_sim_ln_at_cons_2005 u_sim_ln_at_cons_2006 u_sim_ln_at_cons_2007];
L_SIM=[l_sim_ln_at_cons_2002 l_sim_ln_at_cons_2003 l_sim_ln_at_cons_2004 l_sim_ln_at_cons_2005 l_sim_ln_at_cons_2006 l_sim_ln_at_cons_2007];
 
sim=[DATA2001(:,2) MHHID DATA2002_Y DATA2003_Y DATA2004_Y DATA2005_Y DATA2006_Y DATA2007_Y U_SIM L_SIM];
 
save('SIM_DATA.mat');
 
return
 


