clear
clc
format short;

datestr(now)

randn('state',sum(100*clock));
rand('state',sum(100*clock));  %initialize random number generator

display('Normality Test') 
[ng, I1, I2, DXY0, estimates_survey, VarDelta, delta0]=TransitionMatrix1;
gamma=estimates_survey(1);

%Variance, Skewness, and Kurtosis
%Calculating tau_i
for i=1:ng
    ut0{i}=DXY0{i}(:,1)-DXY0{i}(:,2:3)*estimates_survey(1:2);
    ut0{i}(1)=ut0{i}(1)-delta0(3);
    ut0{i}(2)=ut0{i}(2)-delta0(4);
    ut0{i}(3)=ut0{i}(3)-delta0(5);
    ut0{i}(4)=ut0{i}(4)-delta0(6);
    ut0{i}(5)=ut0{i}(5)-delta0(7);
    ut0{i}(6)=ut0{i}(6)-delta0(8);
    
    % DXY00: (1)Revised HHID (2)year (3)ut0 
    DXY00{i}=[DXY0{i}(:,11) DXY0{i}(:,10) ut0{i}];
    DXY00{i}(1,4)= NaN(1,1);
    DXY00{i}(2,4)= DXY00{i}(1,3);
    DXY00{i}(3,4)= DXY00{i}(2,3);
    DXY00{i}(4,4)= DXY00{i}(3,3);
    DXY00{i}(5,4)= DXY00{i}(4,3);
    DXY00{i}(6,4)= DXY00{i}(5,3);
    
    DXY00{i}(1,5)= NaN(1,1);
    DXY00{i}(2,5)= NaN(1,1);
    DXY00{i}(3,5)= DXY00{i}(2,4);
    DXY00{i}(4,5)= DXY00{i}(3,4);
    DXY00{i}(5,5)= DXY00{i}(4,4);
    DXY00{i}(6,5)= DXY00{i}(5,4); 
    
    DXY00{i}(1,6)= NaN(1,1);
    DXY00{i}(2,6)= NaN(1,1);
    DXY00{i}(3,6)= NaN(1,1);
    DXY00{i}(4,6)= DXY00{i}(3,5);
    DXY00{i}(5,6)= DXY00{i}(4,5);
    DXY00{i}(6,6)= DXY00{i}(5,5);   
    
    %Forward + 1
    DXY00{i}(1,7)= DXY00{i}(2,3);
    DXY00{i}(2,7)= DXY00{i}(3,3);
    DXY00{i}(3,7)= DXY00{i}(4,3);
    DXY00{i}(4,7)= DXY00{i}(5,3);
    DXY00{i}(5,7)= DXY00{i}(6,3);
    DXY00{i}(6,7)= NaN(1,1);   
        
    d_tau{i}=DXY00{i};
end

for i=1:ng
    %d_tau{i}(:,6)=[];
    ut0{i}=d_tau{i};
          
    E{i}=[I1{i} I2{i}];
    
    k1=7; 
    for t=1:6
       if sum(isnan(E{i}(k1-t,:)))>0   
       ut0{i}(k1-t,:)=[];
       end
    end  
end

clear d_tau
 
obs=0;
for i=1:ng
     swi=size(ut0{i},1);
     d_tau_i(obs+1:obs+swi,:)=ut0{i}(:,:);
     obs=size(d_tau_i,1);
end
obs;

ut=d_tau_i(:,3);

% Variance
ut_1=d_tau_i(:,4);
ut_2=d_tau_i(:,5);    
 
ut_ut=ut.*ut;
ut_ut_1=ut.*ut_1;
ut_ut_2=ut.*ut_2;
 
v1=ut_ut;
v2=ut_ut_1;
v3=ut_ut_2;
 
 
w0=nanmean(ut_ut,1);
w1=nanmean(ut_ut_1,1);
w2=nanmean(ut_ut_2,1);

a=[w0;w1;w2];

% G hat
G=[ 0   2*((gamma)^2+gamma+1) 1;
    1   (-1)*((gamma)^2+2*gamma+1) 0;
    0   gamma 0];
 
% b hat
b_hat=inv(G)*a;
sq_b_hat=b_hat.^(1/2);
 
C0=b_hat(1,1);
var_me2=b_hat(2,1);
var_s=b_hat(3,1);

display('Variance var_me var_s ')
[var_me2 var_s]

%Skewness
ut_b1=d_tau_i(:,4);
ut_f1=d_tau_i(:,7);

ut_ut=ut.*ut;
s1=ut_ut.*ut;
s2=ut_ut.*ut_b1;
s3=ut_ut.*ut_f1;

 
sw0=nanmean(s1,1);
sw1=nanmean(s2,1);
sw2=nanmean(s3,1);

a3=[sw0;sw1;sw2];

% S hat
S=[0 (-3).*((gamma.^2)+gamma)      1 ;
   1 (-1).*(gamma.^3)+2.*gamma+1   0 ;
   -1 (gamma.^3)+2.*(gamma.^2)-1     0 ];

% m3 hat
m3_hat=inv(S)*a3;
C1=m3_hat(1);
m3_hat=m3_hat(2:3);

b_hat_s=[var_me2; var_s];
skewN=m3_hat./(b_hat_s.^(3/2));

skew_me2=skewN(1,1);
skew_s=skewN(2,1);

display('Skewness skew_s ')
skew_s

%Kurtosis
ut_ut_ut=ut.*ut.*ut;
k1=ut_ut_ut.*ut;
k2=ut_ut_ut.*ut_b1;
k3=ut_ut_ut.*ut_f1;
k4=ut.*ut.*ut_1.*ut_1;

k1(any(isnan(k1),2),:)=[];
%display('ut_ut_ut_ut');
N0=size(k1,1);
 
k2(any(isnan(k2),2),:)=[];
%display('ut_ut_ut_utb1');
N1=size(k2,1);
 
k3(any(isnan(k3),2),:)=[];
%display('ut_ut_ut_utf1');
N2=size(k3,1);

k4(any(isnan(k4),2),:)=[];
%display('ut_ut_ut_utf1');
N3=size(k4,1);

r10=var_me2.*var_me2.*( 6.*(gamma.^4)+12.*(gamma.^3)+ 18.*(gamma.^2)+12.*gamma+6 );
r11=r10+12.*var_me2.*var_s*((gamma.^2)+gamma+1);
r1=r11;

r20=(-1).*var_me2.*var_me2.*(3.*(gamma.^4)+12.*(gamma.^3)+15.*(gamma.^2)+9.*gamma+3);
r21=r20+(-1).*var_me2.*var_s.*(3.*(gamma.^2)+6.*gamma+3);
r22=r21+C0.*var_me2.*(6.*(gamma.^2)+6.*gamma+6);
r2=r22;

r30=(-1).*var_me2.*var_me2.*(3.*(gamma.^4)+9.*(gamma.^3)+15.*(gamma.^2)+12.*gamma+3);
r31=r30+(-1).*var_me2.*var_s.*(3.*(gamma.^2)+6.*gamma+3);
r32=r31+C0.*var_me2.*(6.*(gamma.^2)+6.*gamma+6);
r3=r32;

r40=var_me2.*var_me2.*(3.*(gamma.^4)+10.*(gamma.^3)+18.*(gamma.^2)+10.*gamma+3);
r41=r40+var_s.*var_s;
r42=r41+var_me2.*var_s.*(4.*(gamma.^2)+4.*gamma+4);
r43=r42+(-1).*C0.*var_me2.*(4.*(gamma.^2)+8.*gamma+4);
r4=r43;


kw0=nanmean(k1,1)-r1;
kw1=nanmean(k2,1)-r2;
kw2=nanmean(k3,1)-r3;
kw3=nanmean(k4,1)-r4;

a4=[kw0;kw1;kw2;kw3];

% K hat
K=[ 0   2.*(gamma.^4)+4.*(gamma.^3)+6.*(gamma.^2)+4.*gamma+2           1;
    1   (-1).*( (gamma.^4)+2.*(gamma.^3)+3.*(gamma.^2)+3.*gamma+1 )    0;
    1   (-1).*( (gamma.^4)+3.*(gamma.^3)+3.*(gamma.^2)+2.*gamma+1 )    0;
    0   (gamma.^4)+2.*(gamma.^3)+2.*(gamma.^2)+2.*gamma+1              0];                                                   

% m4 hat
m4_hat=inv(K'*K)*K'*a4;
C2=m4_hat(1);
m4_hat=m4_hat(2:3);

excessK=(m4_hat./(b_hat_s.^2))-3*ones(2,1);

display('ExcessKutosis eK_s ')
excessK(2)


% Third and Fourth Moments for projection errors
load('SIM_DATA.mat', 'res0', 'res1', 'v_zeta0', 'V','ubound','x1','var_equ','var_u');

res00=res0(:,1);
res01=res1(:,1);

%projection error 0
m03_hat=mean(res00.^3);
skew0=m03_hat./(v_zeta0.^(3/2));
m04_hat=mean(res00.^4)-2*m4_hat(1)-12*var_me2*v_zeta0-6*var_me2*var_me2;
excessK0=(m04_hat./(v_zeta0.^2))-3*ones(1,1);

display('proj0 skew   EK')
[skew0 excessK0]

%projection error 1/upper bound
m13u_hat=mean(res01.^3)-m3_hat(1);
skew1u=m13u_hat./(ubound.^(3/2));
m14u_hat=mean(res01.^4)-m4_hat(1)-6*var_me2*ubound; 
excessK1u=(m14u_hat./(ubound.^2))-3*ones(1,1);

display('proj1upper skew   EK')
[skew1u excessK1u]

%projection error 1/lower bound
c0=V(1,1); c1=V(2,1); c2=V(3,1); c3=V(4,1);
c4=V(5,1); c5=V(6,1); c6=V(7,1); c7=V(8,1);

m13l_hat0=(-1)*(c0^3)*m03_hat + ((c2^3)+(c3^3)+(c4^3)+(c5^3)+(c6^3)+(c7^3))*m3_hat(2); 
m13l_hat1=m13l_hat0+3*C1*(c2*(c3^2)+c3*(c4^2)+c4*(c5^2)+c5*(c6^2)+c6*(c7^2)+(-1)*((c2^2)*c3+(c3^2)*c4+(c4^2)*c5+(c5^2)*c6+(c6^2)*c7));
m13l_hat=(1/(c1^3))*m13l_hat1;
skew1l=m13l_hat./(x1.^(3/2));

cc0=    (c0^2)*((c2^2)+(c3^2)+(c4^2)+(c5^2)+(c6^2)+(c7^2));
cc1=cc0+(c2^2)*((c3^2)+(c4^2)+(c5^2)+(c6^2)+(c7^2));
cc2=cc1+(c3^2)*((c4^2)+(c5^2)+(c6^2)+(c7^2));
cc3=cc2+(c4^2)*((c5^2)+(c6^2)+(c7^2));
cc4=cc3+(c5^2)*((c6^2)+(c7^2));
cc =cc4+(c6^2)*((c7^2));

m14l_hat0=(c0^4)*m04_hat +((c2^4)+(c3^4)+(c4^4)+(c5^4)+(c6^4)+(c7^4))*m4_hat(2);
m14l_hat1=m14l_hat0+6*v_zeta0*var_s*(c0^2)*((c2^2)+(c3^2)+(c4^2)+(c5^2)+(c6^2)+(c7^2));
m14l_hat2=m14l_hat1+6*var_s*var_s*cc;
m14l_hat3=m14l_hat2+4*C2*( (c2^3)*c3+(c3^3)*c4+(c4^3)*c5+(c5^3)*c6+(c6^3)*c7 +c2*(c3^3)+c3*(c4^3)+c4*(c5^3)+c5*(c6^3)+c6*(c7^3));
m14l_hat4=m14l_hat3+12*C0*v_zeta0*(c0^2)*(c2*c3+c3*c4+c4*c5+c5*c6+c6*c7);
m14l_hat5=m14l_hat4+12*((-2)*var_equ*var_equ-var_equ*var_u)*((c2^2)*c3*c4+(c3^2)*c4*c5+(c4^2)*c5*c6+(c5^2)*c6*c7+c2*c3*(c4^2)+c3*c4*(c5^2)+c4*c5*(c6^2)+c5*c6*(c7^2));
m14l_hat6=m14l_hat5+12*2*var_equ*var_equ*(c2*(c3^2)*c4+c3*(c4^2)*c5+c4*(c5^2)*c6+c5*(c6^2)*c7);
m14l_hat=(1/(c1^4))*m14l_hat6; 
excessK1l=(m14l_hat./(x1.^2))-3*ones(1,1);
display('proj1lower skew   EK')
[skew1l excessK1l]

errorM=[var_s skew_s excessK(2); 
        v_zeta0 skew0 excessK0; 
        ubound skew1u excessK1u; 
        x1 skew1l excessK1l];

save('Data_skerror','errorM')

load('ESK_BSresult_1000')

%Variance
VmO=[var_me2, var_s];
VdevO=(var_errors(:,4:5)-ones(B,1)*VmO)';
VsO=zeros(2,2);

for i=1:B
VsO=VsO+VdevO(:,i)*VdevO(:,i)';
end

VsO=(1/(B-1))*VsO;
SEO=[var_me2, var_s;
     VsO(1,1).^(1/2) VsO(2,2).^(1/2)
     var_me2./(VsO(1,1).^(1/2)) var_s./(VsO(2,2).^(1/2))]
 
%Skewness
SmO=[skewN(1), skewN(2)];
SdevO=(var_errors(:,6:7)-ones(B,1)*SmO)';

SsO=zeros(2,2);

for i=1:B
SsO=SsO+SdevO(:,i)*SdevO(:,i)';
end

SsO=(1/(B-1))*SsO;
SSEO=[ skewN(2);
     SsO(2,2).^(1/2)
    skewN(2)./(SsO(2,2).^(1/2)) ]
 
%Kurtosis
KmO=[excessK(1), excessK(2)];
KdevO=(var_errors(:,8:9)-ones(B,1)*KmO)';

KsO=zeros(2,2);

for i=1:B
KsO=KsO+KdevO(:,i)*KdevO(:,i)';
end

KsO=(1/(B-1))*KsO;
KSEO=[ excessK(2);
      KsO(2,2).^(1/2)
     excessK(2)./(KsO(2,2).^(1/2))]
 
%projection error 0
P0=[skew0 excessK0];
P0devO=(var_errors(:,10:11)-ones(B,1)*P0)';

P0O=zeros(2,2);

for i=1:B
P0O=P0O+P0devO(:,i)*P0devO(:,i)';
end

P0O=(1/(B-1))*P0O;
P0SEO=[skew0 excessK0;
     P0O(1,1).^(1/2) P0O(2,2).^(1/2)
     skew0./(P0O(1,1).^(1/2)) excessK0./(P0O(2,2).^(1/2))]

%projection error 1/upper bound 
P1u=[skew1u excessK1u];
P1udevO=(var_errors(:,12:13)-ones(B,1)*P1u)';

P1uO=zeros(2,2);

for i=1:B
P1uO=P1uO+P1udevO(:,i)*P1udevO(:,i)';
end

P1uO=(1/(B-1))*P1uO;
P1uSEO=[skew1u excessK1u;
     P1uO(1,1).^(1/2) P1uO(2,2).^(1/2)
     skew1u./(P1uO(1,1).^(1/2)) excessK1u./(P1uO(2,2).^(1/2))]

%projection error 1/lower bound
P1l=[skew1l excessK1l];
P1ldevO=(var_errors(:,14:15)-ones(B,1)*P1l)';

P1lO=zeros(2,2);

for i=1:B
P1lO=P1lO+P1ldevO(:,i)*P1ldevO(:,i)';
end

P1lO=(1/(B-1))*P1lO;
P1lSEO=[skew1l excessK1l;
     P1lO(1,1).^(1/2) P1lO(2,2).^(1/2)
     skew1l./(P1lO(1,1).^(1/2)) excessK1l./(P1lO(2,2).^(1/2))]

[equ0,type]= pearsrnd(0,v_zeta0^(1/2),skew0,excessK0+3,5000,1);
type0=type
[equ1,type]=pearsrnd(0,ubound^(1/2),skew1u,excessK1u+3,5000,1);
type1u=type
[equ2,type]=pearsrnd(0,x1^(1/2),skew1l,excessK1l+3,5000,1); 
type1l=type
 

  
