% Tests
% OLS estimation for F test

function [F, Pval]=TransitionMatrix1b

display('TransitionMatrix1b**********************') 
load Data_GMMmain;

for i=1:ng

    XY2001(i,:)=[DXY0{i}(1,2) I2{i}(1,1:5)];
    XY2002(i,:)=[DXY0{i}(2,2) I2{i}(2,6:11)];
    XY2003(i,:)=[DXY0{i}(3,2) I2{i}(3,12:18)];
    XY2004(i,:)=[DXY0{i}(4,2) I2{i}(4,19:26)];
    XY2005(i,:)=[DXY0{i}(5,2) I2{i}(5,27:35)];
    XY2006(i,:)=[DXY0{i}(6,2) I2{i}(6,36:45)];
        
end

XY2001=XY2001(~any(isnan(XY2001),2),:);
XY2002=XY2002(~any(isnan(XY2002),2),:);
XY2003=XY2003(~any(isnan(XY2003),2),:);
XY2004=XY2004(~any(isnan(XY2004),2),:);
XY2005=XY2005(~any(isnan(XY2005),2),:);
XY2006=XY2006(~any(isnan(XY2006),2),:);

y2001=XY2001(:,1);
y2002=XY2002(:,1);
y2003=XY2003(:,1);
y2004=XY2004(:,1);
y2005=XY2005(:,1);
y2006=XY2006(:,1);
 
X2001=XY2001(:,2:6);
X2002=XY2002(:,2:7);
X2003=XY2003(:,2:8);
X2004=XY2004(:,2:9);
X2005=XY2005(:,2:10);
X2006=XY2006(:,2:11);

%disp('OLS 2001');
[betahat0, stebeta0, sigmasqhat0, t, n, df]=ZOLS(y2001,X2001);
[betahat0, stebeta0, t];
k=size(X2001,2);
R01=[zeros(3,1) [1;0;0] zeros(3,1) [0;1;0] [0;0;1]];
F01=(1/(k-2))*(R01*betahat0)'*inv(sigmasqhat0*[R01*inv(X2001'*X2001)*R01'])*(R01*betahat0);
p_Ftest01=1-fcdf(F01,k-2,n-k);

%disp('OLS 2002');
[betahat0, stebeta0, sigmasqhat0, t, n, df]=ZOLS(y2002,X2002);
[betahat0, stebeta0, t];
k=size(X2002,2);
R02=[zeros(4,1) [1;0;0;0] [0;1;0;0] zeros(4,1) [0;0;1;0] [0;0;0;1]];
F02=(1/(k-2))*(R02*betahat0)'*inv(sigmasqhat0*[R02*inv(X2002'*X2002)*R02'])*(R02*betahat0);
p_Ftest02=1-fcdf(F02,k-2,n-k);

%disp('OLS 2003');
[betahat0, stebeta0, sigmasqhat0, t, n, df]=ZOLS(y2003,X2003);
[betahat0, stebeta0, t];
k=size(X2003,2);
R03=[zeros(5,1) [1;0;0;0;0] [0;1;0;0;0] [0;0;1;0;0] zeros(5,1) [0;0;0;1;0] [0;0;0;0;1]];
F03=(1/(k-2))*(R03*betahat0)'*inv(sigmasqhat0*[R03*inv(X2003'*X2003)*R03'])*(R03*betahat0);
p_Ftest03=1-fcdf(F03,k-2,n-k);

%disp('OLS 2004');
[betahat0, stebeta0, sigmasqhat0, t, n, df]=ZOLS(y2004,X2004);
[betahat0, stebeta0, t];
k=size(X2004,2);
R04=[zeros(6,1) [1;0;0;0;0;0] [0;1;0;0;0;0] [0;0;1;0;0;0] [0;0;0;1;0;0] zeros(6,1) [0;0;0;0;1;0] [0;0;0;0;0;1]];
F04=(1/(k-2))*(R04*betahat0)'*inv(sigmasqhat0*[R04*inv(X2004'*X2004)*R04'])*(R04*betahat0);
p_Ftest04=1-fcdf(F04,k-2,n-k);

%disp('OLS 2005');
[betahat0, stebeta0, sigmasqhat0, t, n, df]=ZOLS(y2005,X2005);
[betahat0, stebeta0, t];
k=size(X2005,2);
R05=[zeros(7,1) [1;0;0;0;0;0;0] [0;1;0;0;0;0;0] [0;0;1;0;0;0;0] [0;0;0;1;0;0;0] [0;0;0;0;1;0;0] zeros(7,1) [0;0;0;0;0;1;0] [0;0;0;0;0;0;1]];
F05=(1/(k-2))*(R05*betahat0)'*inv(sigmasqhat0*[R05*inv(X2005'*X2005)*R05'])*(R05*betahat0);
p_Ftest05=1-fcdf(F05,k-2,n-k);

%disp('OLS 2006');
[betahat0, stebeta0, sigmasqhat0, t, n, df]=ZOLS(y2006,X2006);
[betahat0, stebeta0, t];
k=size(X2006,2);
R06=zeros(8,10);
R06(1,2)=1;
R06(2,3)=1;
R06(3,4)=1;
R06(4,5)=1;
R06(5,6)=1;
R06(6,7)=1;
R06(7,9)=1;
R06(8,10)=1;
R06;
F06=(1/(k-2))*(R06*betahat0)'*inv(sigmasqhat0*[R06*inv(X2006'*X2006)*R06'])*(R06*betahat0);
p_Ftest06=1-fcdf(F06,k-2,n-k);

F=[F01, F02, F03, F04, F05, F06];
Pval=[p_Ftest01,p_Ftest02,p_Ftest03,p_Ftest04,p_Ftest05,p_Ftest06];

return