function TransitionMatrix0

clear
clc
format short;

datestr(now)

randn('state',sum(100*clock));
rand('state',sum(100*clock));  %initialize random number generator

%Two step GMM estimation
display('TransitionMatrix1**********************') 
[ng, I1, I2, DXY0, estimates_survey, VarDelta, delta0]=TransitionMatrix1;
save('Data_GMMmain')
input('Press Enter to continue.')

%Calculating tau_i
for i=1:ng
    ut0{i}=DXY0{i}(:,1)-DXY0{i}(:,2:3)*estimates_survey(1:2);
    ut0{i}(1)=ut0{i}(1)-delta0(3);
    ut0{i}(2)=ut0{i}(2)-delta0(4);
    ut0{i}(3)=ut0{i}(3)-delta0(5);
    ut0{i}(4)=ut0{i}(4)-delta0(6);
    ut0{i}(5)=ut0{i}(5)-delta0(7);
    ut0{i}(6)=ut0{i}(6)-delta0(8);
    
    % DXY00: (1)Revised HHID (2)year (3)ut0 
    DXY00{i}=[DXY0{i}(:,11) DXY0{i}(:,10) ut0{i}];
    DXY00{i}(1,4)= NaN(1,1);
    DXY00{i}(2,4)= DXY00{i}(1,3);
    DXY00{i}(3,4)= DXY00{i}(2,3);
    DXY00{i}(4,4)= DXY00{i}(3,3);
    DXY00{i}(5,4)= DXY00{i}(4,3);
    DXY00{i}(6,4)= DXY00{i}(5,3);
    
    DXY00{i}(1,5)= NaN(1,1);
    DXY00{i}(2,5)= NaN(1,1);
    DXY00{i}(3,5)= DXY00{i}(2,4);
    DXY00{i}(4,5)= DXY00{i}(3,4);
    DXY00{i}(5,5)= DXY00{i}(4,4);
    DXY00{i}(6,5)= DXY00{i}(5,4); 
    
    DXY00{i}(1,6)= NaN(1,1);
    DXY00{i}(2,6)= NaN(1,1);
    DXY00{i}(3,6)= NaN(1,1);
    DXY00{i}(4,6)= DXY00{i}(3,5);
    DXY00{i}(5,6)= DXY00{i}(4,5);
    DXY00{i}(6,6)= DXY00{i}(5,5);   
    d_tau{i}=DXY00{i};
end

save('Data_tau', 'd_tau')

%Tests
[H, SE, t]=TransitionMatrix1a
input('Press Enter to continue.')
[F, Pval]=TransitionMatrix1b
input('Press Enter to continue.')
[coef_tau, se_tau, t_tau]=TransitionMatrix1c
input('Press Enter to continue.')
[coef_tau1, se_tau1, t_tau1]=TransitionMatrix1d
input('Press Enter to continue.')
[coef_tau2, se_tau2, t_tau2]=TransitionMatrix1e
input('Press Enter to continue.')
[STAT, DF]=TransitionMatrix1f;
input('Press Enter to continue.')

[var_equ, var_me2, var_u]=TransitionMatrix2;
save('Data_varerror', 'var_equ', 'var_me2', 'var_u')
input('Press Enter to continue.')
%Bootstrapping+calculation of s.e. of error variances
TransitionMatrix2a;  
load('EV_BSresult_1000', 'SE')
SE
p_value=TransitionMatrix2b;

display('TransitionMatrix3**********************')
TransitionMatrix3;
input('Press Enter to continue.')
TransitionMatrix3e; 
TransitionMatrix3f;
input('Press Enter to continue.')

%Bootstrapping+calculation of s.e. of error variances
TransitionMatrix2c; 
TransitionMatrix2d;
input('Press Enter to continue.')

clear
clc
load ('SIM_DATA','sim')

% sim=[(1)hhid (2)sfddm 
% (3)survey2002 (4)survey2003 (5)survey2004 (6)survey2005 (7)survey2006 (8)survey 2007 
% (9)u sim2002 (10)u sim2003 (11)u sim2004 (12)u sim2005 (13)u sim2006 (14)u sim2007
% (15)l sim2002 (16)l sim2003 (17)l sim2004 (18)l sim2005 (19) l_sim2006 (20) l_sim2007] ;

a1=5.659266125;

% INDICATE IN POVERTY
pov_sim=[];
pov_sim(:,1:2)=sim(:,1:2);

NAN_BM=sum(isnan(sim));

%under the poverty=0
for i=1:5000
    for j=3:20
        if sim(i,j)<a1
        pov_sim(i,j)=0;
        else
        pov_sim(i,j)=1;
        end
        if isnan(sim(i,j))==1
        pov_sim(i,j)=NaN;  
        end
    end
end

% MATCH SURVEY AND S.DATA
for i=1:5000
    for j=3:8
    if isnan(pov_sim(i,j))+isnan(pov_sim(i,j+6))>0
        pov_sim(i,j)=NaN; 
        pov_sim(i,j+6)=NaN;
        pov_sim(i,j+12)=NaN;
        pov_sim(i,j+18)=NaN;
    end
    end
end

NAN_M=sum(isnan(pov_sim));
save POV_SIM;

% TABLE5 - 2*2
% CALCULATION TRANSITION MATRIX for SURVEY
[PS, CS, cs]=TransitionMatrix4(2002,2007,1, pov_sim, 5000);

% CALCULATION TRANSITION MATRIX for UBOUND
[PU, CU, cu]=TransitionMatrix4(2002,2007,2, pov_sim, 5000); 

% CALCULATION TRANSITION MATRIX for LBOUND
[PL, CL, cl]=TransitionMatrix4(2002,2007,3, pov_sim, 5000);  

TABLE5=[100*PS(1,1) 100*PS(1,2);
       100*PU(1,1) 100*PU(1,2);
       100*PL(1,1) 100*PL(1,2);
       100*PS(2,1) 100*PS(2,2);
       100*PU(2,1) 100*PU(2,2);
       100*PL(2,1) 100*PL(2,2);]
input('Press Enter to continue.')

% TABLE6 - 5*5
for t=1:3
r{t}=quantile(sim(:,3+6*(t-1)), [.20 .40 .60 .80])';
end

quintile_sim=[];
quintile_sim(:,1:2)=sim(:,1:2);
for t=1:3
for i=1:5000
    for j=3:8
        if sim(i,j+6*(t-1))<r{1,t}(1)
        quintile_sim(i,j+6*(t-1))=1;
        elseif sim(i,j+6*(t-1))<r{1,t}(2);
        quintile_sim(i,j+6*(t-1))=2;
        elseif sim(i,j+6*(t-1))<r{1,t}(3);
        quintile_sim(i,j+6*(t-1))=3;
        elseif sim(i,j+6*(t-1))<r{1,t}(4);
        quintile_sim(i,j+6*(t-1))=4;
        elseif sim(i,j+6*(t-1))>=r{1,t}(4)
        quintile_sim(i,j+6*(t-1))=5;  
        else 
        quintile_sim(i,j+6*(t-1))=NaN;
        end
    end
end
end

for i=1:5000
    for j=3:8
    if isnan(quintile_sim(i,j))+isnan(quintile_sim(i,j+6))>0
        quintile_sim(i,j)=NaN; 
        quintile_sim(i,j+6)=NaN;
        quintile_sim(i,j+12)=NaN;
    end
    end
end

% CALCULATION TRANSITION MATRIX for SURVEY
[PSQ,CSQ,csq]=TransitionMatrix5(2002,2007,1,  quintile_sim, 5000);

% CALCULATION TRANSITION MATRIX for UBOUND
[PUQ,CUQ,cuq]=TransitionMatrix5(2002,2007,2,  quintile_sim, 5000);

% CALCULATION TRANSITION MATRIX for LBOUND
[PLQ,CLQ,clq]=TransitionMatrix5(2002,2007,3,  quintile_sim, 5000);  

TABLE5=[PSQ(1,1:5);  PUQ(1,1:5); PLQ(1,1:5); 
        PSQ(2,1:5);  PUQ(2,1:5); PLQ(2,1:5); 
        PSQ(3,1:5);  PUQ(3,1:5); PLQ(3,1:5); 
        PSQ(4,1:5);  PUQ(4,1:5); PLQ(4,1:5); 
        PSQ(5,1:5);  PUQ(5,1:5); PLQ(5,1:5);]
input('Press Enter to continue.')

TransitionMatrix6 

% Table E9 and E10
[TABLEE9,TABLEE10]=TransitionMatrix3a
input('Press Enter to continue.')
TransitionMatrix3c 
[STABLEE9,STABLEE10]=TransitionMatrix3d
input('Press Enter to continue.')

% Table 1, 4, E5, E6
TransitionMatrix7
input('Press Enter to continue.')

% Table E11
TransitionMatrix8
input('Press Enter to continue.')

% Table E7 and E8
TransitionMatrix9

return



      

