%% Code for Granger Causality test for the LP-IV/SVAR-IV models
% AKL August 2018 (modified code of Stock & Watson 2018)

%% preliminaries
clear; tic;
%addpath(genpath('C:\Class Stuff\Research\High_Frequency_Monetary_Policy\Code\Others_Code\Stock_Watson_2018'));
addpath(genpath('auxfiles\'));
%rng(284118); %rng(1);

%% set the sample dates
for fold_sample = 1:1

start_date = datenum('7\1\1979');
end_date = datenum('12\1\2011');

nfirst_var_y = [year(start_date) month(start_date)];
nlast_var_y =  [year(end_date) month(end_date)];

end


%% Load the data

% Pick daily or 30 mins futures data
fut = 'daily'; %'daily'; %; %; % '30min'

load 'Results\all_forinv_data.mat';

     % loads matrix allvars
    % 1)yr, 2)month, 3)day 4)1yr, 5)ffr 6)ln_cpi 7)ln_ip 8)ebp 9)pcom
    % 10)unrate 11)target factor  12)path factor
    
    gs1 = allvars(:,4);
    ffr = allvars(:,5);
    ln_cpi = allvars(:,6);
    ln_ip = allvars(:,7);
    ebp = allvars(:,8);
    pcom = allvars(:,9);
    unrate = allvars(:,10);
    target_factor = allvars(:,11);
    path_factor = allvars(:,12);
    
    dates = datenum(allvars(:,1:3));
    dates_dv = datevec(datenum(allvars(:,1:3)));
    
    %[dnobs,calvec,calds] = calendar_make([1979 7],[2011 12],12);
    [dnobs,calvec,calds] = calendar_make(nfirst_var_y,nlast_var_y,12);



%% Pick the variables, instrument and set effective sample

y = [gs1 ln_ip ln_cpi ffr];


z = path_factor;


start = find(dates==start_date);
finish = find(dates==end_date);

yeff = y(start:finish,:);
zeff = z(start:finish,:);

%yeff = y;
%zeff = z;
[Teff,n] = size(yeff);


%% Granger Causality Test

nvar_lag_y = 12;

nvar_lag_zs = 2:2:8;
%nvar_lag_zs = 4;
pvals = NaN(length(nvar_lag_zs),size(yeff,2));
for kk = 1:length(nvar_lag_zs)
    nvar_lag_z = nvar_lag_zs(kk);

% Form Regressors
%zreg = zeff;
yreg = yeff;
xreg = ones(Teff,1); %xreg = NaN(Teff,n*nvar_lag_y+1);    
    
% Lagged ys
for ilag = 1:nvar_lag_y
    xreg = [xreg lag(yreg,ilag)];
end

% Lagged zs
zreg = lag(zeff,1);
for ilag = 2:nvar_lag_z
    zreg = [zreg lag(zeff,ilag)];
end

%tmp = [yreg zreg xreg];
%tmp = packr(tmp);

% Get sample period
tmp = [calvec yreg zreg xreg];
ismpl = smpl(calvec,nfirst_var_y,nlast_var_y,12);
tmp = tmp(ismpl==1,:);
% Eliminate missing values
tmp = packr(tmp);


ii=1;   
yreg_est = tmp(:,ii+1:ii+size(yreg,2));
ii = ii+size(yreg,2);
zreg_est = tmp(:,ii+1:ii+size(zreg,2));
ii = ii+size(zreg,2);
xreg_est = tmp(:,ii+1:ii+size(xreg,2));
ii = ii+size(xreg,2);

% Run Regressions:
nz = size(zreg,2);
xr = [zreg_est xreg_est];
gc_z_pvalue = zeros(1,size(yreg,2));
for i = 1:size(yreg,2)
    [b,v,se,ser,r2]=hac_ols(yreg_est(:,i),xr,0,1);
    be = b(1:nz);
    vbe = v(1:nz,1:nz);
    vbeinv = inv(vbe);
    wald = be'*vbeinv*be;
    pv = chi2cdf(wald,nz,'upper');
    gc_z_pvalue(i) = pv;
end

pvals(kk,:) = gc_z_pvalue;
end

pvals