clear
set more off

* "Data_for_Stata_Extended.xlsx" file is in the Results folder

* Load the data from excel file "Data_for_Stata.xlsx" from sheet "TP"
import excel "Data_for_Stata_Extended.xlsx", sheet("TP") firstrow

label var TP1_ffr "FFR residual"
label var TP1_1yr "1 year residual"
label var TP1_Z1 "Target Factor"
label var TP1_Z2 "Path Factor"
label var TP2_Z1 "Target Factor"
label var TP2_Z2 "Path Factor"
label var TP2_ffr "FFR residual"
label var TP2_1yr "2 year residual"

* ssc install outreg2: Need to do this the first time

* Baseline Table
reg TP1_ffr TP1_Z1 TP1_Z2,r
outreg2 using "Table2_", bdec(3) excel replace addstat(Adjusted R-squared, e(r2_a), Robust F-statistic, e(F)) label

reg TP1_1yr TP1_Z1 TP1_Z2,r
outreg2 using "Table2_", bdec(3) excel append addstat(Adjusted R-squared, e(r2_a), Robust F-statistic, e(F)) label

ivreg2 TP2_1yr (TP1_ffr TP1_1yr = TP1_Z1 TP1_Z2), first r


reg TP2_ffr TP2_Z1 TP2_Z2,r
outreg2 using "Table2_", bdec(3) excel append addstat(Adjusted R-squared, e(r2_a), Robust F-statistic, e(F)) label

reg TP2_1yr TP2_Z1 TP2_Z2,r
outreg2 using "Table2_", bdec(3) excel append addstat(Adjusted R-squared, e(r2_a), Robust F-statistic, e(F)) label

ivreg2 TP1_1yr (TP2_ffr TP2_1yr = TP2_Z1 TP2_Z2), first r
