%% This file has the code to replicate the results from "Decomposing the effects of monetary policy using an external instruments SVAR"
% Aeimit Lakdawala

clear; 
addpath(genpath('auxfiles\'));

%% Load the data
% load the macro data    
load 'Data\all_data.mat'  

%% Which specification to run
%%%%%%%%%%%%%% NOTE: ONE SPECIFICATION AT A TIME %%%%%%%%%%%%%%%%%

% spec = 'TP1'; % Baseline specification (Fig 2)
% spec = 'Ext_ffr'; % only ffr as policy tool (left column of Fig 3)
% spec = 'GK_Ext_noEBP'; % only 1 yr as policy tool (right column of Fig 3)
% spec = 'TP1_pvt_res'; % pvt-res path factor (left column of Fig 4)
% spec = 'TP1_pvt_fit'; % pvt-fit path factor (red line in Fig 5)
% spec = 'TP1_intday'; % intraday futures window ( a) in Fig 6 )
% spec = 'TP1_2day'; % two day futures window ( b) in Fig 6 )
% spec = 'TP1_ID2'; % Ident strategy II ( c) in Fig 6 )
% spec = 'TP2'; % 2 yr as policy tool ( d) in Fig 6 )
% spec = 'TP1_prezlb'; % sample ends in 2008 ( e) in Fig 6 )
% spec = 'TP1_statonly'; % Statement days only ( f) in Fig 6 )
% spec = 'TP1_ebp'; % Add EBP to VAR ( g) in Fig 6 )
% spec = 'TP1_post94'; % futures smpl starts in 94 ( h) in Fig 6 )
% spec = 'TP1_noemp'; % drop emp report FOMC dates ( i) in Fig 6 )
% spec = 'TP1_nounsch'; % drop unsched FOMC dates ( j) in Fig 6 )

%% pick the sample dates

% pick the dates for reduced-form estimation
start_date = datenum('7\1\1979');
end_date = datenum('12\1\2011');

VAR.ident = 1; % Identification Scheme
% 1 for Mertens and Ravn restriction on S1
% 2 for direct restriction on phi

%% load the instruments for identification
VAR.ind = [3 4  1 2]; % ffr, 1 yr,  log(cpi), log(ip)   

switch spec
    case 'TP1'
        load 'Instruments\TP1_instr'        
    case 'Ext_ffr'
        load 'Instruments\Ext_ffr_instr'
        VAR.ind = [3 1 2]; % ffr, log(cpi) log(ip) 
    case 'GK_Ext_noEBP'
        load 'Instruments\GK_Ext_noEBP_instr'
        VAR.ind = [4 1 2]; % 1 yr,  log(cpi), log(ip),
    case 'TP1_pvt_res'
        load 'Instruments\TP1_pvt_res_instr'
    case 'TP1_pvt_fit'
        load 'Instruments\TP1_pvt_fit_instr'          
    case 'TP1_intday'
        load 'Instruments\TP1_intday_instr'
    case 'TP1_2day'
        load 'Instruments\TP1_2day_instr'
    case 'TP1_ID2'
        load 'Instruments\TP1_ID2_instr'
        VAR.ident = 2; 
    case 'TP2'
        load 'Instruments\TP2_instr'
    case 'TP1_prezlb'
        load 'Instruments\TP1_prezlb_instr'
        end_date = datenum('1\1\2009');
    case 'TP1_statonly'
        load 'Instruments\TP1_statonly_instr'
    case 'TP1_ebp'
        load 'Instruments\TP1_ebp_instr'
        VAR.ind = [3 4  1 2 9]; % ffr, 1 yr,  log(cpi), log(ip), ebp
    case 'TP1_post94'
        load 'Instruments\TP1_post94_instr'
    case 'TP1_noemp'
        load 'Instruments\TP1_noemp_instr'
    case 'TP1_nounsch'
        load 'Instruments\TP1_nounsch_instr'

end

VAR.proxies = instr.Proxy;
VAR.proxydates = instr.ProxyDates;

start = find(Dataset1.all_dates==start_date);
finish = find(Dataset1.all_dates==end_date);
VAR.dates = Dataset1.all_dates(start:finish);

if ~isempty(VAR.proxies)
    %diff between where VAR and proxies end in the VAR sample
    if VAR.dates(end) == VAR.proxydates(end)
        VAR.T_m_end = 0; %zero if proxies and VAR data have same end date
    elseif VAR.dates(end) > VAR.proxydates(end)
        VAR.T_m_end = length(VAR.dates) - find(VAR.dates == VAR.proxydates(end));
    else
        error('End date for instrument sample cannot be after VAR end date');
    end
end

%% VAR specification details

% Set estimation specifics
VAR.p = 12; % number of lags in VAR
VAR.const = 1; % 0 for no const, 1 for const, 2 for const + time trend
VAR.irhor = 48; % # of periods for impulse responses
VAR.spec = 'unit'; %'unit' or 'std'; % Size of impact shock
do_ci = 1; % confidence intervals
VAR.nboot = 100; 
VAR.clevel = 68;


VAR.ord(1) = 1;

VAR.cimethod = 6; 
% method  1: Mertens and Ravn (2013) wild bootstrap 
%         2: Montiel-Olea Stock Watson (2016) bootstrap
%         3: Delta Method 
%         4: Montiel-Olea Stock Watson (2016) asy weak IV (not for k > 1)
%         5: Jentsch and Lunsford Moving Block Bootstrap
%         6: Jentsch and Lunsford Moving Block Bootstrap w/ adjustment
%         7: Jentsch and Lunsford Moving Blocl Bootstrap for one shock


labels = Dataset1.all_data_labels;
labels{:,1} = 'CPI';
labels{:,2} = 'Industrial Production';
labels{:,3} = 'Fed Funds Rate';
labels{:,4} = '1 Year Rate';
labels{:,5} = '2 Year Rate';
labels{:,9} = 'Excess Bond Premium';

%% Run the VAR
VAR.vars  =   Dataset1.all_data(start:finish,VAR.ind);
switch spec
    case {'Ext_ffr','GK_Ext_noEBP'}
        VAR = proxyVAR(VAR);
        VAR.cimethod = 7;
    case {'TP1_pvt_res','TP1_pvt_fit','TP1_prezlb'}
        VAR = proxyVAR_mult(VAR);
        VAR.cimethod = 5;
    otherwise
        VAR = proxyVAR_mult(VAR);
        VAR.cimethod = 6;
end
VARopt.vnames = labels(:,VAR.ind);

% Options for impulse responses
VARopt.shock_names = {'Fed Funds Rate Shock','Forward Guidance Shock'};
VARopt.pick = 2;
VARopt.savefig = 0;

opt.BlockSizes = 1;
[IRSL,IRSH,~,] = doProxySVARci_plotall(VAR,VAR.cimethod,opt);
VARbs.irsl = IRSL;
VARbs.irsh = IRSH;
%VAR_irplot_shadedci(VAR.irs,VARopt,IRSL,IRSH);
%p1 = mtit('Fed Funds Rate Shock','fontsize',13,'xoff',-.275,'yoff',.035);
%p2 = mtit('Forward Guidance Shock','fontsize',13,'xoff',.275,'yoff',.035);


%% Save the Results
% fname = strcat('Results\VAR_',spec);
% save(fname,'VAR','VARopt','VARbs')