%% Figure 6 in main draft: Robustness Checks
clear; clc;

% load the baseline results
base = load('Results\VAR_TP1.mat');
baseirs = base.VAR.irs(:,4,2);
baseirsl = base.VARbs.irsl(:,4,2);
baseirsh = base.VARbs.irsh(:,4,2);


fn = {'TP1_intday','TP1_2day','TP1_ID2','TP2','TP1_prezlb','TP1_statonly','TP1_ebp','TP1_post94','TP1_noemp','TP1_nounsch'};
lb = {'a) 30 min window','b) 2 day window','c) ID II','d) 2 year rate','e) Pre-ZLB','f) Stat only','g)EBP','h)post-94','i)No emp','j)No unsched'};

steps = 1:1:base.VAR.irhor;
figure;
for jj = 1:10
    fname = strcat('Results\VAR_',fn{jj});
    temp = load(fname);
    tempirs = temp.VAR.irs(:,4,2);
    tempirsl = temp.VARbs.irsl(:,4,2);
    tempirsh = temp.VARbs.irsh(:,4,2);
    
    subplot(5,2,jj)
    patch([steps fliplr(steps)], [baseirsl' fliplr(baseirsh')],[.9 .9 .9],'EdgeColor','white'); hold on;
    plot(steps,baseirs,'LineStyle','-','Color',[0.01 0.09 0.44],'LineWidth',1.5);
    
    plot(tempirs,'--r','LineWidth',1.5); hold on;
    plot(tempirsl,':r','LineWidth',1);
    plot(tempirsh,':r','LineWidth',1);
    ylabel(lb{jj});
end
suptitle('Response of Industrial Production to Forward Guidance Shock');
%--------------------------------------------------------------------------
