%% Figure 5 in main draft: Pvt-res vs pvt-fit vs baseline
clear; clc;

pvtres = load('Results\VAR_TP1_pvt_res.mat');
base = load('Results\VAR_TP1.mat');
pvtfit = load('Results\VAR_TP1_pvt_fit.mat');

IRF(:,1) = base.VAR.irs(:,end,2);
IRF(:,2) = pvtres.VAR.irs(:,end,2);
IRF(:,3) = pvtfit.VAR.irs(:,end,2);


nsteps = 48;
steps = 1:1:nsteps;
x_axis = zeros(1,nsteps);

vnames = base.VARopt.vnames;

figure;
p1 = plot(steps,IRF(:,1),'LineStyle',':','Color','k','LineWidth',2);hold on;
p2 = plot(steps,IRF(:,2),'LineStyle','-.','Color','b','LineWidth',2);
p3 = plot(steps,IRF(:,3),'LineStyle','--','Color','r','LineWidth',2);
plot(x_axis,'k','LineWidth',0.15);
title('Forward Guidance Shock: Response of Industrial Production');
l = legend([p1 p2 p3],'Path Factor','Path Factor (Pvt Res)','Path Factor (Pvt Fit)');
set(l,'FontSize',12);
