%% Figure 4 in main draft: pvt_res vs baseline: fwd guidance shock
clear; clc;

pvtres = load('Results\VAR_TP1_pvt_res.mat');
base = load('Results\VAR_TP1.mat');

% Stack the two irfs
irs(:,:,1) = pvtres.VAR.irs(:,:,2);
irsH(:,:,1) = pvtres.VARbs.irsh(:,:,2);
irsL(:,:,1) = pvtres.VARbs.irsl(:,:,2);

irs(:,:,2) = base.VAR.irs(:,:,2);
irsH(:,:,2) = base.VARbs.irsh(:,:,2);
irsL(:,:,2) = base.VARbs.irsl(:,:,2);

[fig_handle, sbplots] = VAR_irplot_shadedci(irs,base.VARopt,irsH,irsL);
p1 = mtit('Cleansed Path Factor (Pvt Res)','fontsize',13,'xoff',-.275,'yoff',.02);
p2 = mtit('Baseline Path Factor','fontsize',13,'xoff',.275,'yoff',.02);
p3 = mtit('Forward Guidance Shock','fontsize',13','xoff',.005,'yoff',.05);

subplot(sbplots(1)); hold on;
ylim([-1 2]);

subplot(sbplots(2)); hold on;
ylim([-1 2]);

subplot(sbplots(4)); hold on;
ylim([-2.5 3.5]);

subplot(sbplots(7)); hold on;
ylim([-1 1]);

subplot(sbplots(8)); hold on;
ylim([-2.5 3.5]);


%--------------------------------------------------------------------------