%% Figure 3 in main draft: Comparison with "one policy tool"
% compare one policy toolPlot Ext_ffr and GK_noEBP on same graph
clear; clc;

addpath(genpath('auxfiles\'));

% load the Ext_ffr results
Ext_ffr_results = load('Results\VAR_Ext_ffr');

% load the GK_noEBP results
GK_results = load('Results\VAR_GK_Ext_noEBP');

% Stack the two irfs
irs(:,:,1) = Ext_ffr_results.VAR.irs;
irs(:,:,2) = GK_results.VAR.irs;
irsH(:,:,1) = Ext_ffr_results.VARbs.irsh;
irsH(:,:,2) = GK_results.VARbs.irsh;
irsL(:,:,1) = Ext_ffr_results.VARbs.irsl;
irsL(:,:,2) = GK_results.VARbs.irsl;



%figure;
% load the baseline TP1 results
TP1 = load('Results\VAR_TP1');

% declare irs and ci matrices
lim_irs = NaN(TP1.VAR.irhor,3,2);
lim_irsl = NaN(TP1.VAR.irhor,3,2);
lim_irsh = NaN(TP1.VAR.irhor,3,2);

% get ffr, cpi and ip resp to ffr shock
lim_irs(:,:,1) = TP1.VAR.irs(:,[1 3 4],1);
lim_irsl(:,:,1) = TP1.VARbs.irsl(:,[1 3 4],1);
lim_irsh(:,:,1) = TP1.VARbs.irsh(:,[1 3 4],1);

% 1 yr, cpi and ip resp to 1 yr shock
lim_irs(:,:,2) = TP1.VAR.irs(:,2:4,2);
lim_irsl(:,:,2) = TP1.VARbs.irsl(:,2:4,2);
lim_irsh(:,:,2) = TP1.VARbs.irsh(:,2:4,2);

lim_VARopt = TP1.VARopt;
lim_VARopt.vnames(2)=[];
[fig_handle, sbplots] = VAR_irplot_shadedci(lim_irs,lim_VARopt,lim_irsl,lim_irsh);

subplot(sbplots(1)); hold on;
plot(irs(:,1,1),'--r','LineWidth',1.5); hold on;
plot(irsL(:,1,1),':r','LineWidth',1);
plot(irsH(:,1,1),':r','LineWidth',1);
%plot(

subplot(sbplots(2)); hold on;
plot(irs(:,2,1),'--r','LineWidth',1.5); hold on;
plot(irsL(:,2,1),':r','LineWidth',1);
plot(irsH(:,2,1),':r','LineWidth',1);

subplot(sbplots(3)); hold on;
plot(irs(:,3,1),'--r','LineWidth',1.5); hold on;
plot(irsL(:,3,1),':r','LineWidth',1);
plot(irsH(:,3,1),':r','LineWidth',1);

subplot(sbplots(4)); hold on;
plot(irs(:,1,2),'--r','LineWidth',1.5); hold on;
plot(irsL(:,1,2),':r','LineWidth',1);
plot(irsH(:,1,2),':r','LineWidth',1);
title('1 Year Rate','FontSize',10);

subplot(sbplots(5)); hold on;
plot(irs(:,2,2),'--r','LineWidth',1.5); hold on;
plot(irsL(:,2,2),':r','LineWidth',1);
plot(irsH(:,2,2),':r','LineWidth',1);

subplot(sbplots(6)); hold on;
plot(irs(:,3,2),'--r','LineWidth',1.5); hold on;
plot(irsL(:,3,2),':r','LineWidth',1);
plot(irsH(:,3,2),':r','LineWidth',1);

suptitle('Only 1 policy tool',14);
%--------------------------------------------------------------------------