function VARbs = proxyVAR_multbootstrap_mbb_2step_adj(VAR)
%% Moving Block bootstrap of Jentsch & Lunsford (2016) adapted to
% the case of having two different samples for the reduced form VAR and
% for the IV structural identification step
% AKL 2018 (adapted code of Kurt Lunsford)
% using the centering adjustment from Mertens & Ravn (2018)

%% Details for Bootstrap
nboot = VAR.nboot;
clevel = VAR.clevel;
VAR.doing_ci = 1;

% Parameters for Moving Block Bootstrap
%VAR.BlockSize = 40; %16; %VAR.BlockSize;

%% First sample u (rf VAR residuals) for full sample
% store rf coeffs delta

%% sample [u,VAR.m] for limited sample
% calculate Sigma and then b11 and b21

% calculate irfs from delta and b11,b21 a

jj=1; % jj indexes bootstrap draw

VARBS = VAR;
%res = detrend(VAR.res,'constant');
IRS = NaN(VAR.irhor*VAR.n,nboot,VAR.k);
IRScum = NaN(size(IRS));

while jj<nboot+1
    
    % sample rf residuals from full sample using mbb
    resb = mbb_res_only(VAR);
    
    % generate artificial data
    varsb = zeros(VAR.p+VAR.T,VAR.n);
    varsb(1:VAR.p,:)=VAR.vars(1:VAR.p,:);
    for tt=VAR.p+1:VAR.p+VAR.T
        lvars = (varsb(tt-1:-1:tt-VAR.p,:))';
        varsb(tt,:) = lvars(:)'*VAR.bet(1:VAR.p*VAR.n,:)+VAR.bet(VAR.p*VAR.n+1:end,:)+resb(:,tt-VAR.p)';
    end
    
    % Use artificial data to estimate rf coeffs
    X      = lagmatrix_(varsb,VAR.p);
    X      = X(VAR.p+1:end,:);
    Y      = varsb(VAR.p+1:end,:);
    switch VAR.const
        case 0 % no constant
            Xtil = X;
            Teff = VAR.T-VAR.n*VAR.p;
        case 1 % constant
            Xtil = [X ones(length(X),1)];
            Teff = VAR.T-VAR.n*VAR.p-1;
        case 2 % constant + time trend
            trend = (1:length(X))';
            Xtil = [X ones(length(X),1) trend];
            Teff = VAR.T-VAR.n*VAR.p-2;
    end
    bet=Xtil\Y;
    
    % sample rf residuals and proxies from limited sample using mbb
    %[resb_,proxy_] = mbb_res_proxy(VAR);
    [resb_,proxy_] = mbb_res_proxy_adj(VAR);
    % resb_ is sample of rf residuals from limited sample
    % proxy_ is sample of instr from limited sample
    
    % Calculate Sigma and b1 (iv identification)
    Phib = [ones(VAR.T_m,1) proxy_]\resb_;
    VAR.Sigma = (resb_'*resb_)/(VAR.T_m-VAR.n*VAR.p-1);
    Phib = Phib(2:end,:);
    Phib11  = Phib(1:VAR.k,1:VAR.k);
    Phib21  = Phib(1:VAR.k,VAR.k+1:VAR.n);
    b21ib11 = (Phib11\Phib21)';
    Sig11   = VAR.Sigma(1:VAR.k,1:VAR.k);
    Sig21   = VAR.Sigma(VAR.k+1:VAR.n,1:VAR.k);
    Sig22   = VAR.Sigma(VAR.k+1:VAR.n,VAR.k+1:VAR.n);
    ZZp     = b21ib11*Sig11*b21ib11'-(Sig21*b21ib11'+b21ib11*Sig21')+Sig22;
    b12b12p = (Sig21- b21ib11*Sig11)'*(ZZp\(Sig21- b21ib11*Sig11));
    b11b11p = Sig11-b12b12p;
    b22b22p = Sig22+b21ib11*(b12b12p-Sig11)*b21ib11';
    b12ib22   = ((Sig21- b21ib11*Sig11)'+b12b12p*b21ib11')/(b22b22p');
    b11iSig = eye(VAR.k)/(eye(VAR.k)-b12ib22*b21ib11);
    b21iSig = b21ib11*b11iSig;
    SigmaTSigmaTp =b11iSig\b11b11p/b11iSig';
    %%%%%%%%  Identification I, following Mertens & Ravn
    if VAR.ord(1)==1
        s1 = sqrt(SigmaTSigmaTp(1,1));
        a  = SigmaTSigmaTp(2,1)/s1;
        s2 = sqrt(SigmaTSigmaTp(2,2)-a^2);
        SigmaT = [s1 0 ; a s2];
    elseif VAR.ord(1)==2
        s2 = sqrt(SigmaTSigmaTp(2,2));
        b  = SigmaTSigmaTp(1,2)/s2;
        s1 = sqrt(SigmaTSigmaTp(1,1)-b^2);
        SigmaT = [s1 b; 0 s2];
    elseif VAR.ord(1) ==3 % diagonal
        s2 = sqrt(SigmaTSigmaTp(2,2));
        b  = SigmaTSigmaTp(1,2)/s2;
        s1 = sqrt(SigmaTSigmaTp(1,1)-b^2);
        SigmaT = [s1 0; 0 s2];
    end
    %%%%%%%% Identification II %Alternative derivation (following OSW,Lunsford)
    Zu = Phib; % E(Z(t)*u(t)']
    phi = chol(Zu*inv(VAR.Sigma)*Zu','upper');
    switch VAR.ident
        case 1
            VARb1 = [b11iSig;b21iSig]*SigmaT;
        case 2
            VARb1 = Zu'*inv(phi');
    end
    VAR.b1(:,:,1) = VARb1;
    VAR.b1(:,:,2) = VARb1;
    
    % Impulse Responses
    %%%%%%%%%%%%%%%%%%%%%%
    for i=1:VAR.k        
        irs = [];
        switch VAR.spec
            case 'std'  % a 1 std-dev increase in structural shock
                irs(VAR.p+1,:) = VAR.b1(:,i,i)*1; %#ok<*AGROW>
            case 'unit' % shock that results in 1 unit increase in y (observable variable)
                irs(VAR.p+1,:) = VAR.b1(:,i,i)/VAR.b1(i,i,i);
        end        
        for tt=2:VAR.irhor
            lvars = (irs(VAR.p+tt-1:-1:tt,:))';
            irs(VAR.p+tt,:) = lvars(:)'*bet(1:VAR.p*VAR.n,:);
        end        
        VARBS.irs(1:VAR.irhor,1:VAR.n,i) = irs(VAR.p+1:end,:);        
    end
        
    for i=1:VAR.k % i indexes instr
        irs = VARBS.irs(:,:,i);
        IRS(:,jj,i) = irs(:);
        
        % cumulated response
        cumirs = cumsum(VARBS.irs(:,:,i),1);
        IRScum(:,jj,i) = cumirs(:);        
        
    end
    
    jj=jj+1;
end

for jj = 1:length(clevel)
    for i=1:VAR.k % i indexes Tax Type
        VARbs.irsH(:,:,i,jj)=reshape(quantile(IRS(:,:,i)',(1-clevel(jj)/100)/2),VAR.irhor, size(VARBS.irs,2));
        VARbs.irsL(:,:,i,jj)=reshape(quantile(IRS(:,:,i)',1-(1-clevel(jj)/100)/2),VAR.irhor, size(VARBS.irs,2));    
        VARbs.irsHcum(:,:,i,jj) = reshape(quantile(IRScum(:,:,i)',(1-clevel(jj)/100)/2),VAR.irhor, size(VARBS.irs,2));
        VARbs.irsLcum(:,:,i,jj) = reshape(quantile(IRScum(:,:,i)',1-(1-clevel(jj)/100)/2),VAR.irhor, size(VARBS.irs,2));
        
        
        virs = VAR.irs(:,:,i);
        VARbs.irsHhall(:,:,i,jj)=VAR.irs(:,:,i)-reshape(quantile(IRS(:,:,i)'-(virs(:)*ones(1,nboot))',(1-clevel(jj)/100)/2),VAR.irhor, size(VAR.irs,2));
        VARbs.irsLhall(:,:,i,jj)=VAR.irs(:,:,i)-reshape(quantile(IRS(:,:,i)'-(virs(:)*ones(1,nboot))',1-(1-clevel(jj)/100)/2),VAR.irhor, size(VAR.irs,2));     
    end
end