% Mertens & Ravn 2013 External Instruments Code

% Run the reduced form VAR

%VAR.beta; % coefficients of reduced form VAR
%VAR.resid; % residuals of reduced form VAR
%VAR.SIGMA; % variance-covariance matrix of reduced-form VAR

% IV Regressions:

% First stage:
% - Regress policy residuals on instruments and save fitted value

% Second stage:
% - Individually regress each non-policy reduced form residual on fitted
% value from first stage

% Use restrictions to back out column of contemporaneous impact matrix
% corresponding to the monetary policy shock

function VAR = proxyVAR_mult(VAR)

%X      = lagmatrix(VAR.vars,1:VAR.p);
X      = lagmatrix_(VAR.vars,VAR.p);

X      = X(VAR.p+1:end,:);
Y      = VAR.vars(VAR.p+1:end,:);
VAR.k  = size(VAR.proxies,2);
%VAR.m = VAR.proxies(VAR.p+1:end,:);
VAR.m = VAR.proxies;
[VAR.T,VAR.n] = size(Y);
%[VAR.T_m,VAR.k] = size(VAR.proxies(VAR.p+1:end,:));
[VAR.T_m,VAR.k] = size(VAR.proxies); %(VAR.p+1:end,:));


% Run VAR
%%%%%%%%%%%%
switch VAR.const
    case 0 % no constant
        Xtil = X;
        Teff = VAR.T-VAR.n*VAR.p;
    case 1 % constant
        Xtil = [X ones(length(X),1)];
        Teff = VAR.T-VAR.n*VAR.p-1;
        VAR.DET = ones(length(X),1);
    case 2 % constant + time trend
        trend = (1:length(X))';
        Xtil = [X ones(length(X),1) trend];
        Teff = VAR.T-VAR.n*VAR.p-2;
end
VAR.bet=Xtil\Y;
VAR.res = Y-Xtil*VAR.bet;
%VAR.Sigma = (VAR.res'*VAR.res)/Teff;
VAR.Y = Y;
VAR.Xtil = Xtil;

% Identification
%%%%%%%%%%%%%%%%%
if VAR.T == VAR.T_m % if sample size of proxies and VAR data align
    Phib = [ones(length(VAR.m),1) VAR.m]\VAR.res;
    %VAR.Sigma = (VAR.res'*VAR.res)/Teff;
    YY = VAR.res; % reduced-form residuals %#ok<*NASGU>
elseif VAR.T > VAR.T_m % if less proxy data (assuming proxy data starts later)
    Phib = [ones(VAR.T_m,1) VAR.m]\VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:);
    %VAR.Sigma = (VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:)'*VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:))/(VAR.T_m-VAR.n*VAR.p-1);
    YY = VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:); 
else
    error('Data mismatch');
end

VAR.Sigma = (VAR.res'*VAR.res)/Teff;

% Calculate F-stats for first stage
%if ~isfield(VAR, 'doing_ci')
%    rob_stderr_proxyVAR_mult;
%end

%Phib = [ones(length(VAR.m),1) VAR.m]\VAR.res;
Phib = Phib(2:end,:);
Phib11  = Phib(1:VAR.k,1:VAR.k);
Phib21  = Phib(1:VAR.k,VAR.k+1:VAR.n);
b21ib11 = (Phib11\Phib21)';
Sig11   = VAR.Sigma(1:VAR.k,1:VAR.k);
Sig21   = VAR.Sigma(VAR.k+1:VAR.n,1:VAR.k);
Sig22   = VAR.Sigma(VAR.k+1:VAR.n,VAR.k+1:VAR.n);
ZZp     = b21ib11*Sig11*b21ib11'-(Sig21*b21ib11'+b21ib11*Sig21')+Sig22;
b12b12p = (Sig21- b21ib11*Sig11)'*(ZZp\(Sig21- b21ib11*Sig11));
b11b11p = Sig11-b12b12p;
b22b22p = Sig22+b21ib11*(b12b12p-Sig11)*b21ib11';
b12ib22   = ((Sig21- b21ib11*Sig11)'+b12b12p*b21ib11')/(b22b22p');
b11iSig = eye(VAR.k)/(eye(VAR.k)-b12ib22*b21ib11);
b21iSig = b21ib11*b11iSig;

SigmaTSigmaTp =b11iSig\b11b11p/b11iSig';

% % Reliability
% Sigmm   = VAR.m'*VAR.m/VAR.T;
% ED      = eye(VAR.k)*sum(sum(VAR.m,2)~=0)/VAR.T;
% mu1     = VAR.m'*VAR.res(:,1:VAR.k)/VAR.T;
% PhiPhip = mu1*inv(b11b11p)*mu1';
% VAR.RM  = inv(Sigmm)*PhiPhip*inv(ED);
% VAR.RMeigs = sort(eig(VAR.RM));

% % First stage F-stat
% XXres = ones(length(YY),1);
% reg_res1 = ols(YY(:,1),XXres);
% reg_res2 = ols(YY(:,2),XXres);
% 
% pres = 1; punres = pres + VAR.k;
% rss_unres1 =  reg_unres1.resid'*reg_unres1.resid;
% rss_unres2 =  reg_unres2.resid'*reg_unres2.resid;
% rss_res1 =  reg_res1.resid'*reg_res1.resid;
% rss_res2 =  reg_res2.resid'*reg_res2.resid;
% 
% VAR.F1 = ( (rss_res1 - rss_unres1)/(punres - pres )  ) /  (rss_unres1/(VAR.T_m-punres+1 )  );
% VAR.F2 = ( (rss_res2 - rss_unres2)/(punres - pres )  ) /  (rss_unres2/(VAR.T_m-punres+1 )  );


%%%%%%%%  Identification I, following Mertens & Ravn
if VAR.ord(1)==1
    s1 = sqrt(SigmaTSigmaTp(1,1));
    a  = SigmaTSigmaTp(2,1)/s1;
    s2 = sqrt(SigmaTSigmaTp(2,2)-a^2);
    SigmaT = [s1 0 ; a s2];
elseif VAR.ord(1)==2
    s2 = sqrt(SigmaTSigmaTp(2,2));
    b  = SigmaTSigmaTp(1,2)/s2;
    s1 = sqrt(SigmaTSigmaTp(1,1)-b^2);
    SigmaT = [s1 b; 0 s2];
elseif VAR.ord(1) ==3 % diagonal
    s2 = sqrt(SigmaTSigmaTp(2,2));
    b  = SigmaTSigmaTp(1,2)/s2;
    s1 = sqrt(SigmaTSigmaTp(1,1)-b^2);
    SigmaT = [s1 0; 0 s2];
end
%VAR.b1(:,:,i) = [b11iSig;b21iSig]*SigmaT;

%%%%%%%% Identification II %Alternative derivation (following OSW,Lunsford)
Zu = Phib; % E(Z(t)*u(t)']
phi = chol(Zu*inv(VAR.Sigma)*Zu','upper');
Pi = Zu*inv(VAR.Sigma);
% VAR.b1(:,:,1) = Zu'*inv(phi');
% VAR.b1(:,:,2) = Zu'*inv(phi');

switch VAR.ident
    case 1
        VARb1 = [b11iSig;b21iSig]*SigmaT;
    case 2
        VARb1 = Zu'*inv(phi');
end

VAR.b1(:,:,1) = VARb1;
VAR.b1(:,:,2) = VARb1;

% Calculate the structural shocks
% if ~isfield(VAR, 'doing_ci')
%     struc_shocks;
% end

% Impulse Responses
%%%%%%%%%%%%%%%%%%%%%%
for i=1:VAR.k
       
    irs = [];
    switch VAR.spec
        case 'std'  % a 1 std-dev increase in structural shock
            irs(VAR.p+1,:) = VAR.b1(:,i,i)*1; %#ok<*AGROW>
        case 'unit' % shock that results in 1 unit increase in y (observable variable)            
            irs(VAR.p+1,:) = VAR.b1(:,i,i)/VAR.b1(i,i,i);            
    end
        
    for tt=2:VAR.irhor
        lvars = (irs(VAR.p+tt-1:-1:tt,:))';
        irs(VAR.p+tt,:) = lvars(:)'*VAR.bet(1:VAR.p*VAR.n,:);
    end
    
    VAR.irs(1:VAR.irhor,1:VAR.n,i) = irs(VAR.p+1:end,:);
    
end

VAR.impact = VAR.b1(:,:,1); %




