% Mertens & Ravn 2013 External Instruments Code

% Run the reduced form VAR

%VAR.beta; % coefficients of reduced form VAR
%VAR.resid; % residuals of reduced form VAR
%VAR.SIGMA; % variance-covariance matrix of reduced-form VAR

% IV Regressions:

% First stage: 
% - Regress policy residual on instrument and save fitted value

% Second stage: 
% - Individually regress each non-policy reduced form residual on fitted
% value from first stage

% Use restrictions to back out column of contemporaneous impact matrix
% corresponding to the monetary policy shock

function VAR = proxyVAR(VAR)
 %X      = lagmatrix(VAR.vars,1:VAR.p);
 X      = lagmatrix_(VAR.vars,VAR.p);
 
 X      = X(VAR.p+1:end,:);
 Y      = VAR.vars(VAR.p+1:end,:);
 VAR.m  = VAR.proxies(VAR.p+1:end,:);
 %VAR.m = VAR.proxies;
 [VAR.T,VAR.n] = size(Y);
 [VAR.T_m,VAR.k] = size(VAR.proxies(VAR.p+1:end,:));
 %[VAR.T_m,VAR.k] = size(VAR.proxies);

% Run VAR
%%%%%%%%%%%%
%VAR.bet=[X ones(length(X),1)]\Y; 
%VAR.res = Y-[X ones(length(X),1)]*VAR.bet;

switch VAR.const
    case 0 % no constant
        Xtil = X; 
        Teff = VAR.T-VAR.n*VAR.p;
    case 1 % constant
        Xtil = [X ones(length(X),1)];
        Teff = VAR.T-VAR.n*VAR.p-1;
    case 2 % constant + time trend
        trend = (1:length(X))';
        Xtil = [X ones(length(X),1) trend]; 
        Teff = VAR.T-VAR.n*VAR.p-2;
end

VAR.bet=Xtil\Y; 
VAR.res = Y-Xtil*VAR.bet;
     
% Identification
%%%%%%%%%%%%%%%%%
if VAR.T == VAR.T_m % if sample size of proxies and reduced form VAR align
    Phib = [ones(length(VAR.m),1) VAR.m]\VAR.res;
    %VAR.Sigma = (VAR.res'*VAR.res)/Teff;
    YY = VAR.res;
    %reg_unres = ols(VAR.res(:,1),[ones(length(VAR.m),1) VAR.m] ); % Unrestricted regression
elseif VAR.T > VAR.T_m
    Phib = [ones(VAR.T_m,1) VAR.m]\VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:);
    %VAR.Sigma = (VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:)'*VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:))/(VAR.T_m-VAR.n*VAR.p-1);
    YY = VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:); 
    %reg_unres = ols(VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,1),[ones(length(VAR.m),1) VAR.m] ); % Unrestricted regression
else
    error('Data mismatch');
end
VAR.YY = YY;
%rob_stderr_proxyVAR;
% Script that calculates robust standard errors and F-stat

%rob_stderr_proxyVAR_mult;

VAR.Sigma = (VAR.res'*VAR.res)/Teff;

Phib = Phib(2:end,:);
Phib11  = Phib(1:VAR.k,1:VAR.k);
Phib21  = Phib(1:VAR.k,VAR.k+1:VAR.n);
b21ib11 = (Phib11\Phib21)';
Sig11   = VAR.Sigma(1:VAR.k,1:VAR.k);
Sig21   = VAR.Sigma(VAR.k+1:VAR.n,1:VAR.k);
Sig22   = VAR.Sigma(VAR.k+1:VAR.n,VAR.k+1:VAR.n);
ZZp     = b21ib11*Sig11*b21ib11'-(Sig21*b21ib11'+b21ib11*Sig21')+Sig22;
b12b12p = (Sig21- b21ib11*Sig11)'*(ZZp\(Sig21- b21ib11*Sig11));
b11b11p = Sig11-b12b12p;
b11 = sqrt(b11b11p);
VAR.b1 = [b11; b21ib11*b11];

% First stage:F-statistic and R^2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%reg_res = ols(VAR.res(:,1),ones(length(VAR.res),1)); % Restricted regression
%reg_unres = ols(VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,1),[ones(length(VAR.m),1) VAR.m] ); % Unrestricted regression
%VAR.F = reg_unres.tstat(2)^2;
%VAR.R2 = reg_unres.rsqr;

% %Reliability
% %  Sigmm = VAR.m'*VAR.m/VAR.T;
% ED    = eye(VAR.k)*sum(sum(VAR.m,2)~=0)/VAR.T;
% mu1   = VAR.m'*VAR.res(:,1:VAR.k)/VAR.T;
%  % PhiPhip = mu1*inv(b11b11p)*mu1';
%  % VAR.RM    = inv(Sigmm)*PhiPhip*inv(ED)
% Bi = [1/b11+(Sig21-Sig11*b21ib11)'*inv(ZZp)/b11*b21ib11 -(Sig21-Sig11*b21ib11)'*inv(ZZp)/b11];
% VAR.et = (Bi*VAR.res')';
% 
% PHI = mu1/b11;
% GAM = inv(ED)*PHI;
% E  = GAM*VAR.et(sum(VAR.m,2)~=0);
% V  = VAR.m(sum(VAR.m,2)~=0)-E;
% VAR.RM = inv(E'*E+V'*V)*E'*E;


% Impulse Responses
%%%%%%%%%%%%%%%%%%%%
% irs(VAR.p+1,:) = -VAR.b1(:,1)/VAR.b1(1,1); % original MR code
% Modified by AKL
% Choose 1 std-dev, 1 unit shock or shock that increases y by 1 unit

%irs = zeros(VAR.irhor+p,VAR.n);

switch VAR.spec
    case 'std' % a 1 std-dev increase in structural shock
        irs(VAR.p+1,:) = VAR.b1(:,1)*1;
    case 'unit' % shock that results in 1 unit increase in y (observable variable)
        irs(VAR.p+1,:) = VAR.b1(:,1)/VAR.b1(1,1);
end

 for jj=2:VAR.irhor
 lvars = (irs(VAR.p+jj-1:-1:jj,:))';
 irs(VAR.p+jj,:) = lvars(:)'*VAR.bet(1:VAR.p*VAR.n,:);     
 end
VAR.irs = irs(VAR.p+1:end,:); 

VAR.impact = VAR.b1(:,1); %

%--------------------------------------------------------------------------
