function [U_boot,M_boot] = mbb_res_proxy_adj(VAR)
%MBB_RES Generate samples of reduced form VAR residuals and proxies
% for the Jentsch and Lunsford (2016) moving block bootstrap
% AKL 2018 (adapted code of Kurt Lunsford)

T = VAR.T_m; % number of effective observations for limited ident sample
N = VAR.n; % number of variables in VAR
BlockSize = VAR.BlockSize;
r = size(VAR.m,2);
U_hat = VAR.res(VAR.T-VAR.T_m-VAR.T_m_end+1:VAR.T-VAR.T_m_end,:); % reduced form residual for limited sample
M = VAR.m;


%create the blocks for the moving block bootstrap
L = BlockSize; L = 32;
J = ceil(T/L);

UBlocks = zeros(L,N,T-L+1);
MBlocks = zeros(L,r,T-L+1);

for ii = 1:T-L+1
    UBlocks(:,:,ii) = U_hat(ii:L+ii-1,:);
    MBlocks(:,:,ii) = M(ii:L+ii-1,:);
end

%center the bootstrapped VAR errors and proxy variables
centering = zeros(L,N);
for ii = 1:L
    centering(ii,:) = mean(U_hat(ii:T-L+ii,:),1);
    %Mcentering(ii,:) = mean(M(ii:T-L+ii,:),1);
end
centering = repmat(centering,[J,1]);
centering = centering(1:T,:);

Mcentering = zeros(L,r);
for ii = 1:L
    subM = VAR.m(ii:T-L+ii,:);
    subM2 = VAR.proxies;
    %Mcentering(ii,:) = mean(M(ii:T-L+ii,:),1);
    Mcentering(ii,:) = [mean(subM((subM(:,1) ~= 0),1),1)-mean(subM2((subM2(:,1) ~= 0),1),1),...
                    mean(subM((subM(:,2) ~= 0),2),1)-mean(subM2((subM2(:,2) ~= 0),2),1)];
end
Mcentering = repmat(Mcentering,[J,1]);
Mcentering = Mcentering(1:T,:);


% Moving Block Bootstrap
%draw bootstrapped VAR residuals and proxies
index = ceil((T - L + 1)*rand(J,1));
U_boot = zeros(J*L,N);
M_boot = zeros(J*L,r);       

for j = 1:J
    U_boot(1+L*(j-1):L*j,:) = UBlocks(:,:,index(j,1));
    M_boot(1+L*(j-1):L*j,:) = MBlocks(:,:,index(j,1));
end
U_boot = U_boot(1:T,:);
M_boot = M_boot(1:T,:);

%center the VAR residuals and proxies
U_boot = U_boot - centering;
M_boot = M_boot - Mcentering;



