function U_boot = mbb_res_only(VAR)
%MBB_RES Generate samples of reduced form VAR residuals for the Jentsch and
% Lunsford (2016) moving block bootstrap
% AKL 2018 (adapted code of Kurt Lunsford)

T = VAR.T; % number of effective observations for reduced form VAR
N = VAR.n; % number of variables in VAR
BlockSize = VAR.BlockSize;
U_hat = VAR.res; % reduced form residual

%create the blocks for the moving block bootstrap
L = BlockSize; % L = 32;
J = ceil(T/L);

UBlocks = zeros(L,N,T-L+1);
for ii = 1:T-L+1
    UBlocks(:,:,ii) = U_hat(ii:L+ii-1,:);
end

%center the bootstrapped VAR errors and proxy variables
centering = zeros(L,N);
for ii = 1:L
    centering(ii,:) = mean(U_hat(ii:T-L+ii,:),1);
    %Mcentering(ii,:) = mean(M(ii:Trf-L+ii,:),1);
end
centering = repmat(centering,[J,1]);
centering = centering(1:T,:);


% Moving Block Bootstrap
%draw bootstrapped VAR residuals
index = ceil((T - L + 1)*rand(J,1));
U_boot = zeros(J*L,N);

for j = 1:J
    U_boot(1+L*(j-1):L*j,:) = UBlocks(:,:,index(j,1));
end
U_boot = U_boot(1:T,:);
U_boot = (U_boot - centering)';





