function X = lagmatrix_(y,p)

% Code to replicate Matlab's lag matrix
% PURPOSE:
%     Construct an X matrix for use in a VAR regression
% 
% USAGE:
%     X = lagmatrix_(y,p)
% 
% INPUTS:
%     y is the dependant variable(Txn)
%     p is the number of lags(scalar)
% 
% OUTPUTS:
%     X will be T x np 
% 
% Author: Kevin Sheppard
% kevin.sheppard@economics.ox.ac.uk
% Revision: 2    Date: 12/31/2001
% Revised by AKL, Sep 2015

% check input

[T n]= size(y);

% initialize Y and X
X=NaN(T,n*p);

k = 1;
for i=1:p
   X(p+1:end,k:k+n-1)=y(p-i+1:T-i,:);
   k = k + n;
end;


