%function VARbs = doProxySVARci(VAR,clevel,method,nboot,BlockSize)
function [irsL, irsH, VARbs, irsLcum, irsHcum] = doProxySVARci_plotall(VAR,cimethods,extra_stuff)

% Adapted code of Karel Mertens to compute CIs using different
% bootstrap methods 
% AKL August 2018

% Inference: cimethod
%         1: Mertens and Ravn (2013) wild bootstrap 
%         2: Montiel-Olea Stock Watson (2016) bootstrap
%         3: Delta Method 
%         4: Montiel-Olea Stock Watson (2016) asy weak IV 
%         5: Jentsch and Lunsford Moving Block Bootstrap
%         6: Jentsch and Lunsford Moving Block Bootstrap w/ adjustment

% Dimension of VARci.irsH and VARci.irsL: 
% 1: horizon 2: # of variables 3: clevel 4: shock (if more than one shock with instrument)

irsL = NaN*zeros([size(VAR.irs) length(cimethods)]);
irsH = NaN*zeros([size(VAR.irs) length(cimethods)]);

irsLcum = NaN(size(irsL));
irsHcum = NaN(size(irsH));


% Newey West Lags
try 
    NWlags = VAR.NWlags;
catch
    NWlags = floor(4*(((length(VAR.vars)-VAR.p)/100)^(2/9)));
end

for cc = 1:length(cimethods)
    
    cimethod = cimethods(cc);
    VAR.BlockSize = extra_stuff.BlockSizes(cc);

switch cimethod
    
    case 1
        %VARbs = doWildbootstrap(VAR,nboot,clevel);
        VARbs = proxyVAR_multbootstrap(VAR);
    case 2
        %VARbs = doMSWbootstrap(VAR,nboot,clevel,NWlags);        
        VARbs = doMSWbootstrap_(VAR);
    case 3
        if VAR.k==1
            VARbs = doDeltaMethod(VAR,VAR.clevel,NWlags);
        elseif VAR.k==2
            VARbs = doDeltaMethod_2shock_(VAR);
        end
    case 4
        if VAR.k==1
            VARbs = doMSWwivrobust(VAR,VAR.clevel,NWlags); % Not available for k>1
        else
            fprintf('Invalid inference option for k>1 \n')
        end
    case 5
        %VARbs = doMBBbootstrap(VAR,nboot,VAR.clevel,BlockSize);
        VARbs = proxyVAR_multbootstrap_mbb_2step(VAR);
    case 6
        %VARbs = doMBBbootstrap_adj(VAR,nboot,VAR.clevel,BlockSize);
        VARbs = proxyVAR_multbootstrap_mbb_2step_adj(VAR);
    case 7
        VARbs = proxyVAR_bootstrap_mbb_2step(VAR);
end

irsL(:,:,:,cc) = VARbs.irsL;
irsH(:,:,:,cc) = VARbs.irsH;

%irsL(:,:,:,cc) = VARbs.irsLhall;
%irsH(:,:,:,cc) = VARbs.irsHhall;

if isfield(VARbs,'irsLcum')
irsLcum(:,:,:,cc) = VARbs.irsLcum;
irsHcum(:,:,:,cc) = VARbs.irsHcum;
else
irsLcum(:,:,:,cc) = NaN;
irsHcum(:,:,:,cc) = NaN;    
end

end

