function [fig_handle, sbplots] = VAR_irplot_shadedci(IRF1,VARopt,INF1,SUP1)
% =======================================================================
% Plot the IRFs computed with VARir
% =======================================================================
% VARirplot(IRF,VARopt,vnames,INF,SUP)
% -----------------------------------------------------------------------
% INPUT
%   - IRF1(:,:,:) : matrix with periods, variable, shock
%   - VARopt: options of the VAR (see VARopt from VARmodel)
% -----------------------------------------------------------------------
% OPTIONAL INPUT
%   - INF1: lower error band
%   - SUP1: upper error band
% =======================================================================
% AKL Modified code of Ambrogio Cesa Bianchi
% same as VAR_irplot_1 but shading the confidence intervals and allowing
% for two different levels of significance (i.e. 68% and 95%)

%% Check inputs
%================================================
if ~exist('VARopt','var')
    error('You need to provide VAR options (VARopt from VARmodel)');
end
% If there is VARopt get the vnames
vnames = VARopt.vnames;
% Check they are not empty
if isempty(vnames)
    error('You need to add label for endogenous variables in VARopt');
end
shock_names = VARopt.shock_names;

%% Retrieve and initialize variables
%================================================

if isfield(VARopt,'suptitle')
    sptitle = VARopt.suptitle;
end
pick = VARopt.pick;

% Initialize IRF matrix
[nsteps, nvars, nshocks] = size(IRF1);

% If one shock is chosen, set the right value for nshocks
if pick<0 || pick>nvars
    error('The selected shock is non valid')
else
    if pick==0
        pick=1;
    else
        nshocks = pick;
    end
end

% Define the rows and columns for the subplots
%row = round(sqrt(nvars));
row = nvars;
%col = ceil(sqrt(nvars));
col = pick; % 2

tot_sub_plots = 1:row*col;
ind_even = tot_sub_plots(find(mod(tot_sub_plots,2)==1)); %#ok<*FNDSB>
ind_odd = tot_sub_plots(find(mod(tot_sub_plots,2)==0));
%ind = [ind_odd ind_even];
ind = [ind_even ind_odd];

% Define a timeline
steps = 1:1:nsteps;
x_axis = zeros(1,nsteps);


%% Cumulate irfs
%================================================
%if nargin > 2

if isfield(VARopt,'ircum') && VARopt.ircum == 1
    IRF = IRF1;
    IRF(:,VARopt.cumirf,:) = cumsum(IRF1(:,VARopt.cumirf,:));
    
    
    if exist('INF1','var')
        INF = INF1;
        INF(:,VARopt.cumirf,:) = cumsum(INF1(:,VARopt.cumirf,:));
        
        SUP = SUP1;
        SUP(:,VARopt.cumirf,:) = cumsum(SUP1(:,VARopt.cumirf,:));
    end
    
else
    IRF = IRF1;
    if exist('INF1','var')
        INF = INF1;
        SUP = SUP1;
    end
end
    
    %% Plot
    %================================================
    kk = 0; % subplot counter
    sbplots = zeros(nshocks*nvars,1);
    fig_handle = FigSize; 
    for jj=1:nshocks
        for ii=1:nvars            
            kk = kk + 1;
            sbplots(kk) = subplot(row,col,ind(kk));                        
            if exist('INF','var') && exist('SUP','var')
                %plot(steps,INF(:,ii,jj),'LineStyle',':','Color',[0.39 0.58 0.93],'LineWidth',1.5);
                patch([steps fliplr(steps)], [INF(:,ii,jj)' fliplr(SUP(:,ii,jj)' )],[.9 .9 .9],'EdgeColor','white'); hold on;
                %plot(steps,SUP(:,ii,jj),'LineStyle',':','Color',[0.39 0.58 0.93],'LineWidth',1.5);
            end
            plot(x_axis,'k','LineWidth',0.5);
            plot(steps,IRF(:,ii,jj),'LineStyle','-','Color',[0.01 0.09 0.44],'LineWidth',1.5);
            %plot(steps,IRF(:,ii,jj),'LineStyle','-.','Color','k','LineWidth',2);
            
            xlim([1 nsteps]);
            %title([vnames{ii} ' to ' shock_names{jj}], 'FontWeight','bold','FontSize',10);
            %title([vnames{ii}], 'FontWeight','bold','FontSize',10);
            title([vnames{ii}], 'FontSize',10);
            
        end
    end
    if exist('sptitle')
        %suptitle(sptitle);
    end
