% Estimate Factors via Principal Components (Least Squares) from Fred_MD database
% 5-11-2017

clear all;
small = 1.0e-10;
big = 1.0e+6;
this_date = datestr(now,'yyyymmdd');

% -----  File Directories -- overhead, etc.
 outdir = 'out/';
 figdir = 'fig/';
 matdir = 'mat/';
 p_initial = path;
 utility_dir = 'm_utilities';
 path(utility_dir,p_initial);

% Location and Name of FRED_MD file
fredmd = '../data/fred_md_201704.xlsx';

% -- Sample Period from Fred_md Spreadsheet
[dnobs,calvec,calds] = calendar_make([1959 1],[2017 3],12);  % Monthly Calendar

% Read Variable Names
[blank, names] = xlsread(fredmd,1,'B1:DY1');
% Read Data transformations codes
[tcodes] = xlsread(fredmd,1,'B2:DY2');
% Read Data
[raw_data] = xlsread(fredmd,1,'B3:DY701');
% Transfrom Data
trans_data = NaN(size(raw_data));
trans_aoadj_data = NaN(size(raw_data));
for i = 1:size(raw_data,2);
    trans_data(:,i)=transx(raw_data(:,i),tcodes(i));
    trans_aoadj_data(:,i) = adjout(trans_data(:,i),5,0);
%     hh=figure;
%      subplot(2,2,1);
%        plot(calvec,raw_data(:,i));
%        title(names(i));
%      subplot(2,2,3);
%        plot(calvec,trans_data(:,i));
%       subplot(2,2,4);
%        plot(calvec,trans_aoadj_data(:,i));
%      tcodes(i)  
%      waitforbuttonpress;
%      close(hh);
end;
% Estimate Factors
% Factor Parameters

% Sampling parameters
est_par.smpl_par.calvec = calvec;         % calendar
est_par.smpl_par.nper   = 12;             % number of periods a year
est_par.smpl_par.nfirst = [1959 3];       % start date
est_par.smpl_par.nlast  = [2017 3];       % end date

% Factor analysis parameters
est_par.fac_par.lambda_constraints_est = 1;   % no constraints
est_par.fac_par.nt_min                  = 20;     % min number of obs for any series used to est factors
est_par.lambda.nt_min                   = 40;     % min number of obs for any series used to estimate lamba, irfs, etc.
est_par.fac_par.tol                     = 10^-8;  % precision of factor estimation (scaled by by n*t)
est_par.fac_par.nfac.observed           = 0;      % no observed factors;

nfac_min = 4;
nfac_max = 4;
for nfac = nfac_min:nfac_max;
    est_par.fac_par.nfac.unobserved = nfac;
    est_par.fac_par.nfac.total = est_par.fac_par.nfac.unobserved + est_par.fac_par.nfac.observed;
    lsout = factor_estimation_ls(trans_aoadj_data,est_par);
    factor_estimates = [calvec lsout.fac];
    str_tmp = [matdir 'factor_estimates_' num2str(nfac)];
    save(str_tmp,'factor_estimates'); 
end;  %Load Data end;

% Reset Path
path(p_initial);